/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.withholding.summary.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.withholding.summary.local.entity.WithholdingSummaryEntity;
import com.biz.crm.tpm.business.withholding.summary.local.mapper.TpmWithholdingSummaryMapper;
import com.biz.crm.tpm.business.withholding.summary.sdk.dto.WithholdingSummaryDto;
import com.biz.crm.tpm.business.withholding.summary.sdk.vo.TpmWithholdingDetailSummaryDetailRespVo;
import com.biz.crm.tpm.business.withholding.summary.sdk.vo.WithholdingSummaryFormulaVo;
import com.biz.crm.tpm.business.withholding.summary.sdk.vo.WithholdingSummaryROrgVo;
import com.biz.crm.tpm.business.withholding.summary.sdk.vo.WithholdingSummaryVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class TpmWithholdingSummaryRepository
extends ServiceImpl<TpmWithholdingSummaryMapper, WithholdingSummaryEntity> {
    @Autowired(required=false)
    private TpmWithholdingSummaryMapper tpmWithholdingSummaryMapper;

    public Page<WithholdingSummaryVo> findByConditions(Pageable pageable, WithholdingSummaryDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<WithholdingSummaryVo> pageList = this.tpmWithholdingSummaryMapper.findByConditions((Page<WithholdingSummaryVo>)page, dto, TenantUtils.getTenantCode());
        return pageList;
    }

    public WithholdingSummaryFormulaVo findHeadInfoByWithholdingFormulaCode(String withholdingFormulaCode) {
        WithholdingSummaryFormulaVo summaryFormulaVo;
        List<WithholdingSummaryFormulaVo> list = this.tpmWithholdingSummaryMapper.findHeadInfoByWithholdingFormulaCode(withholdingFormulaCode, TenantUtils.getTenantCode());
        WithholdingSummaryFormulaVo withholdingSummaryFormulaVo = summaryFormulaVo = CollectionUtils.isNotEmpty(list) ? list.get(0) : null;
        if (Objects.nonNull(summaryFormulaVo)) {
            List<WithholdingSummaryROrgVo> orgVoList = this.tpmWithholdingSummaryMapper.findFormulaOrgInfoByWithholdingFormulaCode(summaryFormulaVo.getWithholdingFormulaCode(), TenantUtils.getTenantCode());
            summaryFormulaVo.setOrgVoList(orgVoList);
        }
        return summaryFormulaVo;
    }

    public List<TpmWithholdingDetailSummaryDetailRespVo> findWithholdingDetailByYearMonth(String withholdingYearMonth, WithholdingSummaryFormulaVo withholdingSummaryFormulaVo, List<String> orgCodes) {
        return this.tpmWithholdingSummaryMapper.findWithholdingDetailByYearMonth(withholdingYearMonth, withholdingSummaryFormulaVo, orgCodes, TenantUtils.getTenantCode());
    }

    public List<WithholdingSummaryVo> findAutoSyncCeStateList(Pageable pageable, Date beginTime, Date endTime, List<String> ids) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.tpmWithholdingSummaryMapper.findAutoSyncCeStateList((Page<WithholdingSummaryVo>)page, beginTime, endTime, ids, TenantUtils.getTenantCode()).getRecords();
    }

    public Long countSummaryDetail(WithholdingSummaryDto dto, WithholdingSummaryFormulaVo withholdingSummaryFormulaVo, List<String> orgCodes, String salesOrgLevel) {
        return this.tpmWithholdingSummaryMapper.countSummaryDetail(dto, withholdingSummaryFormulaVo, orgCodes, salesOrgLevel, TenantUtils.getTenantCode());
    }

    public List<TpmWithholdingDetailSummaryDetailRespVo> findWithholdingDetailList(WithholdingSummaryDto dto, WithholdingSummaryFormulaVo withholdingSummaryFormulaVo, List<String> orgCodes, String salesOrgLevel) {
        return this.tpmWithholdingSummaryMapper.findWithholdingDetailList(dto, withholdingSummaryFormulaVo, orgCodes, salesOrgLevel, TenantUtils.getTenantCode());
    }

    public WithholdingSummaryEntity findByWithholdingUploadCode(String withholdingUploadCode) {
        return (WithholdingSummaryEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(WithholdingSummaryEntity::getWithholdingUploadCode, (Object)withholdingUploadCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).one());
    }

    public Integer countSummarySize(String withholdingFormulaCode, String withholdingYearMonth) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(WithholdingSummaryEntity::getWithholdingFormulaCode, (Object)withholdingFormulaCode)).eq(WithholdingSummaryEntity::getWithholdingYearMonth, (Object)withholdingYearMonth)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).count();
    }

    public void updateCeInfo(WithholdingSummaryVo vo, String state, String ceState) {
        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(WithholdingSummaryEntity.class).eq(UuidEntity::getId, (Object)vo.getId())).set(WithholdingSummaryEntity::getState, (Object)state)).set(WithholdingSummaryEntity::getCeState, (Object)ceState)).set(WithholdingSummaryEntity::getAccountingVoucherCode, (Object)vo.getAccountingVoucherCode()));
    }
}

