/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.withholding.summary.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.third.system.sap.fi.sdk.service.BcBpmCeWithholdingSummaryService;
import com.biz.crm.tpm.business.withholding.summary.local.entity.WithholdingSummaryDetailEntity;
import com.biz.crm.tpm.business.withholding.summary.local.entity.WithholdingSummaryEntity;
import com.biz.crm.tpm.business.withholding.summary.local.entity.WithholdingSummaryRDetailEntity;
import com.biz.crm.tpm.business.withholding.summary.local.entity.WithholdingSummaryROrgEntity;
import com.biz.crm.tpm.business.withholding.summary.local.repository.TpmWithholdingSummaryDetailRepository;
import com.biz.crm.tpm.business.withholding.summary.local.repository.TpmWithholdingSummaryRDetailRepository;
import com.biz.crm.tpm.business.withholding.summary.local.repository.TpmWithholdingSummaryROrgRepository;
import com.biz.crm.tpm.business.withholding.summary.local.repository.TpmWithholdingSummaryRepository;
import com.biz.crm.tpm.business.withholding.summary.local.util.WithholdingSummaryUtil;
import com.biz.crm.tpm.business.withholding.summary.sdk.constant.WithholdingSummaryStateEnum;
import com.biz.crm.tpm.business.withholding.summary.sdk.dto.WithholdingSummaryDetailDto;
import com.biz.crm.tpm.business.withholding.summary.sdk.dto.WithholdingSummaryDto;
import com.biz.crm.tpm.business.withholding.summary.sdk.dto.log.WithholdingSummaryLogEventDto;
import com.biz.crm.tpm.business.withholding.summary.sdk.event.WithholdingSummaryEventListener;
import com.biz.crm.tpm.business.withholding.summary.sdk.service.WithholdingSummaryService;
import com.biz.crm.tpm.business.withholding.summary.sdk.vo.WithholdingSummaryDetailVo;
import com.biz.crm.tpm.business.withholding.summary.sdk.vo.WithholdingSummaryFormulaVo;
import com.biz.crm.tpm.business.withholding.summary.sdk.vo.WithholdingSummaryROrgVo;
import com.biz.crm.tpm.business.withholding.summary.sdk.vo.WithholdingSummaryVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WithholdingSummaryAsyncService {
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private TpmWithholdingSummaryRepository tpmWithholdingSummaryRepository;
    @Autowired(required=false)
    private TpmWithholdingSummaryROrgRepository tpmWithholdingSummaryROrgRepository;
    @Autowired(required=false)
    private TpmWithholdingSummaryDetailRepository tpmWithholdingSummaryDetailRepository;
    @Autowired(required=false)
    private TpmWithholdingSummaryRDetailRepository tpmWithholdingSummaryRDetailRepository;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private BcBpmCeWithholdingSummaryService bcBpmCeWithholdingSummaryService;
    @Autowired(required=false)
    private WithholdingSummaryUtil withholdingSummaryUtil;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private WithholdingSummaryService withholdingSummaryService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    @Transactional
    public void create(WithholdingSummaryDto dto, AbstractCrmUserIdentity userIdentity) {
        try {
            this.loginUserService.refreshAuthentication((Object)userIdentity);
            WithholdingSummaryFormulaVo withholdingSummaryFormulaVo = this.tpmWithholdingSummaryRepository.findHeadInfoByWithholdingFormulaCode(dto.getWithholdingFormulaCode());
            List<WithholdingSummaryVo> withholdingSummaryVos = this.withholdingSummaryUtil.buildDetailList(withholdingSummaryFormulaVo, dto);
            Map unitMap = this.dictToolkitService.findMapByDictTypeCode("mdm_business_unit");
            withholdingSummaryVos.forEach(withholdingSummaryVo -> {
                WithholdingSummaryEntity withholdingSummaryEntity = (WithholdingSummaryEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)withholdingSummaryFormulaVo, WithholdingSummaryEntity.class, null, null, new String[0])));
                withholdingSummaryEntity.setWithholdingUploadCode(withholdingSummaryVo.getWithholdingUploadCode());
                withholdingSummaryEntity.setState(WithholdingSummaryStateEnum.SUBMIT.getDictCode());
                withholdingSummaryEntity.setBusinessUnitName((String)unitMap.get(withholdingSummaryEntity.getBusinessUnitCode()));
                withholdingSummaryEntity.setWithholdingYearMonth(dto.getWithholdingYearMonth());
                withholdingSummaryEntity.setTradeCurrency("CNY");
                withholdingSummaryEntity.setBusinessTitle(withholdingSummaryVo.getBusinessTitle());
                withholdingSummaryEntity.setBusinessTitleName(withholdingSummaryVo.getBusinessTitleName());
                withholdingSummaryEntity.setExchangeRate(BigDecimal.ONE);
                withholdingSummaryEntity.setWithholdingAmount(withholdingSummaryVo.getDetailVoList().stream().map(WithholdingSummaryDetailVo::getWithholdingAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
                withholdingSummaryEntity.setTenantCode(TenantUtils.getTenantCode());
                this.tpmWithholdingSummaryRepository.save((Object)withholdingSummaryEntity);
                this.tpmWithholdingSummaryDetailRepository.saveBatch(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)withholdingSummaryVo.getDetailVoList(), WithholdingSummaryDetailVo.class, WithholdingSummaryDetailEntity.class, HashSet.class, ArrayList.class, new String[0]));
                List salesOrgVos = this.salesOrgVoService.findAllChildrenBySalesOrgCodes(withholdingSummaryFormulaVo.getOrgVoList().stream().map(WithholdingSummaryROrgVo::getSalesOrgCode).collect(Collectors.toList()));
                List<String> orgCodes = salesOrgVos.stream().map(SalesOrgVo::getSalesOrgCode).collect(Collectors.toList());
                this.tpmWithholdingSummaryDetailRepository.insertRData(withholdingSummaryEntity.getWithholdingYearMonth(), withholdingSummaryFormulaVo, orgCodes, this.withholdingSummaryUtil.summaryOrgDimension(withholdingSummaryFormulaVo), withholdingSummaryEntity.getActivityTypeType(), withholdingSummaryEntity.getWithholdingUploadCode(), this.loginUserService.getAbstractLoginUser());
                List orgEntities = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)withholdingSummaryFormulaVo.getOrgVoList(), WithholdingSummaryROrgVo.class, WithholdingSummaryROrgEntity.class, HashSet.class, ArrayList.class, new String[0]);
                orgEntities.forEach(v -> v.setWithholdingUploadCode(withholdingSummaryVo.getWithholdingUploadCode()));
                this.tpmWithholdingSummaryROrgRepository.saveBatch(orgEntities);
                WithholdingSummaryLogEventDto logEventDto = new WithholdingSummaryLogEventDto();
                logEventDto.setOriginal(null);
                logEventDto.setNewest(dto);
                SerializableBiConsumer & Serializable onCreate = WithholdingSummaryEventListener::onCreate;
                this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, WithholdingSummaryEventListener.class, (SerializableBiConsumer)onCreate);
            });
        }
        finally {
            String lockKey = "tpm:withholding_summary_create:" + dto.getWithholdingFormulaCode() + ":" + dto.getWithholdingYearMonth();
            this.redisLockService.unlock(lockKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    @Transactional
    public void refresh(String id, AbstractCrmUserIdentity userIdentity) {
        try {
            this.loginUserService.refreshAuthentication((Object)userIdentity);
            WithholdingSummaryEntity withholdingSummaryEntity = (WithholdingSummaryEntity)((Object)this.tpmWithholdingSummaryRepository.getById((Serializable)((Object)id)));
            WithholdingSummaryVo oldVo = this.withholdingSummaryService.findById(id);
            this.tpmWithholdingSummaryDetailRepository.remove((Wrapper)Wrappers.lambdaUpdate(WithholdingSummaryDetailEntity.class).eq(WithholdingSummaryDetailEntity::getWithholdingUploadCode, (Object)withholdingSummaryEntity.getWithholdingUploadCode()));
            this.tpmWithholdingSummaryRDetailRepository.remove((Wrapper)Wrappers.lambdaUpdate(WithholdingSummaryRDetailEntity.class).eq(WithholdingSummaryRDetailEntity::getWithholdingUploadCode, (Object)withholdingSummaryEntity.getWithholdingUploadCode()));
            this.tpmWithholdingSummaryROrgRepository.remove((Wrapper)Wrappers.lambdaUpdate(WithholdingSummaryROrgEntity.class).eq(WithholdingSummaryROrgEntity::getWithholdingUploadCode, (Object)withholdingSummaryEntity.getWithholdingUploadCode()));
            WithholdingSummaryFormulaVo withholdingSummaryFormulaVo = this.tpmWithholdingSummaryRepository.findHeadInfoByWithholdingFormulaCode(withholdingSummaryEntity.getWithholdingFormulaCode());
            WithholdingSummaryDto dto = new WithholdingSummaryDto();
            dto.setWithholdingUploadCode(withholdingSummaryEntity.getWithholdingUploadCode());
            dto.setWithholdingYearMonth(withholdingSummaryEntity.getWithholdingYearMonth());
            dto.setWithholdingFormulaCode(withholdingSummaryEntity.getWithholdingFormulaCode());
            dto.setActivityTypeType(withholdingSummaryEntity.getActivityTypeType());
            List<WithholdingSummaryVo> withholdingSummaryVos = this.withholdingSummaryUtil.buildDetailList(withholdingSummaryFormulaVo, dto);
            WithholdingSummaryVo withholdingSummaryVo = withholdingSummaryVos.get(0);
            withholdingSummaryEntity.setState(WithholdingSummaryStateEnum.SUBMIT.getDictCode());
            withholdingSummaryEntity.setWithholdingAmount(withholdingSummaryVo.getDetailVoList().stream().map(WithholdingSummaryDetailVo::getWithholdingAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
            this.tpmWithholdingSummaryRepository.updateById((Object)withholdingSummaryEntity);
            this.tpmWithholdingSummaryDetailRepository.saveBatch(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)withholdingSummaryVo.getDetailVoList(), WithholdingSummaryDetailVo.class, WithholdingSummaryDetailEntity.class, HashSet.class, ArrayList.class, new String[0]));
            List salesOrgVos = this.salesOrgVoService.findAllChildrenBySalesOrgCodes(withholdingSummaryFormulaVo.getOrgVoList().stream().map(WithholdingSummaryROrgVo::getSalesOrgCode).collect(Collectors.toList()));
            List<String> orgCodes = salesOrgVos.stream().map(SalesOrgVo::getSalesOrgCode).collect(Collectors.toList());
            this.tpmWithholdingSummaryDetailRepository.insertRData(withholdingSummaryEntity.getWithholdingYearMonth(), withholdingSummaryFormulaVo, orgCodes, this.withholdingSummaryUtil.summaryOrgDimension(withholdingSummaryFormulaVo), withholdingSummaryEntity.getActivityTypeType(), withholdingSummaryEntity.getWithholdingUploadCode(), this.loginUserService.getAbstractLoginUser());
            List orgEntities = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)withholdingSummaryFormulaVo.getOrgVoList(), WithholdingSummaryROrgVo.class, WithholdingSummaryROrgEntity.class, HashSet.class, ArrayList.class, new String[0]);
            orgEntities.forEach(v -> v.setWithholdingUploadCode(withholdingSummaryEntity.getWithholdingUploadCode()));
            this.tpmWithholdingSummaryROrgRepository.saveBatch(orgEntities);
            String redisCacheKey = this.withholdingSummaryUtil.getRedisCacheKey(withholdingSummaryEntity.getWithholdingUploadCode());
            this.redisService.del(redisCacheKey);
            WithholdingSummaryVo newVo = this.withholdingSummaryService.findById(id);
            WithholdingSummaryDto newDto = (WithholdingSummaryDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)newVo, WithholdingSummaryDto.class, HashSet.class, ArrayList.class, new String[0]);
            if (CollectionUtils.isNotEmpty((Collection)newDto.getDetailDtoList())) {
                Collection newDetailList = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)newVo.getDetailVoList(), WithholdingSummaryDetailVo.class, WithholdingSummaryDetailDto.class, HashSet.class, ArrayList.class, new String[0]);
                newDto.setDetailDtoList((List)Lists.newArrayList((Iterable)newDetailList));
            }
            WithholdingSummaryLogEventDto logEventDto = new WithholdingSummaryLogEventDto();
            logEventDto.setOriginal(oldVo);
            logEventDto.setNewest(newDto);
            SerializableBiConsumer & Serializable onUpdate = WithholdingSummaryEventListener::onUpdate;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, WithholdingSummaryEventListener.class, (SerializableBiConsumer)onUpdate);
        }
        finally {
            String lockKey = "tpm:withholding_summary_lock:" + id;
            this.redisLockService.unlock(lockKey);
        }
    }
}

