/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.withholding.summary.local.service.internal;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.withholding.summary.sdk.dto.WithholdingSummaryJobParamDto;
import com.biz.crm.tpm.business.withholding.summary.sdk.service.WithholdingSummaryService;
import com.biz.crm.tpm.business.withholding.summary.sdk.vo.WithholdingSummaryVo;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class WithholdingSummaryCeStateAutoSyncXxlJob {
    private static final Logger log = LoggerFactory.getLogger(WithholdingSummaryCeStateAutoSyncXxlJob.class);
    @Autowired(required=false)
    private WithholdingSummaryService withholdingSummaryService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DynamicTaskService(cornExpression="0 0 2 2-5 * ?", taskDesc="\u540c\u6b65CE\u5355\u636e\u72b6\u6001\u5b9a\u65f6\u4efb\u52a1")
    public void autoSyncCeState() {
        log.info("=====>    \u540c\u6b65CE\u5355\u636e\u72b6\u6001[{}] start    <=====", (Object)DateUtil.dateStrNowAll());
        this.loginUserService.refreshAuthentication(null);
        String lockKey = "tpm:withholding_summary_auto_lock";
        try {
            PageRequest page = PageRequest.of((int)1, (int)50);
            int index = 1;
            boolean hasLock = this.redisLockService.tryLock(lockKey, TimeUnit.SECONDS, 43200L);
            if (!hasLock) {
                log.error("\u540c\u6b65CE\u5355\u636e\u72b6\u6001\u8fdb\u884c\u4e2d\uff01");
                return;
            }
            WithholdingSummaryJobParamDto dto = new WithholdingSummaryJobParamDto();
            while (true) {
                List list = this.withholdingSummaryService.findAutoSyncCeStateList((Pageable)page, dto);
                log.info("\u540c\u6b65CE\u5355\u636e\u72b6\u6001\uff1a\u7b2c[{}]\u9875\u67e5\u8be2\u5230[{}]\u6761\u6570\u636e\uff01", (Object)index, (Object)list.size());
                if (CollectionUtils.isEmpty((Collection)list)) {
                    break;
                }
                int k = 1;
                for (WithholdingSummaryVo v : list) {
                    try {
                        this.withholdingSummaryService.autoSyncCeState(v, Boolean.valueOf(false));
                        ++k;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        log.error("\u540c\u6b65CE\u5355\u636e\u72b6\u6001\u5931\u8d25\uff01\u7b2c[{}]\u9875\uff0c\u7b2c[{}]\u6761,{}", new Object[]{index, k, e.getMessage()});
                    }
                }
                page = PageRequest.of((int)(++index), (int)50);
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.redisLockService.unlock(lockKey);
        }
        log.info("=====>    \u540c\u6b65CE\u5355\u636e\u72b6\u6001[{}] end    <=====", (Object)DateUtil.dateStrNowAll());
    }
}

