/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.withholding.summary.local.service.internal;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.UuidCrmUtil;
import com.biz.crm.mn.third.system.sap.fi.sdk.dto.BcBpmCeWithholdingSummaryDto;
import com.biz.crm.mn.third.system.sap.fi.sdk.dto.BcBpmCeWithholdingSummaryStateDto;
import com.biz.crm.mn.third.system.sap.fi.sdk.service.BcBpmCeWithholdingSummaryService;
import com.biz.crm.mn.third.system.sap.fi.sdk.vo.BcBpmCeWithholdingSummaryStateVo;
import com.biz.crm.mn.third.system.sap.fi.sdk.vo.BcBpmCeWithholdingSummaryVo;
import com.biz.crm.tpm.business.withholding.summary.local.entity.WithholdingSummaryDetailEntity;
import com.biz.crm.tpm.business.withholding.summary.local.entity.WithholdingSummaryEntity;
import com.biz.crm.tpm.business.withholding.summary.local.entity.WithholdingSummaryROrgEntity;
import com.biz.crm.tpm.business.withholding.summary.local.repository.TpmWithholdingSummaryDetailRepository;
import com.biz.crm.tpm.business.withholding.summary.local.repository.TpmWithholdingSummaryRDetailRepository;
import com.biz.crm.tpm.business.withholding.summary.local.repository.TpmWithholdingSummaryROrgRepository;
import com.biz.crm.tpm.business.withholding.summary.local.repository.TpmWithholdingSummaryRepository;
import com.biz.crm.tpm.business.withholding.summary.local.util.WithholdingSummaryUtil;
import com.biz.crm.tpm.business.withholding.summary.sdk.constant.WithholdingSummaryCeStateEnum;
import com.biz.crm.tpm.business.withholding.summary.sdk.constant.WithholdingSummaryStateEnum;
import com.biz.crm.tpm.business.withholding.summary.sdk.dto.WithholdingSummaryDetailDto;
import com.biz.crm.tpm.business.withholding.summary.sdk.dto.WithholdingSummaryDto;
import com.biz.crm.tpm.business.withholding.summary.sdk.dto.WithholdingSummaryJobParamDto;
import com.biz.crm.tpm.business.withholding.summary.sdk.dto.WithholdingSummaryROrgDto;
import com.biz.crm.tpm.business.withholding.summary.sdk.dto.log.WithholdingSummaryLogEventDto;
import com.biz.crm.tpm.business.withholding.summary.sdk.event.WithholdingSummaryEventListener;
import com.biz.crm.tpm.business.withholding.summary.sdk.service.WithholdingSummaryService;
import com.biz.crm.tpm.business.withholding.summary.sdk.vo.WithholdingSummaryDetailVo;
import com.biz.crm.tpm.business.withholding.summary.sdk.vo.WithholdingSummaryFormulaVo;
import com.biz.crm.tpm.business.withholding.summary.sdk.vo.WithholdingSummaryROrgVo;
import com.biz.crm.tpm.business.withholding.summary.sdk.vo.WithholdingSummaryVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service(value="withholdingSummaryService")
public class WithholdingSummaryServiceInternalImpl
implements WithholdingSummaryService {
    private static final Logger log = LoggerFactory.getLogger(WithholdingSummaryServiceInternalImpl.class);
    @Autowired(required=false)
    private TpmWithholdingSummaryRepository tpmWithholdingSummaryRepository;
    @Autowired(required=false)
    private TpmWithholdingSummaryROrgRepository tpmWithholdingSummaryROrgRepository;
    @Autowired(required=false)
    private TpmWithholdingSummaryDetailRepository tpmWithholdingSummaryDetailRepository;
    @Autowired(required=false)
    private TpmWithholdingSummaryRDetailRepository tpmWithholdingSummaryRDetailRepository;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private BcBpmCeWithholdingSummaryService bcBpmCeWithholdingSummaryService;
    @Autowired(required=false)
    private WithholdingSummaryUtil withholdingSummaryUtil;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;

    public Page<WithholdingSummaryVo> findByConditions(Pageable pageable, WithholdingSummaryDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new WithholdingSummaryDto();
        }
        return this.tpmWithholdingSummaryRepository.findByConditions(pageable, dto);
    }

    public WithholdingSummaryVo findById(String id) {
        List<WithholdingSummaryDetailEntity> detailEntities;
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        WithholdingSummaryEntity withholdingSummaryEntity = (WithholdingSummaryEntity)((Object)this.tpmWithholdingSummaryRepository.getById((Serializable)((Object)id)));
        Validate.notNull((Object)((Object)withholdingSummaryEntity), (String)"\u672a\u67e5\u8be2\u5230\u9884\u63d0\u6c47\u603b\u4fe1\u606f", (Object[])new Object[0]);
        WithholdingSummaryVo withholdingSummaryVo = (WithholdingSummaryVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)withholdingSummaryEntity, WithholdingSummaryVo.class, null, null, new String[0]);
        List<WithholdingSummaryROrgEntity> orgEntities = this.tpmWithholdingSummaryROrgRepository.findByWithholdingUploadCode(withholdingSummaryEntity.getWithholdingUploadCode());
        if (!CollectionUtils.isEmpty(orgEntities)) {
            Collection orgVoList = this.nebulaToolkitService.copyCollectionByBlankList(orgEntities, WithholdingSummaryROrgEntity.class, WithholdingSummaryROrgVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            withholdingSummaryVo.setOrgVoList((List)orgVoList);
        }
        if (!CollectionUtils.isEmpty(detailEntities = this.tpmWithholdingSummaryDetailRepository.findByWithholdingUploadCode(withholdingSummaryEntity.getWithholdingUploadCode()))) {
            Collection detailVoList = this.nebulaToolkitService.copyCollectionByBlankList(detailEntities, WithholdingSummaryDetailEntity.class, WithholdingSummaryDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            withholdingSummaryVo.setDetailVoList((List)detailVoList);
        }
        withholdingSummaryVo.setCacheKey(UuidCrmUtil.general() + ":" + withholdingSummaryVo.getWithholdingUploadCode());
        return withholdingSummaryVo;
    }

    public WithholdingSummaryVo findMainByCode(String uploadCode) {
        if (StringUtils.isBlank((CharSequence)uploadCode)) {
            return null;
        }
        WithholdingSummaryEntity withholdingSummaryEntity = this.tpmWithholdingSummaryRepository.findByWithholdingUploadCode(uploadCode);
        Validate.notNull((Object)((Object)withholdingSummaryEntity), (String)"\u672a\u67e5\u8be2\u5230\u9884\u63d0\u6c47\u603b\u4fe1\u606f", (Object[])new Object[0]);
        return (WithholdingSummaryVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)withholdingSummaryEntity, WithholdingSummaryVo.class, null, null, new String[0]);
    }

    @Transactional
    public void create(WithholdingSummaryDto dto) {
        this.checkCreate(dto);
        WithholdingSummaryFormulaVo withholdingSummaryFormulaVo = this.tpmWithholdingSummaryRepository.findHeadInfoByWithholdingFormulaCode(dto.getWithholdingFormulaCode());
        List<WithholdingSummaryVo> withholdingSummaryVos = this.withholdingSummaryUtil.buildDetailList(withholdingSummaryFormulaVo, dto);
        Map unitMap = this.dictToolkitService.findMapByDictTypeCode("mdm_business_unit");
        withholdingSummaryVos.forEach(withholdingSummaryVo -> {
            WithholdingSummaryEntity withholdingSummaryEntity = (WithholdingSummaryEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)withholdingSummaryFormulaVo, WithholdingSummaryEntity.class, null, null, new String[0])));
            withholdingSummaryEntity.setWithholdingUploadCode(withholdingSummaryVo.getWithholdingUploadCode());
            withholdingSummaryEntity.setActivityTypeType(withholdingSummaryVo.getActivityTypeType());
            withholdingSummaryEntity.setBusinessTitle(withholdingSummaryVo.getBusinessTitle());
            withholdingSummaryEntity.setBusinessTitleName(withholdingSummaryVo.getBusinessTitleName());
            withholdingSummaryEntity.setState(WithholdingSummaryStateEnum.SUBMIT.getDictCode());
            withholdingSummaryEntity.setBusinessUnitName((String)unitMap.get(withholdingSummaryEntity.getBusinessUnitCode()));
            withholdingSummaryEntity.setWithholdingYearMonth(dto.getWithholdingYearMonth());
            withholdingSummaryEntity.setTradeCurrency("CNY");
            withholdingSummaryEntity.setExchangeRate(BigDecimal.ONE);
            withholdingSummaryEntity.setWithholdingAmount(withholdingSummaryVo.getDetailVoList().stream().map(WithholdingSummaryDetailVo::getWithholdingAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
            withholdingSummaryEntity.setTenantCode(TenantUtils.getTenantCode());
            this.tpmWithholdingSummaryRepository.save((Object)withholdingSummaryEntity);
            this.tpmWithholdingSummaryDetailRepository.saveBatch(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)withholdingSummaryVo.getDetailVoList(), WithholdingSummaryDetailVo.class, WithholdingSummaryDetailEntity.class, HashSet.class, ArrayList.class, new String[0]));
            List salesOrgVos = this.salesOrgVoService.findAllChildrenBySalesOrgCodes(withholdingSummaryFormulaVo.getOrgVoList().stream().map(WithholdingSummaryROrgVo::getSalesOrgCode).collect(Collectors.toList()));
            List<String> orgCodes = salesOrgVos.stream().map(SalesOrgVo::getSalesOrgCode).collect(Collectors.toList());
            this.tpmWithholdingSummaryDetailRepository.insertRData(withholdingSummaryEntity.getWithholdingYearMonth(), withholdingSummaryFormulaVo, orgCodes, this.withholdingSummaryUtil.summaryOrgDimension(withholdingSummaryFormulaVo), withholdingSummaryEntity.getActivityTypeType(), withholdingSummaryEntity.getWithholdingUploadCode(), this.loginUserService.getAbstractLoginUser());
            this.tpmWithholdingSummaryROrgRepository.saveBatch(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)withholdingSummaryVo.getOrgVoList(), WithholdingSummaryROrgVo.class, WithholdingSummaryROrgEntity.class, HashSet.class, ArrayList.class, new String[0]));
            WithholdingSummaryLogEventDto logEventDto = new WithholdingSummaryLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(dto);
            SerializableBiConsumer & Serializable onCreate = WithholdingSummaryEventListener::onCreate;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, WithholdingSummaryEventListener.class, (SerializableBiConsumer)onCreate);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void update(WithholdingSummaryDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        this.withholdingSummaryUtil.valUpdate(dto);
        String lockKey = "tpm:withholding_summary_lock:" + dto.getId();
        boolean hasLock = this.redisLockService.tryLock(lockKey, TimeUnit.SECONDS, 300L);
        Validate.isTrue((boolean)hasLock, (String)"\u9884\u63d0\u6c47\u603b\u6570\u636e\u6b63\u5728\u88ab\u64cd\u4f5c\u4e2d\uff0c\u8bf7\u7a0d\u540e\uff01", (Object[])new Object[0]);
        try {
            WithholdingSummaryEntity withholdingSummaryEntity = (WithholdingSummaryEntity)((Object)this.tpmWithholdingSummaryRepository.getById((Serializable)((Object)dto.getId())));
            Validate.isTrue((Objects.nonNull((Object)withholdingSummaryEntity) && StringUtils.equals((CharSequence)DelFlagStatusEnum.NORMAL.getCode(), (CharSequence)withholdingSummaryEntity.getDelFlag()) ? 1 : 0) != 0, (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
            Validate.isTrue((boolean)WithholdingSummaryStateEnum.editState((String)withholdingSummaryEntity.getState()), (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u7f16\u8f91\uff01", (Object[])new Object[0]);
            this.withholdingSummaryUtil.valUpdateExtend(dto.getDetailDtoList(), withholdingSummaryEntity.getActivityTypeType(), 1);
            dto.setWithholdingYearMonth(withholdingSummaryEntity.getWithholdingYearMonth());
            dto.setWithholdingUploadCode(withholdingSummaryEntity.getWithholdingUploadCode());
            dto.setWithholdingFormulaCode(withholdingSummaryEntity.getWithholdingFormulaCode());
            WithholdingSummaryVo oldVo = this.findById(dto.getId());
            List<WithholdingSummaryDetailVo> detailList = this.withholdingSummaryUtil.buildUpdateDetailList(dto);
            BigDecimal withholdingAmount = detailList.stream().map(WithholdingSummaryDetailVo::getWithholdingAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            Validate.isTrue((withholdingSummaryEntity.getWithholdingAmount().compareTo(withholdingAmount) == 0 ? 1 : 0) != 0, (String)"\u660e\u7ec6\u4e2d[\u4e0d\u542b\u7a0e\u91d1\u989d]\u603b\u548c\u4e0d\u7b49\u4e8e\u9884\u63d0\u91d1\u989d\uff01", (Object[])new Object[0]);
            withholdingSummaryEntity.setExpenseContent(dto.getExpenseContent());
            withholdingSummaryEntity.setProfitCenter(dto.getProfitCenter());
            withholdingSummaryEntity.setTradeCurrency(dto.getTradeCurrency());
            withholdingSummaryEntity.setExchangeRate(dto.getExchangeRate());
            this.tpmWithholdingSummaryRepository.updateById((Object)withholdingSummaryEntity);
            this.tpmWithholdingSummaryDetailRepository.removeByWithholdingUploadCode(withholdingSummaryEntity.getWithholdingUploadCode());
            this.tpmWithholdingSummaryDetailRepository.saveBatch(this.nebulaToolkitService.copyCollectionByWhiteList(detailList, WithholdingSummaryDetailVo.class, WithholdingSummaryDetailEntity.class, HashSet.class, ArrayList.class, new String[0]));
            this.tpmWithholdingSummaryROrgRepository.removeByWithholdingUploadCode(withholdingSummaryEntity.getWithholdingUploadCode());
            this.tpmWithholdingSummaryROrgRepository.saveBatch(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getOrgVoList(), WithholdingSummaryROrgDto.class, WithholdingSummaryROrgEntity.class, HashSet.class, ArrayList.class, new String[0]));
            String redisCacheKey = this.withholdingSummaryUtil.getRedisCacheKey(withholdingSummaryEntity.getWithholdingUploadCode());
            this.redisService.del(redisCacheKey);
            WithholdingSummaryLogEventDto logEventDto = new WithholdingSummaryLogEventDto();
            logEventDto.setOriginal(oldVo);
            logEventDto.setNewest(dto);
            SerializableBiConsumer & Serializable onUpdate = WithholdingSummaryEventListener::onUpdate;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, WithholdingSummaryEventListener.class, (SerializableBiConsumer)onUpdate);
        }
        finally {
            this.redisLockService.unlock(lockKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ArrayList lockKeys = new ArrayList();
        idList.forEach(id -> {
            String lockKey = "tpm:withholding_summary_lock:" + id;
            boolean hasLock = this.redisLockService.tryLock(lockKey, TimeUnit.SECONDS, 300L);
            Validate.isTrue((boolean)hasLock, (String)"\u9884\u63d0\u6c47\u603b\u6570\u636e\u6b63\u5728\u88ab\u64cd\u4f5c\u4e2d\uff0c\u8bf7\u7a0d\u540e\uff01", (Object[])new Object[0]);
            lockKeys.add(lockKey);
        });
        try {
            List withholdingSummaryEntityList1 = this.tpmWithholdingSummaryRepository.listByIds(idList);
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)withholdingSummaryEntityList1) ? 1 : 0) != 0, (String)"\u5220\u9664\u65f6\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            ArrayList withholdingSummaryEntityList = new ArrayList();
            ArrayList withholdingSummaryLogEventDtoList = new ArrayList();
            withholdingSummaryEntityList1.forEach(item -> {
                Validate.isTrue((!StringUtils.equals((CharSequence)WithholdingSummaryStateEnum.PASS.getDictCode(), (CharSequence)item.getState()) ? 1 : 0) != 0, (String)"\u9884\u63d0\u4e0a\u4f20\u7f16\u7801[%s]\u6c47\u603b\u72b6\u6001[CE\u901a\u8fc7]\uff0c\u6682\u4e0d\u652f\u6301\u5220\u9664\uff01", (Object[])new Object[]{item.getWithholdingUploadCode()});
                WithholdingSummaryEntity withholdingSummaryEntity = new WithholdingSummaryEntity();
                withholdingSummaryEntity.setId(item.getId());
                withholdingSummaryEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
                withholdingSummaryEntityList.add(withholdingSummaryEntity);
                WithholdingSummaryLogEventDto logEventDto = new WithholdingSummaryLogEventDto();
                WithholdingSummaryVo oldVo = (WithholdingSummaryVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, WithholdingSummaryVo.class, null, null, new String[0]);
                logEventDto.setOriginal(oldVo);
                WithholdingSummaryDto withholdingSummaryDto = (WithholdingSummaryDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, WithholdingSummaryDto.class, null, null, new String[0]);
                withholdingSummaryDto.setDelFlag(withholdingSummaryEntity.getDelFlag());
                logEventDto.setNewest(withholdingSummaryDto);
                withholdingSummaryLogEventDtoList.add(logEventDto);
            });
            SerializableBiConsumer & Serializable onDelete = WithholdingSummaryEventListener::onDelete;
            withholdingSummaryLogEventDtoList.forEach(log -> this.nebulaNetEventClient.publish((NebulaEventDto)log, WithholdingSummaryEventListener.class, onDelete));
            this.tpmWithholdingSummaryRepository.updateBatchById(withholdingSummaryEntityList);
        }
        finally {
            lockKeys.forEach(lockKey -> this.redisLockService.unlock(lockKey));
        }
    }

    @Transactional
    public void refresh(String id) {
        this.checkRefresh(id);
        WithholdingSummaryEntity withholdingSummaryEntity = (WithholdingSummaryEntity)((Object)this.tpmWithholdingSummaryRepository.getById((Serializable)((Object)id)));
        WithholdingSummaryVo oldVo = this.findById(id);
        this.tpmWithholdingSummaryDetailRepository.removeByWithholdingUploadCode(withholdingSummaryEntity.getWithholdingUploadCode());
        this.tpmWithholdingSummaryRDetailRepository.removeByWithholdingUploadCode(withholdingSummaryEntity.getWithholdingUploadCode());
        this.tpmWithholdingSummaryROrgRepository.removeByWithholdingUploadCode(withholdingSummaryEntity.getWithholdingUploadCode());
        WithholdingSummaryFormulaVo withholdingSummaryFormulaVo = this.tpmWithholdingSummaryRepository.findHeadInfoByWithholdingFormulaCode(withholdingSummaryEntity.getWithholdingFormulaCode());
        WithholdingSummaryDto dto = new WithholdingSummaryDto();
        dto.setWithholdingUploadCode(withholdingSummaryEntity.getWithholdingUploadCode());
        dto.setWithholdingYearMonth(withholdingSummaryEntity.getWithholdingYearMonth());
        dto.setWithholdingFormulaCode(withholdingSummaryEntity.getWithholdingFormulaCode());
        dto.setActivityTypeType(withholdingSummaryEntity.getActivityTypeType());
        List<WithholdingSummaryVo> withholdingSummaryVos = this.withholdingSummaryUtil.buildDetailList(withholdingSummaryFormulaVo, dto);
        WithholdingSummaryVo withholdingSummaryVo = withholdingSummaryVos.get(0);
        withholdingSummaryEntity.setState(WithholdingSummaryStateEnum.SUBMIT.getDictCode());
        withholdingSummaryEntity.setWithholdingAmount(withholdingSummaryVo.getDetailVoList().stream().map(WithholdingSummaryDetailVo::getWithholdingAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        this.tpmWithholdingSummaryRepository.updateById((Object)withholdingSummaryEntity);
        this.tpmWithholdingSummaryDetailRepository.saveBatch(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)withholdingSummaryVo.getDetailVoList(), WithholdingSummaryDetailVo.class, WithholdingSummaryDetailEntity.class, HashSet.class, ArrayList.class, new String[0]));
        List salesOrgVos = this.salesOrgVoService.findAllChildrenBySalesOrgCodes(withholdingSummaryFormulaVo.getOrgVoList().stream().map(WithholdingSummaryROrgVo::getSalesOrgCode).collect(Collectors.toList()));
        List<String> orgCodes = salesOrgVos.stream().map(SalesOrgVo::getSalesOrgCode).collect(Collectors.toList());
        this.tpmWithholdingSummaryDetailRepository.insertRData(withholdingSummaryEntity.getWithholdingYearMonth(), withholdingSummaryFormulaVo, orgCodes, this.withholdingSummaryUtil.summaryOrgDimension(withholdingSummaryFormulaVo), withholdingSummaryEntity.getActivityTypeType(), withholdingSummaryEntity.getWithholdingUploadCode(), this.loginUserService.getAbstractLoginUser());
        this.tpmWithholdingSummaryROrgRepository.saveBatch(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)withholdingSummaryFormulaVo.getOrgVoList(), WithholdingSummaryROrgVo.class, WithholdingSummaryROrgEntity.class, HashSet.class, ArrayList.class, new String[0]));
        String redisCacheKey = this.withholdingSummaryUtil.getRedisCacheKey(withholdingSummaryEntity.getWithholdingUploadCode());
        this.redisService.del(redisCacheKey);
        WithholdingSummaryVo newVo = this.findById(id);
        WithholdingSummaryDto newDto = (WithholdingSummaryDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)newVo, WithholdingSummaryDto.class, HashSet.class, ArrayList.class, new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)newDto.getDetailDtoList())) {
            Collection newDetailList = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)newVo.getDetailVoList(), WithholdingSummaryDetailVo.class, WithholdingSummaryDetailDto.class, HashSet.class, ArrayList.class, new String[0]);
            newDto.setDetailDtoList((List)Lists.newArrayList((Iterable)newDetailList));
        }
        WithholdingSummaryLogEventDto logEventDto = new WithholdingSummaryLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(newDto);
        SerializableBiConsumer & Serializable onUpdate = WithholdingSummaryEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, WithholdingSummaryEventListener.class, (SerializableBiConsumer)onUpdate);
    }

    @Transactional
    public void upload(String id, FacturerUserDetails loginDetails) {
        WithholdingSummaryEntity withholdingSummaryEntity = (WithholdingSummaryEntity)((Object)this.tpmWithholdingSummaryRepository.getById((Serializable)((Object)id)));
        Validate.isTrue((Objects.nonNull((Object)withholdingSummaryEntity) && StringUtils.equals((CharSequence)DelFlagStatusEnum.NORMAL.getCode(), (CharSequence)withholdingSummaryEntity.getDelFlag()) ? 1 : 0) != 0, (String)"\u6c47\u603b\u4e0a\u4f20\u7f16\u7801[%s]\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[]{withholdingSummaryEntity.getWithholdingUploadCode()});
        Validate.isTrue((!StringUtils.equals((CharSequence)WithholdingSummaryStateEnum.UPLOAD.getDictCode(), (CharSequence)withholdingSummaryEntity.getState()) ? 1 : 0) != 0, (String)"\u6c47\u603b\u4e0a\u4f20\u7f16\u7801[%s]\uff0c\u72b6\u6001[\u5df2\u4e0a\u4f20]\uff0c\u8bf7\u52ff\u91cd\u590d\u4e0a\u4f20\uff01", (Object[])new Object[]{withholdingSummaryEntity.getWithholdingUploadCode()});
        Validate.isTrue((!StringUtils.equals((CharSequence)WithholdingSummaryStateEnum.PASS.getDictCode(), (CharSequence)withholdingSummaryEntity.getState()) ? 1 : 0) != 0, (String)"\u6c47\u603b\u4e0a\u4f20\u7f16\u7801[%s]\uff0c\u72b6\u6001[CE\u901a\u8fc7]\uff0c\u8bf7\u52ff\u4e0a\u4f20\uff01", (Object[])new Object[]{withholdingSummaryEntity.getWithholdingUploadCode()});
        Validate.isTrue((!StringUtils.equals((CharSequence)WithholdingSummaryStateEnum.REJECT.getDictCode(), (CharSequence)withholdingSummaryEntity.getState()) ? 1 : 0) != 0, (String)"\u6c47\u603b\u4e0a\u4f20\u7f16\u7801[%s]\uff0c\u72b6\u6001[CE\u9a73\u56de]\uff0c\u8bf7\u52ff\u4e0a\u4f20\uff01", (Object[])new Object[]{withholdingSummaryEntity.getWithholdingUploadCode()});
        WithholdingSummaryVo withholdingSummaryVo = this.findById(id);
        this.withholdingSummaryUtil.validateUploadParam(withholdingSummaryVo);
        BcBpmCeWithholdingSummaryDto dto = this.withholdingSummaryUtil.buildUploadParam(withholdingSummaryVo, loginDetails);
        Result result = this.bcBpmCeWithholdingSummaryService.uploadSummary(dto);
        if (!result.isSuccess()) {
            throw new RuntimeException("\u6c47\u603b\u4e0a\u4f20\u7f16\u7801[" + withholdingSummaryEntity.getWithholdingUploadCode() + "]\u4e0a\u4f20CE\u5931\u8d25\uff1a" + result.getMessage());
        }
        BcBpmCeWithholdingSummaryVo ceResultVo = (BcBpmCeWithholdingSummaryVo)JSONArray.parseObject((String)result.getResult().toString(), BcBpmCeWithholdingSummaryVo.class);
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)"S", (CharSequence)ceResultVo.getMSG_CODE()), (String)"\u6c47\u603b\u4e0a\u4f20\u7f16\u7801[%s]\u4e0a\u4f20CE\u5931\u8d25\uff1a%s", (Object[])new Object[]{withholdingSummaryEntity.getWithholdingUploadCode(), ceResultVo.getMSG()});
        Validate.isTrue((boolean)Objects.nonNull(ceResultVo.getPROCESS_INSTANCEID()), (String)"\u6c47\u603b\u4e0a\u4f20\u7f16\u7801[%s]\u4e0a\u4f20CE\u5931\u8d25\uff1aCE\u5355\u636e\u7f16\u53f7\u8fd4\u56de\u7a7a", (Object[])new Object[]{withholdingSummaryEntity.getWithholdingUploadCode()});
        withholdingSummaryEntity.setWithholdingCeCode(ceResultVo.getPROCESS_INSTANCEID().toString());
        withholdingSummaryEntity.setState(WithholdingSummaryStateEnum.UPLOAD.getDictCode());
        this.tpmWithholdingSummaryRepository.updateById((Object)withholdingSummaryEntity);
    }

    public void addItemCache(String cacheKey, List<WithholdingSummaryDetailDto> saveList) {
        if (CollectionUtils.isEmpty(saveList)) {
            saveList = Lists.newArrayList();
        }
        Collection detailVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)saveList, WithholdingSummaryDetailDto.class, WithholdingSummaryDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
        String redisCacheKey = this.withholdingSummaryUtil.getRedisCacheKey(cacheKey);
        ArrayList newList = Lists.newArrayList((Iterable)detailVos);
        WithholdingSummaryDetailVo detailVo = new WithholdingSummaryDetailVo();
        newList.add(detailVo);
        this.redisService.del(redisCacheKey);
        this.redisService.lPushAll(redisCacheKey, Long.valueOf(86400L), newList.toArray());
    }

    public void deleteItemCache(String cacheKey, List<WithholdingSummaryDetailDto> saveList) {
        saveList = saveList.stream().filter(e -> !StringUtils.equals((CharSequence)"1", (CharSequence)e.getChecked())).collect(Collectors.toList());
        Collection detailVos = this.nebulaToolkitService.copyCollectionByWhiteList(saveList, WithholdingSummaryDetailDto.class, WithholdingSummaryDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
        String redisCacheKey = this.withholdingSummaryUtil.getRedisCacheKey(cacheKey);
        ArrayList newList = Lists.newArrayList((Iterable)detailVos);
        this.redisService.del(redisCacheKey);
        this.redisService.lPushAll(redisCacheKey, Long.valueOf(86400L), newList.toArray());
    }

    public void saveCurrentPageCache(String cacheKey, List<WithholdingSummaryDetailDto> saveList) {
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }
        Collection detailVos = this.nebulaToolkitService.copyCollectionByWhiteList(saveList, WithholdingSummaryDetailDto.class, WithholdingSummaryDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
        String redisCacheKey = this.withholdingSummaryUtil.getRedisCacheKey(cacheKey);
        ArrayList newList = Lists.newArrayList((Iterable)detailVos);
        this.redisService.del(redisCacheKey);
        this.redisService.lPushAll(redisCacheKey, Long.valueOf(86400L), newList.toArray());
    }

    public Page<WithholdingSummaryDetailVo> findCachePageList(Pageable pageable, String cacheKey, String withholdingUploadCode) {
        List<WithholdingSummaryDetailEntity> list;
        String redisCacheKey = this.withholdingSummaryUtil.getRedisCacheKey(cacheKey);
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        page.setTotal(0L);
        page.setRecords((List)Lists.newArrayList());
        if (this.redisService.hasKey(redisCacheKey).booleanValue()) {
            Long total = this.redisService.lSize(redisCacheKey);
            page.setTotal(total.longValue());
            List objects = this.redisService.lRange(redisCacheKey, page.offset(), page.offset() + page.getSize() - 1L);
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)objects)) {
                List detailVos = objects;
                page.setRecords(detailVos);
            }
        } else if (StringUtils.isNotEmpty((CharSequence)withholdingUploadCode) && !CollectionUtils.isEmpty(list = this.tpmWithholdingSummaryDetailRepository.findByWithholdingUploadCode(withholdingUploadCode))) {
            list.sort(Comparator.comparing(WithholdingSummaryDetailEntity::getWithholdingDetailCode));
            Collection detailVoList = this.nebulaToolkitService.copyCollectionByBlankList(list, WithholdingSummaryDetailEntity.class, WithholdingSummaryDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            this.redisService.lPushAll(redisCacheKey, Long.valueOf(86400L), detailVoList.toArray());
            page.setTotal((long)detailVoList.size());
            page.setRecords((List)detailVoList);
        }
        return page;
    }

    public List<WithholdingSummaryDetailVo> findCacheList(String cacheKey) {
        String redisCacheKey = this.withholdingSummaryUtil.getRedisCacheKey(cacheKey);
        if (!this.redisService.hasKey(redisCacheKey).booleanValue()) {
            return Lists.newArrayList();
        }
        List objects = this.redisService.lRange(redisCacheKey, 0L, -1L);
        return objects;
    }

    public Integer getTotal(String cacheKey) {
        String redisCacheKey = "tpm:withholding_summary_item_cache:" + cacheKey;
        return this.redisService.lSize(redisCacheKey).intValue();
    }

    public List<WithholdingSummaryVo> findAutoSyncCeStateList(Pageable pageable, WithholdingSummaryJobParamDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (Objects.isNull(dto.getBeginTime())) {
            dto.setBeginTime(sdf.parse(LocalDateTime.now().with(TemporalAdjusters.firstDayOfMonth()).format(formatter)));
        }
        if (Objects.isNull(dto.getEndTime())) {
            dto.setEndTime(sdf.parse(LocalDateTime.now().format(formatter)));
        }
        return this.tpmWithholdingSummaryRepository.findAutoSyncCeStateList(pageable, dto.getBeginTime(), dto.getEndTime(), dto.getIds());
    }

    @Transactional
    public void autoSyncCeState(WithholdingSummaryVo vo, Boolean throwError) {
        String state;
        BcBpmCeWithholdingSummaryStateDto dto = new BcBpmCeWithholdingSummaryStateDto();
        dto.setPROCESS_INSTANCEID(vo.getWithholdingCeCode());
        Result result = this.bcBpmCeWithholdingSummaryService.getSummaryState(dto);
        log.info("\u9884\u63d0\u6c47\u603b\u4e0a\u4f20\u7f16\u7801[{}],\u540c\u6b65CE\u5355\u636e\u72b6\u6001\u8fd4\u56de\uff1a{}", (Object)vo.getWithholdingUploadCode(), (Object)JSONObject.toJSONString((Object)result));
        if (!result.isSuccess()) {
            String msg = "\u9884\u63d0\u6c47\u603b\u4e0a\u4f20\u7f16\u7801[" + vo.getWithholdingUploadCode() + "],\u540c\u6b65CE\u5355\u636e\u72b6\u6001\u5931\u8d25\uff1a" + result.getMessage();
            Validate.isTrue((throwError == false ? 1 : 0) != 0, (String)msg, (Object[])new Object[0]);
            log.error(msg);
            return;
        }
        BcBpmCeWithholdingSummaryStateVo ceResultVo = (BcBpmCeWithholdingSummaryStateVo)JSONArray.parseObject((String)result.getResult().toString(), BcBpmCeWithholdingSummaryStateVo.class);
        if (!StringUtils.equals((CharSequence)"S", (CharSequence)ceResultVo.getMSG_CODE())) {
            String msg = "\u9884\u63d0\u6c47\u603b\u4e0a\u4f20\u7f16\u7801[" + vo.getWithholdingUploadCode() + "],\u540c\u6b65CE\u5355\u636e\u72b6\u6001\u8fd4\u56de\u7ed3\u679c\u5931\u8d25\uff0cCE\u9519\u8bef\u4fe1\u606f\uff1a" + ceResultVo.getMSG();
            Validate.isTrue((throwError == false ? 1 : 0) != 0, (String)msg, (Object[])new Object[0]);
            log.error(msg);
            return;
        }
        if (Objects.isNull(ceResultVo.getITEM1()) || CollectionUtils.isEmpty((Collection)ceResultVo.getITEM1())) {
            String msg = "\u9884\u63d0\u6c47\u603b\u4e0a\u4f20\u7f16\u7801[" + vo.getWithholdingUploadCode() + "],\u540c\u6b65CE\u5355\u636e\u72b6\u6001\u5931\u8d25\uff1a[ITEM1] CE\u8fd4\u56de\u4e3a\u7a7a";
            Validate.isTrue((throwError == false ? 1 : 0) != 0, (String)msg, (Object[])new Object[0]);
            log.error(msg);
            return;
        }
        List item1 = ceResultVo.getITEM1();
        BcBpmCeWithholdingSummaryStateVo.ITEM1 item = (BcBpmCeWithholdingSummaryStateVo.ITEM1)item1.get(0);
        String processStatus = item.getPROCESS_STATUS();
        if (StringUtils.isEmpty((CharSequence)processStatus)) {
            String msg = "\u9884\u63d0\u6c47\u603b\u4e0a\u4f20\u7f16\u7801[" + vo.getWithholdingUploadCode() + "],\u540c\u6b65CE\u5355\u636e\u72b6\u6001\u5931\u8d25\uff1a[ITEM1.PROCESS_STATUS] CE\u8fd4\u56de\u4e3a\u7a7a";
            Validate.isTrue((throwError == false ? 1 : 0) != 0, (String)msg, (Object[])new Object[0]);
            log.error(msg);
            return;
        }
        WithholdingSummaryCeStateEnum summaryCeStateEnum = WithholdingSummaryCeStateEnum.codeToEnum((String)processStatus);
        if (Objects.isNull(summaryCeStateEnum)) {
            String msg = "\u9884\u63d0\u6c47\u603b\u4e0a\u4f20\u7f16\u7801[" + vo.getWithholdingUploadCode() + "]\uff0c\u540c\u6b65CE\u5355\u636e\u72b6\u6001\u5931\u8d25\uff1a[ITEM1.PROCESS_STATUS]\u72b6\u6001\u503c[" + processStatus + "]\u5728TPM\u7cfb\u7edf\u672a\u5b9a\u4e49";
            Validate.isTrue((throwError == false ? 1 : 0) != 0, (String)msg, (Object[])new Object[0]);
            log.error(msg);
            return;
        }
        String accountingVoucherNumber = null;
        if (StringUtils.equals((CharSequence)WithholdingSummaryCeStateEnum.APPROVING.getDictCode(), (CharSequence)summaryCeStateEnum.getDictCode())) {
            state = WithholdingSummaryStateEnum.UPLOAD.getDictCode();
        } else if (StringUtils.equals((CharSequence)WithholdingSummaryCeStateEnum.FINISH.getDictCode(), (CharSequence)summaryCeStateEnum.getDictCode())) {
            state = WithholdingSummaryStateEnum.PASS.getDictCode();
            accountingVoucherNumber = item.getFY_VOUCHER_NO();
        } else if (StringUtils.equals((CharSequence)WithholdingSummaryCeStateEnum.REJECT.getDictCode(), (CharSequence)summaryCeStateEnum.getDictCode())) {
            state = WithholdingSummaryStateEnum.REJECT.getDictCode();
        } else if (StringUtils.equals((CharSequence)WithholdingSummaryCeStateEnum.CANCEL.getDictCode(), (CharSequence)summaryCeStateEnum.getDictCode())) {
            state = WithholdingSummaryStateEnum.CANCEL.getDictCode();
        } else {
            String msg = "\u9884\u63d0\u6c47\u603b\u4e0a\u4f20\u7f16\u7801[" + vo.getWithholdingUploadCode() + "]\uff0c\u540c\u6b65CE\u5355\u636e\u72b6\u6001\u5931\u8d25\uff1aTPM\u7cfb\u7edf\u672a\u5b9a\u4e49CE\u5355\u636e\u72b6\u6001[" + summaryCeStateEnum.getDictCode() + "]\u4e0eTPM\u72b6\u6001\u5bf9\u5e94\u5173\u7cfb";
            Validate.isTrue((throwError == false ? 1 : 0) != 0, (String)msg, (Object[])new Object[0]);
            log.error(msg);
            return;
        }
        if (StringUtils.isNotEmpty(accountingVoucherNumber)) {
            String[] split = accountingVoucherNumber.split(":");
            accountingVoucherNumber = split.length == 2 ? split[1] : accountingVoucherNumber;
        }
        vo.setAccountingVoucherCode(accountingVoucherNumber);
        this.tpmWithholdingSummaryRepository.updateCeInfo(vo, state, summaryCeStateEnum.getDictCode());
    }

    public void checkCreate(WithholdingSummaryDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        this.withholdingSummaryUtil.valCreate(dto);
        int count = this.tpmWithholdingSummaryRepository.countSummarySize(dto.getWithholdingFormulaCode(), dto.getWithholdingYearMonth());
        Validate.isTrue((count == 0 ? 1 : 0) != 0, (String)"\u9884\u63d0\u6c47\u603b\u89c4\u5219[%s]\uff0c\u9884\u63d0\u5e74\u6708[%s]\u5df2\u5b58\u5728\u6c47\u603b\uff0c\u65e0\u6cd5\u65b0\u589e\uff01", (Object[])new Object[]{dto.getWithholdingFormulaCode(), dto.getWithholdingYearMonth()});
        this.withholdingSummaryUtil.checkDetailCount(dto);
    }

    public void checkRefresh(String id) {
        WithholdingSummaryEntity withholdingSummaryEntity = (WithholdingSummaryEntity)((Object)this.tpmWithholdingSummaryRepository.getById((Serializable)((Object)id)));
        Validate.isTrue((Objects.nonNull((Object)withholdingSummaryEntity) && StringUtils.equals((CharSequence)DelFlagStatusEnum.NORMAL.getCode(), (CharSequence)withholdingSummaryEntity.getDelFlag()) ? 1 : 0) != 0, (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        Validate.isTrue((!StringUtils.equals((CharSequence)WithholdingSummaryStateEnum.UPLOAD.getDictCode(), (CharSequence)withholdingSummaryEntity.getState()) ? 1 : 0) != 0, (String)"\u9884\u63d0\u4e0a\u4f20\u7f16\u7801[%s]\uff0c\u72b6\u6001[\u5df2\u4e0a\u4f20]\uff0c\u6682\u4e0d\u652f\u6301\u66f4\u65b0\uff01", (Object[])new Object[]{withholdingSummaryEntity.getWithholdingUploadCode()});
        Validate.isTrue((!StringUtils.equals((CharSequence)WithholdingSummaryStateEnum.PASS.getDictCode(), (CharSequence)withholdingSummaryEntity.getState()) ? 1 : 0) != 0, (String)"\u9884\u63d0\u4e0a\u4f20\u7f16\u7801[%s]\uff0c\u72b6\u6001[CE\u901a\u8fc7]\uff0c\u6682\u4e0d\u652f\u6301\u66f4\u65b0\uff01", (Object[])new Object[]{withholdingSummaryEntity.getWithholdingUploadCode()});
        Validate.isTrue((!StringUtils.equals((CharSequence)WithholdingSummaryStateEnum.REJECT.getDictCode(), (CharSequence)withholdingSummaryEntity.getState()) ? 1 : 0) != 0, (String)"\u9884\u63d0\u4e0a\u4f20\u7f16\u7801[%s]\uff0c\u72b6\u6001[CE\u9a73\u56de]\uff0c\u6682\u4e0d\u652f\u6301\u66f4\u65b0\uff01", (Object[])new Object[]{withholdingSummaryEntity.getWithholdingUploadCode()});
        WithholdingSummaryDto dto = new WithholdingSummaryDto();
        dto.setWithholdingFormulaCode(withholdingSummaryEntity.getWithholdingFormulaCode());
        dto.setWithholdingYearMonth(withholdingSummaryEntity.getWithholdingYearMonth());
        dto.setActivityTypeType(withholdingSummaryEntity.getActivityTypeType());
        this.withholdingSummaryUtil.checkDetailCount(dto);
    }
}

