/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.withholding.summary.local.util;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.businessunit.sdk.service.MdmBusinessUnitVoService;
import com.biz.crm.mdm.business.businessunit.sdk.vo.MdmBusinessUnitVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.sales.org.sdk.enums.SalesOrgLevelTypeEnum;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.third.system.sap.fi.sdk.dto.BcBpmCeWithholdingSummaryDto;
import com.biz.crm.tpm.business.withholding.summary.local.entity.WithholdingSummaryDetailEntity;
import com.biz.crm.tpm.business.withholding.summary.local.repository.TpmWithholdingSummaryDetailRepository;
import com.biz.crm.tpm.business.withholding.summary.local.repository.TpmWithholdingSummaryRepository;
import com.biz.crm.tpm.business.withholding.summary.sdk.constant.WithholdingSummaryActivityTypeTypeEnum;
import com.biz.crm.tpm.business.withholding.summary.sdk.constant.WithholdingSummarySupplierTypeEnum;
import com.biz.crm.tpm.business.withholding.summary.sdk.constant.YesOrNoEnum;
import com.biz.crm.tpm.business.withholding.summary.sdk.dto.WithholdingSummaryDetailDto;
import com.biz.crm.tpm.business.withholding.summary.sdk.dto.WithholdingSummaryDto;
import com.biz.crm.tpm.business.withholding.summary.sdk.dto.WithholdingSummaryROrgDto;
import com.biz.crm.tpm.business.withholding.summary.sdk.vo.TpmWithholdingDetailSummaryDetailRespVo;
import com.biz.crm.tpm.business.withholding.summary.sdk.vo.WithholdingSummaryDetailVo;
import com.biz.crm.tpm.business.withholding.summary.sdk.vo.WithholdingSummaryFormulaVo;
import com.biz.crm.tpm.business.withholding.summary.sdk.vo.WithholdingSummaryROrgVo;
import com.biz.crm.tpm.business.withholding.summary.sdk.vo.WithholdingSummaryVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class WithholdingSummaryUtil {
    private static final Logger log = LoggerFactory.getLogger(WithholdingSummaryUtil.class);
    @Autowired(required=false)
    private TpmWithholdingSummaryRepository tpmWithholdingSummaryRepository;
    @Autowired(required=false)
    private TpmWithholdingSummaryDetailRepository tpmWithholdingSummaryDetailRepository;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private MdmBusinessUnitVoService mdmBusinessUnitVoService;

    public void valCreate(WithholdingSummaryDto dto) {
        Validate.notNull((Object)dto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        dto.setId(null);
        Validate.notBlank((CharSequence)dto.getTenantCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getWithholdingFormulaCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9884\u63d0\u6c47\u603b\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getWithholdingFormulaName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9884\u63d0\u6c47\u603b\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getWithholdingYearMonth(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9884\u63d0\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    public List<WithholdingSummaryVo> buildDetailList(WithholdingSummaryFormulaVo withholdingSummaryFormulaVo, WithholdingSummaryDto dto) {
        MdmBusinessUnitVo businessUnitVo = this.mdmBusinessUnitVoService.findByCode(withholdingSummaryFormulaVo.getBusinessUnitCode());
        BigDecimal taxRate = Objects.nonNull(businessUnitVo.getTaxRatio()) ? businessUnitVo.getTaxRatio() : BigDecimal.ONE;
        Validate.isTrue((taxRate.compareTo(BigDecimal.ZERO) != 0 ? 1 : 0) != 0, (String)"\u7a0e\u7387\u914d\u7f6e\u5f02\u5e38\uff1a\u7a0e\u7387\u4e3a0", (Object[])new Object[0]);
        String salesOrgLevel = this.summaryOrgDimension(withholdingSummaryFormulaVo);
        List salesOrgVos = this.salesOrgVoService.findAllChildrenBySalesOrgCodes(withholdingSummaryFormulaVo.getOrgVoList().stream().map(WithholdingSummaryROrgVo::getSalesOrgCode).collect(Collectors.toList()));
        List<String> orgCodes = salesOrgVos.stream().map(SalesOrgVo::getSalesOrgCode).collect(Collectors.toList());
        List<TpmWithholdingDetailSummaryDetailRespVo> detailRespVos = this.tpmWithholdingSummaryRepository.findWithholdingDetailList(dto, withholdingSummaryFormulaVo, orgCodes, salesOrgLevel);
        log.info("\u67e5\u8be2\u9884\u63d0\u660e\u7ec6\u5e76\u6c47\u603b====>" + detailRespVos.size());
        orgCodes = detailRespVos.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getSalesOrgCode())).map(TpmWithholdingDetailSummaryDetailRespVo::getSalesOrgCode).distinct().collect(Collectors.toList());
        salesOrgVos = this.salesOrgVoService.findBySalesOrgCodes(orgCodes);
        HashMap<String, SalesOrgVo> salesOrgVoMap = new HashMap<String, SalesOrgVo>();
        if (!CollectionUtils.isEmpty((Collection)salesOrgVos)) {
            salesOrgVoMap.putAll(salesOrgVos.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, v -> v, (v1, v2) -> v2)));
        }
        List detailVoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(detailRespVos, TpmWithholdingDetailSummaryDetailRespVo.class, WithholdingSummaryDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (!StringUtils.equals((CharSequence)YesOrNoEnum.YES.getCode(), (CharSequence)withholdingSummaryFormulaVo.getDiffActivityType())) {
            log.info("\u6c47\u603b\u6570\u91cf\uff08\u4e0d\u533a\u5206\u6d3b\u52a8\u7c7b\u578b\uff09====>" + detailVoList.size());
            return Lists.newArrayList((Object[])new WithholdingSummaryVo[]{this.createDetailList(withholdingSummaryFormulaVo, detailVoList, salesOrgVoMap, taxRate, null)});
        }
        Map<String, List<WithholdingSummaryDetailVo>> mapList = detailVoList.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getActivityTypeType())).collect(Collectors.groupingBy(WithholdingSummaryDetailVo::getActivityTypeType));
        ArrayList<WithholdingSummaryVo> resultList = new ArrayList<WithholdingSummaryVo>();
        mapList.forEach((key, list) -> {
            WithholdingSummaryVo summaryVo = this.createDetailList(withholdingSummaryFormulaVo, (List<WithholdingSummaryDetailVo>)list, (Map<String, SalesOrgVo>)salesOrgVoMap, taxRate, (String)key);
            summaryVo.setActivityTypeType(key);
            resultList.add(summaryVo);
        });
        log.info("\u6c47\u603b\u6570\u91cf\uff08\u533a\u5206\u6d3b\u52a8\u7c7b\u578b\uff09====>" + resultList.size());
        return resultList;
    }

    public WithholdingSummaryVo createDetailList(WithholdingSummaryFormulaVo withholdingSummaryFormulaVo, List<WithholdingSummaryDetailVo> detailVoList, Map<String, SalesOrgVo> salesOrgVoMap, BigDecimal taxRate, String activityTypeType) {
        WithholdingSummaryVo summaryVo = new WithholdingSummaryVo();
        String withholdingUploadCode = (String)this.generateCodeService.generateCode("YT", 1, Integer.valueOf(6), 2L, TimeUnit.DAYS).get(0);
        summaryVo.setWithholdingUploadCode(withholdingUploadCode);
        WithholdingSummaryActivityTypeTypeEnum activityTypeTypeEnum = WithholdingSummaryActivityTypeTypeEnum.activityTypeTypeToBusinessTitle((String)activityTypeType);
        summaryVo.setBusinessTitle(activityTypeTypeEnum.getBusinessTitle());
        summaryVo.setBusinessTitleName(activityTypeTypeEnum.getBusinessTitleName());
        detailVoList.forEach(v -> {
            String withholdingDetailCode = (String)this.generateCodeService.generateCode("YTHZ", 1, Integer.valueOf(6), 2L, TimeUnit.DAYS).get(0);
            v.setWithholdingDetailCode(withholdingDetailCode);
            v.setBusinessExpItem(activityTypeTypeEnum.getBusinessExpItemDefault());
            v.setQuantity(v.getQuantity().setScale(2, RoundingMode.HALF_DOWN));
            v.setWithholdingAmount(v.getWithholdingTaxAmount().setScale(2, RoundingMode.HALF_DOWN));
            if (Objects.nonNull(v.getQuantity()) && BigDecimal.ZERO.compareTo(v.getQuantity()) != 0) {
                v.setPrice(v.getWithholdingAmount().divide(v.getQuantity(), 8, RoundingMode.HALF_DOWN));
            } else {
                v.setPrice(BigDecimal.ZERO);
            }
            v.setEstimateTaxAmount(BigDecimal.ZERO);
            v.setAttachmentNum(BigDecimal.ZERO);
            v.setPromotionAmount(BigDecimal.ZERO);
            v.setTenantCode(TenantUtils.getTenantCode());
            v.setWithholdingUploadCode(summaryVo.getWithholdingUploadCode());
            if (WithholdingSummaryActivityTypeTypeEnum.personnel_cost.getDictCode().equals(activityTypeType)) {
                v.setContractCode(withholdingSummaryFormulaVo.getContractCode());
                v.setContractName(withholdingSummaryFormulaVo.getContractName());
            }
            if (StringUtils.isNotEmpty((CharSequence)v.getSalesOrgCode()) && salesOrgVoMap.containsKey(v.getSalesOrgCode())) {
                v.setSaleOrgName(((SalesOrgVo)salesOrgVoMap.get(v.getSalesOrgCode())).getSalesOrgName());
            }
        });
        List orgVoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)withholdingSummaryFormulaVo.getOrgVoList(), WithholdingSummaryROrgVo.class, WithholdingSummaryROrgVo.class, HashSet.class, ArrayList.class, new String[0]);
        orgVoList.forEach(v -> {
            v.setWithholdingUploadCode(summaryVo.getWithholdingUploadCode());
            v.setTenantCode(TenantUtils.getTenantCode());
        });
        summaryVo.setDetailVoList(detailVoList);
        summaryVo.setOrgVoList(orgVoList);
        return summaryVo;
    }

    public void valUpdate(WithholdingSummaryDto dto) {
        Validate.notNull((Object)dto, (String)"\u7f16\u8f91\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getTenantCode(), (String)"\u7f16\u8f91\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u7f16\u8f91\u65f6\uff0c\u6570\u636eID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getProfitCenter(), (String)"\u7f16\u8f91\u65f6\uff0c\u5229\u6da6\u4e2d\u5fc3\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getExchangeRate(), (String)"\u7f16\u8f91\u65f6\uff0c\u6c47\u7387\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getTradeCurrency(), (String)"\u7f16\u8f91\u65f6\uff0c\u4ea4\u6613\u8d27\u5e01\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getExpenseContent(), (String)"\u7f16\u8f91\u65f6\uff0c\u5f00\u652f\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Map merchantsTypeMap = this.dictToolkitService.findMapByDictTypeCode("tpm_merchants_type");
        List accruedAccountList = this.dictToolkitService.tree("tpm_accrued_account");
        Map<Object, Object> accruedAccountMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty((Collection)accruedAccountList)) {
            accruedAccountMap = accruedAccountList.stream().collect(Collectors.toMap(DictDataVo::getDictCode, v -> v));
        }
        int index = 1;
        for (WithholdingSummaryDetailDto v2 : dto.getDetailDtoList()) {
            Validate.notBlank((CharSequence)v2.getBusinessExpItem(), (String)"\u660e\u7ec6\u4fe1\u606f\u7b2c[%s]\u884c\uff0c[\u4e1a\u52a1\u7ec6\u7c7b]\u4e3a\u7a7a\uff01", (Object[])new Object[]{index});
            Validate.isTrue((boolean)accruedAccountMap.containsKey(v2.getBusinessExpItem()), (String)"\u660e\u7ec6\u4fe1\u606f\u7b2c[%s]\u884c\uff0c\u4e1a\u52a1\u7ec6\u7c7b[%s]\u5728\u6570\u636e\u5b57\u5178[%s]\u4e2d\u672a\u7ef4\u62a4\uff01", (Object[])new Object[]{index, v2.getBusinessExpItem(), "tpm_accrued_account"});
            DictDataVo businessExpItemDictVo = (DictDataVo)accruedAccountMap.get(v2.getBusinessExpItem());
            Validate.isTrue((Objects.nonNull(businessExpItemDictVo.getExtendMap()) && businessExpItemDictVo.getExtendMap().containsKey("yes_or_no") ? 1 : 0) != 0, (String)"\u660e\u7ec6\u4fe1\u606f\u7b2c[%s]\u884c\uff0c\u4e1a\u52a1\u7ec6\u7c7b[%s]\u5728\u6570\u636e\u5b57\u5178[%s]\u4e2d\u672a\u7ef4\u62a4\u662f\u5426\u5fc5\u586b\u5ba2\u5546\u7c7b\u578b\uff01", (Object[])new Object[]{index, v2.getBusinessExpItem(), "tpm_accrued_account"});
            boolean needSupplier = StringUtils.equals((CharSequence)YesOrNoEnum.YES.getCode(), (CharSequence)((CharSequence)businessExpItemDictVo.getExtendMap().get("yes_or_no")));
            if (needSupplier) {
                Validate.notBlank((CharSequence)v2.getCustomerClassifyCode(), (String)"\u660e\u7ec6\u4fe1\u606f\u7b2c[%s]\u884c\uff0c[\u5ba2\u5546\u5206\u7c7b\u7f16\u7801]\u4e3a\u7a7a\uff01", (Object[])new Object[]{index});
                Validate.isTrue((boolean)merchantsTypeMap.containsKey(v2.getCustomerClassifyCode()), (String)"\u660e\u7ec6\u4fe1\u606f\u7b2c[%s]\u884c\uff0c[\u5ba2\u5546\u7c7b\u578b]\u4e0d\u5b58\u5728\uff01", (long)index);
                v2.setCustomerClassifyName((String)merchantsTypeMap.get(v2.getCustomerClassifyCode()));
                Validate.notBlank((CharSequence)v2.getSupplierCode(), (String)"\u660e\u7ec6\u4fe1\u606f\u7b2c[%s]\u884c\uff0c[\u5ba2\u5546\u7f16\u7801]\u4e3a\u7a7a\uff01", (Object[])new Object[]{index});
                Validate.notBlank((CharSequence)v2.getSupplierName(), (String)"\u660e\u7ec6\u4fe1\u606f\u7b2c[%s]\u884c\uff0c[\u5ba2\u5546\u540d\u79f0]\u4e3a\u7a7a\uff01", (Object[])new Object[]{index});
            } else {
                Validate.isTrue((boolean)StringUtils.isEmpty((CharSequence)v2.getCustomerClassifyCode()), (String)"\u660e\u7ec6\u4fe1\u606f\u7b2c[%s]\u884c\uff0c\u4e1a\u52a1\u7ec6\u7c7b[%s]\u4e0d\u5141\u8bb8\u5f55\u5165\u5ba2\u5546\u4fe1\u606f\uff01", (Object[])new Object[]{index, businessExpItemDictVo.getDictValue()});
                v2.setCustomerClassifyName("");
                Validate.isTrue((boolean)StringUtils.isEmpty((CharSequence)v2.getSupplierCode()), (String)"\u660e\u7ec6\u4fe1\u606f\u7b2c[%s]\u884c\uff0c\u4e1a\u52a1\u7ec6\u7c7b[%s]\u4e0d\u5141\u8bb8\u5f55\u5165\u5ba2\u5546\u4fe1\u606f\uff01", (Object[])new Object[]{index, businessExpItemDictVo.getDictValue()});
                Validate.isTrue((boolean)StringUtils.isEmpty((CharSequence)v2.getSupplierName()), (String)"\u660e\u7ec6\u4fe1\u606f\u7b2c[%s]\u884c\uff0c\u4e1a\u52a1\u7ec6\u7c7b[%s]\u4e0d\u5141\u8bb8\u5f55\u5165\u5ba2\u5546\u4fe1\u606f\uff01", (Object[])new Object[]{index, businessExpItemDictVo.getDictValue()});
            }
            if (StringUtils.isNotEmpty((CharSequence)v2.getActivityFormCode())) {
                Validate.notBlank((CharSequence)v2.getActivityFormName(), (String)"\u660e\u7ec6\u4fe1\u606f\u7b2c[%s]\u884c\uff0c[\u6d3b\u52a8\u5f62\u5f0f\u540d\u79f0]\u4e3a\u7a7a\uff01", (Object[])new Object[]{index});
            }
            if (StringUtils.isNotEmpty((CharSequence)v2.getCustomerCode())) {
                Validate.notBlank((CharSequence)v2.getCustomerName(), (String)"\u660e\u7ec6\u4fe1\u606f\u7b2c[%s]\u884c\uff0c[\u5ba2\u6237\u540d\u79f0]\u4e3a\u7a7a\uff01", (Object[])new Object[]{index});
            }
            Validate.notBlank((CharSequence)v2.getCostCenter(), (String)"\u660e\u7ec6\u4fe1\u606f\u7b2c[%s]\u884c\uff0c[\u6210\u672c\u4e2d\u5fc3\u7f16\u7801]\u4e3a\u7a7a\uff01", (Object[])new Object[]{index});
            Validate.notBlank((CharSequence)v2.getCostCenterName(), (String)"\u660e\u7ec6\u4fe1\u606f\u7b2c[%s]\u884c\uff0c[\u6210\u672c\u4e2d\u5fc3\u540d\u79f0]\u4e3a\u7a7a\uff01", (Object[])new Object[]{index});
            Validate.isTrue((boolean)Objects.nonNull(v2.getWithholdingAmount()), (String)"\u660e\u7ec6\u4fe1\u606f\u7b2c[%s]\u884c\uff0c[\u4e0d\u542b\u7a0e\u91d1\u989d]\u4e3a\u7a7a\uff01", (long)index);
            Validate.isTrue((boolean)Objects.nonNull(v2.getEstimateTaxAmount()), (String)"\u660e\u7ec6\u4fe1\u606f\u7b2c[%s]\u884c\uff0c[\u6682\u4f30\u7a0e\u91d1]\u4e3a\u7a7a\uff01", (long)index);
            Validate.isTrue((boolean)Objects.nonNull(v2.getAttachmentNum()), (String)"\u660e\u7ec6\u4fe1\u606f\u7b2c[%s]\u884c\uff0c[\u9644\u4ef6\u5f20\u6570]\u4e3a\u7a7a\uff01", (long)index);
            ++index;
        }
    }

    public void valUpdateExtend(List<WithholdingSummaryDetailDto> detailDtoList, String activityTypeType, int index) {
        if (StringUtils.isEmpty((CharSequence)activityTypeType)) {
            return;
        }
        for (WithholdingSummaryDetailDto v : detailDtoList) {
            if (!WithholdingSummaryActivityTypeTypeEnum.personnel_cost.getDictCode().equals(activityTypeType)) {
                v.setQuantity(null);
                v.setPrice(null);
                v.setContractCode("");
                v.setContractName("");
            } else {
                Validate.notNull((Object)v.getQuantity(), (String)"\u7b2c[%s]\u884c,\u6570\u91cf\u4e3a\u7a7a\uff01", (Object[])new Object[]{index});
                Validate.notBlank((CharSequence)v.getContractCode(), (String)"\u7b2c[%s]\u884c,\u5408\u540c\u7f16\u7801\u4e3a\u7a7a\uff01", (Object[])new Object[]{index});
                Validate.notBlank((CharSequence)v.getContractName(), (String)"\u7b2c[%s]\u884c,\u5408\u540c\u540d\u79f0\u4e3a\u7a7a\uff01", (Object[])new Object[]{index});
            }
            ++index;
        }
    }

    public List<WithholdingSummaryDetailVo> buildUpdateDetailList(WithholdingSummaryDto dto) {
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)dto.getDetailDtoList()) ? 1 : 0) != 0, (String)"\u7f3a\u5c11\u6c47\u603b\u660e\u7ec6\u4fe1\u606f\uff01", (Object[])new Object[0]);
        List detailCodeList = ((LambdaQueryChainWrapper)this.tpmWithholdingSummaryDetailRepository.lambdaQuery().eq(WithholdingSummaryDetailEntity::getWithholdingUploadCode, (Object)dto.getWithholdingUploadCode())).select(new SFunction[]{WithholdingSummaryDetailEntity::getWithholdingDetailCode}).list().stream().map(WithholdingSummaryDetailEntity::getWithholdingDetailCode).collect(Collectors.toList());
        int index = 1;
        for (WithholdingSummaryDetailDto v : dto.getDetailDtoList()) {
            if (StringUtils.isNotEmpty((CharSequence)v.getWithholdingDetailCode())) {
                Validate.isTrue((boolean)detailCodeList.contains(v.getWithholdingDetailCode()), (String)"\u660e\u7ec6\u4fe1\u606f\u7b2c[%s]\u884c\uff0c\u9884\u63d0\u660e\u7ec6\u7f16\u53f7[%s]\u9700\u7531\u7cfb\u7edf\u751f\u6210\uff0c\u8bf7\u52ff\u624b\u52a8\u586b\u5199\uff01", (Object[])new Object[]{index, v.getWithholdingDetailCode()});
            }
            ++index;
        }
        for (WithholdingSummaryDetailDto v : dto.getDetailDtoList()) {
            if (!StringUtils.isEmpty((CharSequence)v.getWithholdingDetailCode())) continue;
            String withholdingDetailCode = (String)this.generateCodeService.generateCode("YTHZ", 1, Integer.valueOf(6), 2L, TimeUnit.DAYS).get(0);
            v.setWithholdingDetailCode(withholdingDetailCode);
        }
        Collection detailVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getDetailDtoList(), WithholdingSummaryDetailDto.class, WithholdingSummaryDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
        detailVos.forEach(detail -> {
            if (StringUtils.isEmpty((CharSequence)detail.getCustomerClassifyCode())) {
                detail.setCustomerClassifyName("");
                detail.setSupplierCode("");
                detail.setSupplierName("");
            }
            detail.setEstimateTaxAmount(detail.getEstimateTaxAmount().setScale(2, RoundingMode.HALF_DOWN));
            detail.setWithholdingAmount(detail.getWithholdingAmount().setScale(2, RoundingMode.HALF_DOWN));
            detail.setWithholdingTaxAmount(detail.getEstimateTaxAmount().add(detail.getWithholdingAmount()).setScale(2, RoundingMode.HALF_DOWN));
            if (Objects.nonNull(detail.getQuantity()) && BigDecimal.ZERO.compareTo(detail.getQuantity()) != 0) {
                detail.setPrice(detail.getWithholdingAmount().divide(detail.getQuantity(), 8, RoundingMode.HALF_DOWN));
            } else {
                detail.setPrice(BigDecimal.ZERO);
            }
            if (StringUtils.equals((CharSequence)"supplier", (CharSequence)detail.getCustomerClassifyCode())) {
                detail.setSpecialTag("M");
            } else {
                detail.setSpecialTag("");
            }
            detail.setTenantCode(TenantUtils.getTenantCode());
        });
        for (WithholdingSummaryROrgDto v : dto.getOrgVoList()) {
            v.setWithholdingUploadCode(dto.getWithholdingUploadCode());
            v.setTenantCode(TenantUtils.getTenantCode());
        }
        return Lists.newArrayList((Iterable)detailVos);
    }

    public void validateUploadParam(WithholdingSummaryVo withholdingSummaryVo) {
        Validate.notBlank((CharSequence)withholdingSummaryVo.getSalesOrgCode(), (String)"\u6c47\u603b\u4e0a\u4f20\u7f16\u7801[%s]\uff0c\u9500\u552e\u7ec4\u7ec7\u7f16\u7801\u4e3a\u7a7a\uff01", (Object[])new Object[]{withholdingSummaryVo.getWithholdingUploadCode()});
        Validate.notBlank((CharSequence)withholdingSummaryVo.getProfitCenter(), (String)"\u6c47\u603b\u4e0a\u4f20\u7f16\u7801[%s]\uff0c\u5229\u6da6\u4e2d\u5fc3\u4e3a\u7a7a\uff01", (Object[])new Object[]{withholdingSummaryVo.getWithholdingUploadCode()});
        Validate.notBlank((CharSequence)withholdingSummaryVo.getTradeCurrency(), (String)"\u6c47\u603b\u4e0a\u4f20\u7f16\u7801[%s]\uff0c\u4ea4\u6613\u8d27\u5e01\u4e3a\u7a7a\uff01", (Object[])new Object[]{withholdingSummaryVo.getWithholdingUploadCode()});
        Validate.notNull((Object)withholdingSummaryVo.getExchangeRate(), (String)"\u6c47\u603b\u4e0a\u4f20\u7f16\u7801[%s]\uff0c\u6c47\u7387\u4e3a\u7a7a\uff01", (Object[])new Object[]{withholdingSummaryVo.getWithholdingUploadCode()});
        Validate.notBlank((CharSequence)withholdingSummaryVo.getExpenseContent(), (String)"\u6c47\u603b\u4e0a\u4f20\u7f16\u7801[%s]\uff0c\u5f00\u652f\u5185\u5bb9\u4e3a\u7a7a\uff01", (Object[])new Object[]{withholdingSummaryVo.getWithholdingUploadCode()});
        Validate.notNull((Object)withholdingSummaryVo.getWithholdingAmount(), (String)"\u6c47\u603b\u4e0a\u4f20\u7f16\u7801[%s]\uff0c\u9884\u63d0\u91d1\u989d\u4e3a\u7a7a\uff01", (Object[])new Object[]{withholdingSummaryVo.getWithholdingUploadCode()});
        Validate.notEmpty((Collection)withholdingSummaryVo.getDetailVoList(), (String)"\u6c47\u603b\u4e0a\u4f20\u7f16\u7801[%s]\uff0c\u6c47\u603b\u660e\u7ec6\u4e3a\u7a7a\uff01", (Object[])new Object[]{withholdingSummaryVo.getWithholdingUploadCode()});
        List accruedAccountList = this.dictToolkitService.tree("tpm_accrued_account");
        Map<Object, Object> accruedAccountMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty((Collection)accruedAccountList)) {
            accruedAccountMap = accruedAccountList.stream().collect(Collectors.toMap(DictDataVo::getDictCode, v -> v));
        }
        for (WithholdingSummaryDetailVo v2 : withholdingSummaryVo.getDetailVoList()) {
            Validate.notBlank((CharSequence)v2.getBusinessExpItem(), (String)"\u6c47\u603b\u4e0a\u4f20\u7f16\u7801[%s]\uff0c\u6c47\u603b\u660e\u7ec6\u7f16\u7801[%s]\uff0c\u4e1a\u52a1\u7ec6\u7c7b\u4e3a\u7a7a\uff01", (Object[])new Object[]{withholdingSummaryVo.getWithholdingUploadCode(), v2.getWithholdingDetailCode()});
            Validate.isTrue((boolean)accruedAccountMap.containsKey(v2.getBusinessExpItem()), (String)"\u6c47\u603b\u4e0a\u4f20\u7f16\u7801[%s]\uff0c\u9884\u63d0\u6c47\u603b\u660e\u7ec6\u7f16\u7801[%s]\uff0c\u4e1a\u52a1\u7ec6\u7c7b[%s]\u5728\u6570\u636e\u5b57\u5178[%s]\u4e2d\u672a\u7ef4\u62a4\uff01", (Object[])new Object[]{withholdingSummaryVo.getWithholdingUploadCode(), v2.getWithholdingDetailCode(), v2.getBusinessExpItem(), "tpm_accrued_account"});
            DictDataVo businessExpItemDictVo = (DictDataVo)accruedAccountMap.get(v2.getBusinessExpItem());
            Validate.isTrue((Objects.nonNull(businessExpItemDictVo.getExtendMap()) && businessExpItemDictVo.getExtendMap().containsKey("yes_or_no") ? 1 : 0) != 0, (String)"\u6c47\u603b\u4e0a\u4f20\u7f16\u7801[%s]\uff0c\u9884\u63d0\u6c47\u603b\u660e\u7ec6\u7f16\u7801[%s]\uff0c\u4e1a\u52a1\u7ec6\u7c7b[%s]\u5728\u6570\u636e\u5b57\u5178[%s]\u4e2d\u672a\u7ef4\u62a4\u662f\u5426\u5fc5\u586b\u5ba2\u5546\u7c7b\u578b\uff01", (Object[])new Object[]{withholdingSummaryVo.getWithholdingUploadCode(), v2.getWithholdingDetailCode(), v2.getBusinessExpItem(), "tpm_accrued_account"});
            boolean needSupplier = StringUtils.equals((CharSequence)YesOrNoEnum.YES.getCode(), (CharSequence)((CharSequence)businessExpItemDictVo.getExtendMap().get("yes_or_no")));
            if (needSupplier) {
                Validate.notBlank((CharSequence)v2.getSupplierCode(), (String)"\u6c47\u603b\u4e0a\u4f20\u7f16\u7801[%s]\uff0c\u9884\u63d0\u6c47\u603b\u660e\u7ec6\u7f16\u7801[%s]\uff0c[\u5ba2\u5546\u7f16\u7801]\u4e3a\u7a7a\uff01", (Object[])new Object[]{withholdingSummaryVo.getWithholdingUploadCode(), v2.getWithholdingDetailCode()});
                Validate.notBlank((CharSequence)v2.getSupplierName(), (String)"\u6c47\u603b\u4e0a\u4f20\u7f16\u7801[%s]\uff0c\u9884\u63d0\u6c47\u603b\u660e\u7ec6\u7f16\u7801[%s]\u884c\uff0c[\u5ba2\u5546\u540d\u79f0]\u4e3a\u7a7a\uff01", (Object[])new Object[]{withholdingSummaryVo.getWithholdingUploadCode(), v2.getWithholdingDetailCode()});
            } else {
                Validate.isTrue((boolean)StringUtils.isEmpty((CharSequence)v2.getCustomerClassifyCode()), (String)"\u6c47\u603b\u4e0a\u4f20\u7f16\u7801[%s]\uff0c\u9884\u63d0\u6c47\u603b\u660e\u7ec6\u7f16\u7801[%s]\uff0c\u4e1a\u52a1\u7ec6\u7c7b[%s]\u4e0d\u5141\u8bb8\u5f55\u5165\u5ba2\u5546\u4fe1\u606f\uff01", (Object[])new Object[]{withholdingSummaryVo.getWithholdingUploadCode(), v2.getWithholdingDetailCode(), businessExpItemDictVo.getDictValue()});
                v2.setCustomerClassifyName("");
                Validate.isTrue((boolean)StringUtils.isEmpty((CharSequence)v2.getSupplierCode()), (String)"\u6c47\u603b\u4e0a\u4f20\u7f16\u7801[%s]\uff0c\u9884\u63d0\u6c47\u603b\u660e\u7ec6\u7f16\u7801[%s]\uff0c\u4e1a\u52a1\u7ec6\u7c7b[%s]\u4e0d\u5141\u8bb8\u5f55\u5165\u5ba2\u5546\u4fe1\u606f\uff01", (Object[])new Object[]{withholdingSummaryVo.getWithholdingUploadCode(), v2.getWithholdingDetailCode(), businessExpItemDictVo.getDictValue()});
                Validate.isTrue((boolean)StringUtils.isEmpty((CharSequence)v2.getSupplierName()), (String)"\u6c47\u603b\u4e0a\u4f20\u7f16\u7801[%s]\uff0c\u9884\u63d0\u6c47\u603b\u660e\u7ec6\u7f16\u7801[%s]\uff0c\u4e1a\u52a1\u7ec6\u7c7b[%s]\u4e0d\u5141\u8bb8\u5f55\u5165\u5ba2\u5546\u4fe1\u606f\uff01", (Object[])new Object[]{withholdingSummaryVo.getWithholdingUploadCode(), v2.getWithholdingDetailCode(), businessExpItemDictVo.getDictValue()});
            }
            Validate.notBlank((CharSequence)v2.getCostCenter(), (String)"\u6c47\u603b\u4e0a\u4f20\u7f16\u7801[%s]\uff0c\u6c47\u603b\u660e\u7ec6\u7f16\u7801[%s]\u6210\u672c\u4e2d\u5fc3\u7f16\u7801\u4e3a\u7a7a\uff01", (Object[])new Object[]{withholdingSummaryVo.getWithholdingUploadCode(), v2.getWithholdingDetailCode()});
            Validate.notBlank((CharSequence)v2.getCostCenterName(), (String)"\u6c47\u603b\u4e0a\u4f20\u7f16\u7801[%s]\uff0c\u6c47\u603b\u660e\u7ec6\u7f16\u7801[%s]\u6210\u672c\u4e2d\u5fc3\u540d\u79f0\u4e3a\u7a7a\uff01", (Object[])new Object[]{withholdingSummaryVo.getWithholdingUploadCode(), v2.getWithholdingDetailCode()});
            Validate.notNull((Object)v2.getEstimateTaxAmount(), (String)"\u6c47\u603b\u4e0a\u4f20\u7f16\u7801[%s]\uff0c\u6c47\u603b\u660e\u7ec6\u7f16\u7801[%s]\u6682\u4f30\u7a0e\u91d1\u4e3a\u7a7a\uff01", (Object[])new Object[]{withholdingSummaryVo.getWithholdingUploadCode(), v2.getWithholdingDetailCode()});
            Validate.notNull((Object)v2.getWithholdingAmount(), (String)"\u6c47\u603b\u4e0a\u4f20\u7f16\u7801[%s]\uff0c\u6c47\u603b\u660e\u7ec6\u7f16\u7801[%s]\u4e0d\u542b\u7a0e\u91d1\u989d\u4e3a\u7a7a\uff01", (Object[])new Object[]{withholdingSummaryVo.getWithholdingUploadCode(), v2.getWithholdingDetailCode()});
            if (!WithholdingSummaryActivityTypeTypeEnum.personnel_cost.getDictCode().equals(withholdingSummaryVo.getActivityTypeType())) continue;
            Validate.notNull((Object)v2.getQuantity(), (String)"\u6c47\u603b\u4e0a\u4f20\u7f16\u7801[%s]\uff0c\u6c47\u603b\u660e\u7ec6\u7f16\u7801[%s]\u6570\u91cf\u4e3a\u7a7a\uff01", (Object[])new Object[]{withholdingSummaryVo.getWithholdingUploadCode(), v2.getWithholdingDetailCode()});
            Validate.notNull((Object)v2.getPrice(), (String)"\u6c47\u603b\u4e0a\u4f20\u7f16\u7801[%s]\uff0c\u6c47\u603b\u660e\u7ec6\u7f16\u7801[%s]\u4e0d\u542b\u7a0e\u5355\u4ef7\u4e3a\u7a7a\uff01", (Object[])new Object[]{withholdingSummaryVo.getWithholdingUploadCode(), v2.getWithholdingDetailCode()});
            Validate.notNull((Object)v2.getPromotionAmount(), (String)"\u6c47\u603b\u4e0a\u4f20\u7f16\u7801[%s]\uff0c\u6c47\u603b\u660e\u7ec6\u7f16\u7801[%s]\u4f18\u60e0\u91d1\u989d\u4e3a\u7a7a\uff01", (Object[])new Object[]{withholdingSummaryVo.getWithholdingUploadCode(), v2.getWithholdingDetailCode()});
            Validate.notBlank((CharSequence)v2.getContractCode(), (String)"\u6c47\u603b\u4e0a\u4f20\u7f16\u7801[%s]\uff0c\u6c47\u603b\u660e\u7ec6\u7f16\u7801[%s]\u5408\u540c\u7f16\u53f7\u4e3a\u7a7a\uff01", (Object[])new Object[]{withholdingSummaryVo.getWithholdingUploadCode(), v2.getWithholdingDetailCode()});
        }
    }

    public BcBpmCeWithholdingSummaryDto buildUploadParam(WithholdingSummaryVo withholdingSummaryVo, FacturerUserDetails loginDetails) {
        BigDecimal attachCount = withholdingSummaryVo.getDetailVoList().stream().filter(e -> Objects.nonNull(e.getAttachmentNum())).map(WithholdingSummaryDetailVo::getAttachmentNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        BcBpmCeWithholdingSummaryDto dto = new BcBpmCeWithholdingSummaryDto();
        Validate.notBlank((CharSequence)withholdingSummaryVo.getSalesOrgCode(), (String)"\u6c47\u603b\u4e0a\u4f20\u7f16\u7801[%s]\uff0c\u672a\u67e5\u8be2\u5230\u9500\u552e\u516c\u53f8\uff01", (Object[])new Object[]{withholdingSummaryVo.getWithholdingUploadCode()});
        BcBpmCeWithholdingSummaryDto.HeaderData headerData = new BcBpmCeWithholdingSummaryDto.HeaderData();
        headerData.setOUT_DOCUMENT(withholdingSummaryVo.getWithholdingUploadCode());
        headerData.setAPPLICANT(loginDetails.getRealName());
        headerData.setAPPLICANT_NO(loginDetails.getAccount());
        headerData.setBUKRS(withholdingSummaryVo.getSalesOrgCode());
        headerData.setCREATED_BY(loginDetails.getAccount());
        headerData.setCREATED_BY_TXT(loginDetails.getRealName());
        headerData.setCURRENCY(withholdingSummaryVo.getTradeCurrency());
        headerData.setRATE(withholdingSummaryVo.getExchangeRate().toString());
        headerData.setATTACHCOUNT(attachCount.toString());
        headerData.setDESCRIPTION(withholdingSummaryVo.getExpenseContent());
        headerData.setAMOUNT(withholdingSummaryVo.getWithholdingAmount().setScale(2, 4).toString());
        headerData.setPRCTR(Integer.valueOf(withholdingSummaryVo.getProfitCenter()).toString());
        headerData.setEXP_TYPE(withholdingSummaryVo.getBusinessTitle());
        ArrayList<BcBpmCeWithholdingSummaryDto.DetailList> detailList = new ArrayList<BcBpmCeWithholdingSummaryDto.DetailList>();
        int index = 1;
        for (WithholdingSummaryDetailVo v : withholdingSummaryVo.getDetailVoList()) {
            BcBpmCeWithholdingSummaryDto.DetailList detail = new BcBpmCeWithholdingSummaryDto.DetailList();
            detail.setSEQ(index + "");
            detail.setEXP_ITEM(v.getBusinessExpItem());
            detail.setACCOUNT_TYPE(StringUtils.isEmpty((CharSequence)v.getCustomerClassifyCode()) ? v.getCustomerClassifyCode() : WithholdingSummarySupplierTypeEnum.codeToEnum((String)v.getCustomerClassifyCode()).getValue());
            detail.setLIFNR(v.getSupplierCode());
            detail.setLIFNR_TXT(v.getSupplierName());
            detail.setPAYAMOUNT(v.getWithholdingTaxAmount().setScale(2, RoundingMode.HALF_DOWN).toString());
            detail.setKOSTL(v.getCostCenter());
            detail.setKOSTL_TXT(v.getCostCenterName());
            detail.setTAX_AMT(v.getEstimateTaxAmount().setScale(2, RoundingMode.HALF_DOWN).toString());
            detail.setTAX_FREE_AMT(v.getWithholdingAmount().setScale(2, RoundingMode.HALF_DOWN).toString());
            if (Objects.isNull(v.getPrice())) {
                v.setPrice(BigDecimal.ZERO);
            }
            if (Objects.isNull(v.getQuantity())) {
                v.setQuantity(BigDecimal.ZERO);
            }
            if (WithholdingSummaryActivityTypeTypeEnum.personnel_cost.getDictCode().equals(withholdingSummaryVo.getActivityTypeType())) {
                detail.setPRICE_WITHOUT_TAX(v.getPrice().setScale(8, RoundingMode.HALF_DOWN).toString());
                detail.setCOUNT_N(v.getQuantity().setScale(2, RoundingMode.HALF_DOWN).toString());
                detail.setCONTRACT_ID(v.getContractCode());
            }
            if (Objects.isNull(v.getPromotionAmount())) {
                v.setPromotionAmount(BigDecimal.ZERO);
            }
            detail.setDISCOUNT_AMT(v.getPromotionAmount().setScale(2, RoundingMode.HALF_DOWN).toString());
            detailList.add(detail);
            ++index;
        }
        dto.setHEDAER(headerData);
        dto.setEXPENSE_DETAIL_LIST(detailList);
        return dto;
    }

    public String getRedisCacheKey(String cacheKey) {
        return "tpm:withholding_summary_item_cache:" + cacheKey;
    }

    public void checkDetailCount(WithholdingSummaryDto dto) {
        WithholdingSummaryFormulaVo withholdingSummaryFormulaVo = this.tpmWithholdingSummaryRepository.findHeadInfoByWithholdingFormulaCode(dto.getWithholdingFormulaCode());
        Validate.isTrue((boolean)Objects.nonNull(withholdingSummaryFormulaVo), (String)"\u9884\u63d0\u6c47\u603b\u89c4\u5219[%s]\u4e0d\u5b58\u5728\uff01", (Object[])new Object[]{dto.getWithholdingFormulaCode()});
        Validate.notEmpty((Collection)withholdingSummaryFormulaVo.getOrgVoList(), (String)"\u9884\u63d0\u6c47\u603b\u89c4\u5219[%s]\u672a\u914d\u7f6e\u9500\u552e\u7ec4\u7ec7\uff01", (Object[])new Object[]{withholdingSummaryFormulaVo.getWithholdingFormulaCode()});
        List salesOrgVos = this.salesOrgVoService.findAllChildrenBySalesOrgCodes(withholdingSummaryFormulaVo.getOrgVoList().stream().map(WithholdingSummaryROrgVo::getSalesOrgCode).collect(Collectors.toList()));
        Validate.notEmpty((Collection)salesOrgVos, (String)"\u9884\u63d0\u6c47\u603b\u89c4\u5219\u7f16\u7801[%s]\u9500\u552e\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528\uff01", (Object[])new Object[]{withholdingSummaryFormulaVo.getWithholdingFormulaCode()});
        List<String> orgCodes = salesOrgVos.stream().map(SalesOrgVo::getSalesOrgCode).collect(Collectors.toList());
        String salesOrgLevel = this.summaryOrgDimension(withholdingSummaryFormulaVo);
        Long detailCount = this.tpmWithholdingSummaryRepository.countSummaryDetail(dto, withholdingSummaryFormulaVo, orgCodes, salesOrgLevel);
        Validate.isTrue((detailCount > 0L ? 1 : 0) != 0, (String)"\u9884\u63d0\u6c47\u603b\u89c4\u5219[%s]\uff0c\u9884\u63d0\u5e74\u6708[%s]\u672a\u67e5\u8be2\u5230\u6c47\u603b\u660e\u7ec6\uff01", (Object[])new Object[]{dto.getWithholdingFormulaCode(), dto.getWithholdingYearMonth()});
    }

    public String summaryOrgDimension(WithholdingSummaryFormulaVo withholdingSummaryFormulaVo) {
        String salesOrgLevel = null;
        if (StringUtils.equals((CharSequence)YesOrNoEnum.YES.getCode(), (CharSequence)withholdingSummaryFormulaVo.getSaleGroupCb())) {
            salesOrgLevel = SalesOrgLevelTypeEnum.GROUP.getCode();
        } else if (StringUtils.equals((CharSequence)YesOrNoEnum.YES.getCode(), (CharSequence)withholdingSummaryFormulaVo.getSaleOrgDepartmentCb())) {
            salesOrgLevel = SalesOrgLevelTypeEnum.DEPARTMENT.getCode();
        } else if (StringUtils.equals((CharSequence)YesOrNoEnum.YES.getCode(), (CharSequence)withholdingSummaryFormulaVo.getSaleOrgCb())) {
            salesOrgLevel = SalesOrgLevelTypeEnum.MECHANISM.getCode();
        }
        return salesOrgLevel;
    }
}

