package com.biz.crm.tpm.business.year.budget.local.listener;

import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.budget.cal.config.sdk.eunm.SalesOrgAreaEnum;
import com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigSalesOrgVo;
import com.biz.crm.tpm.business.budget.item.sdk.enums.BudgetDepartmentBelongEnum;
import com.biz.crm.tpm.business.budget.item.sdk.enums.FeeBelongEnum;
import com.biz.crm.tpm.business.month.budget.sdk.dto.YearBudgetEventDto;
import com.biz.crm.tpm.business.month.budget.sdk.event.YearBudgetEventListener;
import com.biz.crm.tpm.business.month.budget.sdk.vo.YearBudgetResponse;
import com.biz.crm.tpm.business.year.budget.local.service.YearBudgetService;
import com.biz.crm.tpm.business.year.budget.sdk.dto.YearBudgetToralPointDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author: chenlong
 * @date: 2023/5/13 14:42
 * @description:
 */
@Slf4j
@Component
public class YearBudgetEventListenerImpl implements YearBudgetEventListener {

    @Autowired(required = false)
    private YearBudgetService yearBudgetService;
    @Autowired(required = false)
    private OrgVoService orgVoService;
    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 查询年度预算通过年度预算编码
     *
     * @param eventDto 事件参数
     * @return YearBudgetResponse
     **/
    @Override
    public YearBudgetResponse getYearBudgetByCode(YearBudgetEventDto eventDto) {
        YearBudgetResponse response = new YearBudgetResponse();
        if (StringUtil.isBlank(eventDto.getYearBudgetCode()) ||
                StringUtil.isBlank(eventDto.getBusinessFormatCode()) ||
                StringUtil.isBlank(eventDto.getBusinessUnitCode()) ||
                StringUtil.isBlank(eventDto.getBudgetTypeCode()) ||
                StringUtil.isBlank(eventDto.getFeeBelongCode()) ||
                StringUtil.isBlank(eventDto.getControlType()) ||
                StringUtil.isBlank(eventDto.getOrgAreaCode()) ||
                StringUtil.isBlank(eventDto.getYearLy())) {
            return response;
        }
        YearBudgetToralPointDto pointDto = this.nebulaToolkitService.copyObjectByBlankList(eventDto, YearBudgetToralPointDto.class, HashSet.class, ArrayList.class);
        if (SalesOrgAreaEnum.CUR_ORG.getCode().equals(eventDto.getOrgAreaCode())) {
            if (StringUtils.isEmpty(eventDto.getSalesOrgCode()) && StringUtils.isEmpty(eventDto.getOrgCode())) {
                return response;
            }
            String salesOrgCode = null;
            // 获取年度预算上当前组织
            if (!StringUtils.isEmpty(eventDto.getSalesOrgCode())) {
                salesOrgCode = eventDto.getSalesOrgCode();
            } else {
                if (!StringUtils.isEmpty(eventDto.getOrgCode())) {
                    OrgVo byOrgCode = orgVoService.findByOrgCode(eventDto.getOrgCode());
                    salesOrgCode = byOrgCode.getSalesOrgCode();
                }
            }
            if (StringUtils.isEmpty(salesOrgCode)) {
                return response;
            }
//            List<SalesOrgVo> salesOrgVos = salesOrgVoService.findAllChildrenBySalesOrgCode(salesOrgCode);
//            if (CollectionUtils.isEmpty(salesOrgVos)) {
//                return response;
//            }
            List<String> saleOrgCodeList = new ArrayList<>();
            saleOrgCodeList.add(salesOrgCode);
            pointDto.setSalesOrgList(saleOrgCodeList);
        } else if (SalesOrgAreaEnum.CUSTOMIZE_ORG.getCode().equals(eventDto.getOrgAreaCode())) {
            if (CollectionUtils.isEmpty(eventDto.getSalesOrgList())) {
                return response;
            }
            List<String> saleOrgCodeList = eventDto.getSalesOrgList().stream().map(BudgetCalConfigSalesOrgVo::getSalesOrgCode).collect(Collectors.toList());
            pointDto.setSalesOrgList(saleOrgCodeList);
        } else if (SalesOrgAreaEnum.CUR_CUSTOMER.getCode().equals(eventDto.getOrgAreaCode())) {
            /*若费用归口为大区、分组为客户。
                产品计费比例模块中，若配置的是否扣减字段为是，则对应的区域整体授权点数计算逻辑为
               当前客户的、业态为常温业务单元为主体、费用归口为大区、分组为客户、且关联预算项目的部门归口为销管的年度预算上的预算点数之和。
             */
            if (!FeeBelongEnum.AREA.getCode().equals(eventDto.getFeeBelongCode())) {
                return response;
            }
            if (StringUtils.isBlank(eventDto.getCustomerCode())) {
                throw new RuntimeException("计算年度预算总点数时，客户分组类型，客户编码为空！");
            }
            pointDto = new YearBudgetToralPointDto();
            pointDto.setCustomerCode(eventDto.getCustomerCode());
            pointDto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
            pointDto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
            pointDto.setFeeBelongCode(FeeBelongEnum.AREA.getCode());
            pointDto.setGroupCode(eventDto.getGroupCode());
            pointDto.setDepartmentBelongCode(BudgetDepartmentBelongEnum.SALE_MANAGE.getCode());
            BigDecimal point = this.yearBudgetService.getYearBudgetTotalPointForCustomerGroup(pointDto);
            response.setBudgetTotalPoint(point);
            return response;
        }
        BigDecimal budgetTotalPoint = this.yearBudgetService.getYearBudgetTotalPoint(pointDto);
        response.setBudgetTotalPoint(budgetTotalPoint);
        return response;
    }
}
