package com.biz.crm.tpm.business.year.budget.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.year.budget.local.entity.YearBudgetDataEntity;
import com.biz.crm.tpm.business.year.budget.local.mapper.YearBudgetDataMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @author huojia
 * @date 2022年10月26日 17:26
 */
@Component
public class YearBudgetDataRepository extends ServiceImpl<YearBudgetDataMapper, YearBudgetDataEntity> {

    /**
     * 根据年度预算ids和要查询的数据类型 批量查询
     *
     * @param yearBudgetCodes
     * @param dataTypeList
     * @return java.util.List<com.biz.crm.tpm.business.year.budget.local.entity.YearBudgetDataEntity>
     * @author huojia
     * @date 2022/10/26 17:34
     **/
    public List<YearBudgetDataEntity> listByYearBudgetCodes(List<String> yearBudgetCodes, List<String> dataTypeList) {
        return this.lambdaQuery()
                .in(!CollectionUtils.isEmpty(yearBudgetCodes), YearBudgetDataEntity::getYearBudgetCode, yearBudgetCodes)
                .in(!CollectionUtils.isEmpty(dataTypeList), YearBudgetDataEntity::getDataType, dataTypeList)
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .orderByAsc(YearBudgetDataEntity::getSortNum)
                .list();
    }

    /**
     * 根据年度预算id删除对应数据明细
     *
     * @param yearBudgetCode
     * @author huojia
     * @date 2022/10/26 20:37
     **/
    public void deleteByYearBudgetCode(String yearBudgetCode) {
        if (StringUtils.isEmpty(yearBudgetCode)) {
            return;
        }
        List<YearBudgetDataEntity> list = this.lambdaQuery()
                .eq(YearBudgetDataEntity::getYearBudgetCode, yearBudgetCode)
                .list();
        if (!CollectionUtils.isEmpty(list)) {
            list.forEach(yearBudgetDataEntity -> {
                yearBudgetDataEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            });
            this.updateBatchById(list);
        }
    }
}
