package com.biz.crm.tpm.business.year.budget.local.service.async;

import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.tpm.business.year.budget.local.service.YearBudgetGenerateMonthBudgetAsyncService;
import com.biz.crm.tpm.business.year.budget.local.service.YearBudgetService;
import com.biz.crm.tpm.business.year.budget.sdk.dto.YearBudgetDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @Description:
 * @Author qiancheng
 * @Date 2023/8/31
 */
@Slf4j
@Service
public class YearBudgetGenerateMonthBudgetAsyncServiceImpl implements YearBudgetGenerateMonthBudgetAsyncService {

    @Autowired(required = false)
    private YearBudgetService yearBudgetService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Async
    @Override
    public void generateMonthBudgetAsync(AbstractCrmUserIdentity loginUser, YearBudgetDto dto){
        if (Objects.isNull(dto)) {
            return;
        }
        loginUserService.refreshAuthentication(loginUser);
        log.info("生成月度预算，异步处理中..");
        yearBudgetService.generateMonthBudget(dto);
    }

}
