package com.biz.crm.tpm.business.year.budget.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetDetailDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.OperateMonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetControlVo;
import com.biz.crm.tpm.business.year.budget.local.entity.YearBudgetDataEntity;
import com.biz.crm.tpm.business.year.budget.local.entity.YearBudgetEntity;
import com.biz.crm.tpm.business.year.budget.local.repository.YearBudgetDataRepository;
import com.biz.crm.tpm.business.year.budget.local.repository.YearBudgetRepository;
import com.biz.crm.tpm.business.year.budget.local.service.YearBudgetService;
import com.biz.crm.tpm.business.year.budget.sdk.dto.OperateYearBudgetDto;
import com.biz.crm.tpm.business.year.budget.sdk.dto.YearBudgetDto;
import com.biz.crm.tpm.business.year.budget.sdk.dto.YearBudgetToralPointDto;
import com.biz.crm.tpm.business.year.budget.sdk.eunm.YearBudgetDataTypeEnum;
import com.biz.crm.tpm.business.year.budget.sdk.service.YearBudgetSdkService;
import com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetReportVo;
import com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.math.BigDecimal;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author: chenlong
 * @date: 2023/3/23 17:06
 * @description:
 */
@Slf4j
@Service
public class YearBudgetSdkServiceImpl implements YearBudgetSdkService {

    @Autowired(required = false)
    private YearBudgetService yearBudgetService;

    @Autowired
    private YearBudgetRepository yearBudgetRepository;

    @Autowired
    private YearBudgetDataRepository yearBudgetDataRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Page<YearBudgetVo> findByConditions(Pageable pageable, YearBudgetDto dto) {
        return yearBudgetService.findByConditions(pageable,dto);
    }

    @Override
    public List<CommonSelectVo> findBelongSelect(String businessFormatCode, String businessUnitCode) {
        return yearBudgetService.findBelongSelect(businessFormatCode, businessUnitCode);
    }

    @Override
    public List<YearBudgetReportVo> findYearBudgetSumVo(YearBudgetDto queryDto) {
        if (CollectionUtils.isEmpty(queryDto.getYearLyCollection())&&
                CollectionUtils.isEmpty(queryDto.getRegionCollection())&&
                CollectionUtils.isEmpty(queryDto.getSystemCodeCollection())&&
                CollectionUtils.isEmpty(queryDto.getBudgetItemCodeCollection())){
            return Collections.emptyList();
        }
        queryDto.setTenantCode(TenantUtils.getTenantCode());
        return yearBudgetService.findYearBudgetSumVo(queryDto);
    }

    @Override
    public YearBudgetVo findById(String id, String editFlag) {
        return yearBudgetService.findById(id, editFlag);
    }

    @Override
    public YearBudgetDto create(YearBudgetDto dto) {
        return yearBudgetService.create(dto);
    }

    @Override
    public YearBudgetVo update(YearBudgetDto dto) {
        return yearBudgetService.update(dto);
    }

    @Override
    public List<String> generateMonthBudgetForOut(String id) {
        List<String> yearBudgetIdList = Lists.newArrayList();
        yearBudgetIdList.add(id);
        return yearBudgetService.generateMonthBudgetForOut(yearBudgetIdList);
    }

    @Override
    public BigDecimal sumBudgetTotalPoint(YearBudgetToralPointDto dto) {
        return yearBudgetRepository.getYearBudgetTotalPoint(dto);
    }

    @Override
    public List<YearBudgetVo> getYearBudgetTotalPointGroupBySalesOrg(YearBudgetToralPointDto dto) {
        return yearBudgetRepository.getYearBudgetTotalPointGroupBySalesOrg(dto);
    }

    @Override
    public List<YearBudgetVo> findYearBudgetByYearBudgetCodes(List<String> budgetItemCodes) {
        return yearBudgetService.findYearBudgetByYearBudgetCodes(budgetItemCodes);
    }

    /**
     * 根据年度预算编码集合查询
     * @param yearBudgetCodes
     * @return
     */
    @Override
    public List<YearBudgetVo> findByYearBudgetCodes(List<String> yearBudgetCodes) {
        if (CollectionUtils.isEmpty(yearBudgetCodes)) {
            return Lists.newArrayList();
        }
        List<YearBudgetEntity> yearBudgetList = this.yearBudgetRepository.findByYearBudgetCodes(yearBudgetCodes);
        if (CollectionUtils.isEmpty(yearBudgetList)) {
            return Lists.newArrayList();
        }
        return (List<YearBudgetVo>) this.nebulaToolkitService.copyCollectionByWhiteList(yearBudgetList,YearBudgetEntity.class,YearBudgetVo.class, HashSet.class, ArrayList.class);
    }

    /**
     * 营销费用使用进度-跑帆软
     * @param yearBudgetDtos
     * @return
     */
    @Override
    public List<YearBudgetVo> findListForFR(List<YearBudgetDto> yearBudgetDtos) {
        if(CollectionUtils.isEmpty(yearBudgetDtos)) {
            return Collections.emptyList();
        }
        return this.yearBudgetRepository.findListForFR(yearBudgetDtos);
    }

    @Override
    public void operateBudgetStrategy(List<OperateYearBudgetDto> operateList) {
        if (org.springframework.util.CollectionUtils.isEmpty(operateList)) {
            return;
        }
        List<YearBudgetEntity> budgetEntityList = validateOperateBudget(operateList);
        Map<String, YearBudgetEntity> budgetEntityMap = budgetEntityList.stream().collect(Collectors.toMap(YearBudgetEntity::getYearBudgetCode, Function.identity()));

        Boolean throwException = operateList.get(0).getThrowException();
        for (OperateYearBudgetDto operateMonthBudgetDto : operateList) {
            YearBudgetEntity budgetEntity = budgetEntityMap.get(operateMonthBudgetDto.getYearBudgetCode());
            String operationType = operateMonthBudgetDto.getOperationType();
            String businessCode = operateMonthBudgetDto.getBusinessCode();
            BigDecimal operationAmount = operateMonthBudgetDto.getOperationAmount();
            BigDecimal usedStrategyAmount = Optional.ofNullable(budgetEntity.getUsedStrategyAmount()).orElse(BigDecimal.ZERO);
            BigDecimal usableStrategyAmount = budgetEntity.getBudgetTotalAmount().subtract(usedStrategyAmount);
            // 根据预算类型操作预算
            String businessDesc = "";
            if (StringUtils.isNotEmpty(businessCode)) {
                businessDesc = "[" + businessCode + "]";
            }
            opertion:
            if (BudgetOperationTypeEnum.USE.getCode().equals(operationType)) {
                if (!(usableStrategyAmount.compareTo(operationAmount) >= 0)) {
                    if (throwException) {
                        throw new RuntimeException(businessDesc + "使用金额[" + operationAmount + "]大于预算[" + operateMonthBudgetDto.getYearBudgetCode() + "]可用余额" + usableStrategyAmount + "，请检查！");
                    } else {
                        operateMonthBudgetDto.setGapAmount(operationAmount.subtract(usableStrategyAmount));
                        budgetEntity.setUsedStrategyAmount(budgetEntity.getBudgetTotalAmount());
                        break opertion;//不够就记录差额就行了，不处理数据
                    }
                }
                budgetEntity.setUsedStrategyAmount(usedStrategyAmount.add(operationAmount));
            } else if (BudgetOperationTypeEnum.RETURN.getCode().equals(operationType)) {
                budgetEntity.setUsedStrategyAmount(usedStrategyAmount.subtract(operationAmount));
            } else {
                throw new RuntimeException(businessDesc + "年度预算策略占用金额操作类型有误！");
            }
        }
        Boolean doSave = operateList.get(0).getDoSave();
        if (null == doSave || doSave) {//为空默认保存
            yearBudgetService.updateOperateBudget(Lists.newArrayList(budgetEntityMap.values()));
        }
    }

    public List<YearBudgetEntity> validateOperateBudget(List<OperateYearBudgetDto> operateList) {
        for (OperateYearBudgetDto operateBudgetDto : operateList) {
            Validate.notEmpty(operateBudgetDto.getYearBudgetCode(), "操作预算时，预算编码不能为空！");
//            Validate.notNull(operateMonthBudgetDto.getOperationAmount(), "操作预算时，操作金额不能为空！");
            Validate.notEmpty(operateBudgetDto.getOperationType(), "操作预算时，操作类型不能为空！");
        }

        List<String> budgetCodeList = operateList.stream().map(OperateYearBudgetDto::getYearBudgetCode).distinct().collect(Collectors.toList());
        List<YearBudgetEntity> budgetEntityList = yearBudgetRepository.listByCodes(budgetCodeList);
        if (budgetEntityList.size() < budgetCodeList.size()) {
            List<String> existsCodes = budgetEntityList.stream().map(YearBudgetEntity::getYearBudgetCode).collect(Collectors.toList());
            String notExistsJoinCodesStr = budgetCodeList.stream().filter(item -> !existsCodes.contains(item)).collect(Collectors.joining(","));
            throw new RuntimeException("预算操作失败，年度预算[" + notExistsJoinCodesStr + "]查询失败，请检查预算是否启用或是否存在！！");
        }
        for (YearBudgetEntity budgetVo : budgetEntityList) {
            if (null == budgetVo.getUsedStrategyAmount()) {
                budgetVo.setUsedStrategyAmount(BigDecimal.ZERO);
            }
            if (null == budgetVo.getBudgetTotalAmount()) {
                budgetVo.setBudgetTotalAmount(BigDecimal.ZERO);
            }
        }
        return budgetEntityList;
    }

}
