package com.biz.crm.tpm.business.year.budget.local.service.process;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.product.brand.sdk.service.ProductBrandService;
import com.biz.crm.mdm.business.product.brand.sdk.vo.ProductBrandVo;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.dto.SalesOrgRangeDto;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.eunm.CustomerChannelEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.dto.DimensionInformationQueryData;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.enmus.MenuCodeEnum;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.service.DimensionDimensionInformationService;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.vo.DimensionDimensionInformationVo;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo;
import com.biz.crm.tpm.business.sales.goal.sdk.constant.DictTypeCodeConstant;
import com.biz.crm.tpm.business.year.budget.local.service.YearBudgetService;
import com.biz.crm.tpm.business.year.budget.sdk.dto.YearBudgetDataDto;
import com.biz.crm.tpm.business.year.budget.sdk.dto.YearBudgetDto;
import com.biz.crm.tpm.business.year.budget.sdk.eunm.YearBudgetDataTypeEnum;
import com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetImportsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author huojia
 * @date 2022年10月28日 11:42
 */
@Slf4j
@Component
public class YearBudgetImportsProcess implements ImportProcess<YearBudgetImportsVo> {

    @Resource
    private OrgVoService orgVoService;

    @Resource
    private ProductVoService productVoService;

    @Resource
    private CustomerVoService customerVoService;

//    @Resource
//    private TerminalVoService terminalVoService;

    @Resource
    private SalesOrgVoService salesOrgVoService;

//    @Resource
//    private CustomerChannelVoService customerChannelVoService;
//
//    @Resource
//    private MdmTerminalChannelVoService mdmTerminalChannelVoService;

    @Resource
    private ProductBrandService productBrandService;

    @Resource
    private ProductLevelVoSdkService productLevelVoSdkService;

    @Resource
    private BudgetItemService budgetItemService;

    @Resource
    private YearBudgetService yearBudgetService;

    @Resource
    private DictToolkitService dictToolkitService;

    @Resource
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private DimensionDimensionInformationService dimensionDimensionInformationService;

    private Map<String, String> mdmBusinessFormatMap = new HashMap<>();
    private Map<String, String> mdmBusinessUnitMap = new HashMap<>();
    private Map<String, String> tpmGroupCodeMap = new HashMap<>();
    private Map<String, String> tpmFeeBelongMap = new HashMap<>();
    //    private Map<String, String> tpmFeeSourceMap = new HashMap<>();
    private Map<String, Integer> dataTypeMap = new HashMap<>();
    private Map<String, OrgVo> orgVoMap = new HashMap<>();
    //    private Map<String, YearBudgetVo> yearBudgetVoMap = new HashMap<>();
    private Map<String, BudgetItemVo> budgetItemVoMap = new HashMap<>();
    private Map<String, CustomerVo> customerVoMap = new HashMap<>();
    //    private Map<String, TerminalVo> terminalVoMap = new HashMap<>();
    private Map<String, ProductVo> productVoMap = new HashMap<>();
    //    private Map<String, SalesOrgVo> salesOrgVoMap = new HashMap<>();
    private Map<String, Map<String, SalesOrgVo>> salesOrgMap = new HashMap<>();
    //    private Map<String, CustomerChannelVo> customerChannelVoMap = new HashMap<>();
//    private Map<String, MdmTerminalChannelVo> terminalChannelVoMap = new HashMap<>();
    private Map<String, ProductBrandVo> productBrandVoMap = new HashMap<>();
    private Map<String, ProductLevelVo> productCategoryVoMap = new HashMap<>();
    private Map<String, ProductLevelVo> productItemVoMap = new HashMap<>();

    /**
     * 数据分片
     *
     * @return 分片长度
     */
    @Override
    public Integer getBatchCount() {
        return 5000;
    }


    @Override
    public Map<Integer, String> execute(LinkedHashMap<Integer, YearBudgetImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        try {
            Validate.notEmpty(data, "导入数据不能为空！");
            Map<Integer, String> errorMap = new HashMap<>();
            List<YearBudgetImportsVo> yearBudgetImportsVos = new ArrayList<>();
            data.forEach((i, vo) -> {
                vo.setLineIndex(i);
                yearBudgetImportsVos.add(vo);
            });

            //构建数据字典
            mdmBusinessFormatMap = dictToolkitService.findConvertMapByDictTypeCode(DictTypeCodeConstant.MDM_BUSINESS_FORMAT);
            tpmGroupCodeMap = dictToolkitService.findConvertMapByDictTypeCode(DictTypeCodeConstant.TPM_GROUP_CODE);
            tpmFeeBelongMap = dictToolkitService.findConvertMapByDictTypeCode(DictTypeCodeConstant.TPM_FEE_BELONG_US);
            mdmBusinessUnitMap = dictToolkitService.findConvertMapByDictTypeCode(DictTypeCodeConstant.MDM_BUSINESS_UNIT);
//        tpmFeeSourceMap = dictToolkitService.findConvertMapByDictTypeCode(DictTypeCodeConstant.TPM_FEE_SOURCE);

            dataTypeMap = YearBudgetDataTypeEnum.concertEnumToMap();
            //先进行数据校验和字典校验，并构建基础数据
            yearBudgetImportsVos.forEach(importsVo -> {
                // 校验数据不能为空
                this.validateNullAndBuildBaseData(importsVo, errorMap);
            });
            //若有报错信息则返回
            if (!errorMap.isEmpty()) {
                return errorMap;
            }
            //构建主数据信息
            this.buildBaseMap(yearBudgetImportsVos);

            yearBudgetImportsVos.forEach(importsVo -> {
                this.buildBaseData(importsVo, errorMap);
            });
            //若有报错信息则返回
            if (!errorMap.isEmpty()) {
                return errorMap;
            }
            List<YearBudgetDto> yearBudgetDtoList = new ArrayList<>();
            //构建行明细
            yearBudgetImportsVos.forEach(importsVo -> {
                // 构建行明细
                List<YearBudgetDataDto> yearBudgetDataDtoList = this.buildDetailData(importsVo, errorMap);
                // 组装明细
                YearBudgetDto yearBudgetDto = this.nebulaToolkitService.copyObjectByWhiteList(importsVo, YearBudgetDto.class, LinkedHashSet.class, ArrayList.class);
                yearBudgetDto.setDataVos(yearBudgetDataDtoList);
                yearBudgetDtoList.add(yearBudgetDto);
            });
            //若有报错信息则返回
            if (!errorMap.isEmpty()) {
                return errorMap;
            }
            yearBudgetService.importSave(yearBudgetDtoList);
            return errorMap;
        } catch (Exception e) {
            log.error("", e);
            throw new IllegalArgumentException(e);
        }
    }

    /**
     * 校验并转换数据
     *
     * @param yearBudgetImportsVos
     * @return java.util.List<com.biz.crm.tpm.business.year.budget.sdk.dto.YearBudgetDto>
     * @author huojia
     * @date 2022/10/28 14:40
     **/
    public List<YearBudgetDto> testClass(List<YearBudgetImportsVo> yearBudgetImportsVos) {
        List<YearBudgetDto> yearBudgetDtoList = new ArrayList<>();

        // 构建基础数据map
        this.buildBaseMap(yearBudgetImportsVos);

        yearBudgetImportsVos.forEach(importsVo -> {

            // 校验数据不能为空
            // this.validateNull(importsVo);

            // 校验基础数据
            // this.buildBaseData(importsVo);

            // 校验数字
            this.buildDecimal(importsVo);

            // 构建行明细
//            List<YearBudgetDataDto> yearBudgetDataDtoList = this.buildDetailData(importsVo);

            // 组装明细
            YearBudgetDto yearBudgetDto = this.nebulaToolkitService.copyObjectByWhiteList(importsVo, YearBudgetDto.class, LinkedHashSet.class, ArrayList.class);
//            yearBudgetDto.setDataVos(yearBudgetDataDtoList);
            yearBudgetDtoList.add(yearBudgetDto);
        });
        return yearBudgetDtoList;
    }

    /**
     * 校验并转换数据
     *
     * @param data
     * @return java.util.List<com.biz.crm.tpm.business.year.budget.sdk.dto.YearBudgetDto>
     * @author huojia
     * @date 2022/10/28 14:40
     **/
//    private List<YearBudgetDto> validate(LinkedHashMap<Integer, YearBudgetImportsVo> data, Map<Integer, String> errorMap) {
//
//
//        List<YearBudgetDto> yearBudgetDtoList = new ArrayList<>();
//
//        // 构建基础数据map
//        this.buildBaseMap(yearBudgetImportsVos);
//
//        // 分组校验
//        yearBudgetImportsVos.forEach(importsVo -> {
//
//            // 校验数据不能为空
//            this.validateNull(importsVo);
//
//            // 校验基础数据
//            this.buildBaseData(importsVo);
//
//            // 校验数字
//            this.buildDecimal(importsVo);
//
//            // 构建行明细
//            List<YearBudgetDataDto> yearBudgetDataDtoList = this.buildDetailData(importsVo);
//
//            // 组装明细
//            YearBudgetDto yearBudgetDto = this.nebulaToolkitService.copyObjectByWhiteList(importsVo, YearBudgetDto.class, LinkedHashSet.class, ArrayList.class);
//            yearBudgetDto.setDataVos(yearBudgetDataDtoList);
//            yearBudgetDtoList.add(yearBudgetDto);
//        });
//        return yearBudgetDtoList;
//    }

    /**
     * 校验关键数据
     *
     * @param importsVo
     * @author huojia
     * @date 2023/1/2 18:38
     **/
    private void validateNullAndBuildBaseData(YearBudgetImportsVo importsVo, Map<Integer, String> errorMap) {
        StringBuilder builder = new StringBuilder();
        //业态
        if (StringUtils.isEmpty(importsVo.getBusinessFormatCode())) {
            builder.append("业态不能为空！");
        } else {
            if (!mdmBusinessFormatMap.containsKey(importsVo.getBusinessFormatCode())) {
                builder.append("业态")
                        .append(importsVo.getBusinessFormatCode())
                        .append("错误，请检查！");
            } else {
                importsVo.setBusinessFormatCode(mdmBusinessFormatMap.get(importsVo.getBusinessFormatCode()));
            }
        }
        //业务单元
        if (StringUtils.isEmpty(importsVo.getBusinessUnitCode())) {
            builder.append("业务单元不能为空！");
        } else {
            if (!mdmBusinessUnitMap.containsKey(importsVo.getBusinessUnitCode())) {
                builder.append("业务单元")
                        .append(importsVo.getBusinessUnitCode())
                        .append("错误，请检查！");
            } else {
                importsVo.setBusinessUnitCode(mdmBusinessUnitMap.get(importsVo.getBusinessUnitCode()));
            }
        }
        //importsVo.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
        if (StringUtils.isEmpty(importsVo.getYearLy())) {
            builder.append("年份不能为空！");
        } else {
            try {
                DateUtil.parseDate(importsVo.getYearLy(), "yyyy");
            } catch (Exception ignored) {
                builder.append("年份").append(importsVo.getYearLy()).append("格式错误，应该为yyyy!");
            }
        }
        //部门
        if (StringUtils.isEmpty(importsVo.getOrgCode())) {
            builder.append("部门编码不能为空！");
        }
        // 分组
        if (StringUtils.isEmpty(importsVo.getGroupCode())) {
            builder.append("分组不能为空！");
        } else {
            if (!tpmGroupCodeMap.containsKey(importsVo.getGroupCode())) {
                builder.append("分组").append(importsVo.getGroupCode()).append("错误，请检查！");
            } else {
                importsVo.setGroupCode(tpmGroupCodeMap.get(importsVo.getGroupCode()));
            }
        }
        //预算项目
        if (StringUtils.isEmpty(importsVo.getBudgetItemCode())) {
            builder.append("预算项目编码不能为空！");
        }
        // 费用归口
        if (!StringUtils.isEmpty(importsVo.getFeeBelongCode())) {
            if (!tpmFeeBelongMap.containsKey(importsVo.getFeeBelongCode())) {
                builder.append("费用归口").append(importsVo.getFeeBelongCode()).append("错误，请检查！");
            } else {
                importsVo.setFeeBelongCode(tpmFeeBelongMap.get(importsVo.getFeeBelongCode()));
            }
        } else {
            builder.append("费用归口不能为空！");
        }
        //销售组织
        if (StringUtils.isNotBlank(importsVo.getSalesOrgCode())) {
            if (StringUtils.isBlank(importsVo.getSalesInstitutionCode())) {
                builder.append("销售机构不能为空！");
            }
            importsVo.setCustomerChannelCode(CustomerChannelEnum.DISTRIBUTION.getCode());
            importsVo.setCustomerChannelName(CustomerChannelEnum.DISTRIBUTION.getDesc());
        }
        //客户编码
        if (StringUtils.isNotBlank(importsVo.getCustomerCode())) {
            if (StringUtils.isBlank(importsVo.getSalesInstitutionCode())) {
                builder.append("销售机构不能为空！");
            }
            importsVo.setCustomerChannelCode(CustomerChannelEnum.DISTRIBUTION.getCode());
            importsVo.setCustomerChannelName(CustomerChannelEnum.DISTRIBUTION.getDesc());
        }
        //销售机构
        if (StringUtils.isNotBlank(importsVo.getSalesInstitutionCode())) {
            if (StringUtils.isBlank(importsVo.getSalesOrgCode()) && StringUtils.isBlank(importsVo.getCustomerCode())) {
                builder.append("已填写销售机构，则销售组织或客户不能同时为空！");
            }
        }
        //预算总点数
        if (StringUtils.isEmpty(importsVo.getBudgetTotalPointStr())) {
            builder.append("预算总点数不能为空！");
        }
        //预算总金额
        if (StringUtils.isEmpty(importsVo.getBudgetTotalAmountStr())) {
            builder.append("预算总金额不能为空！");
        }
        //总目标量
        if (StringUtils.isEmpty(importsVo.getTotalGoalQuantityStr())) {
            builder.append("总目标量不能为空！");
        }
        //一月预算金额
        if (StringUtils.isEmpty(importsVo.getJanuaryNumStr())) {
            builder.append("一月预算金额不能为空！");
        }
        //二月预算金额
        if (StringUtils.isEmpty(importsVo.getFebruaryNumStr())) {
            builder.append("二月预算金额不能为空！");
        }
        //三月预算金额
        if (StringUtils.isEmpty(importsVo.getMarchNumStr())) {
            builder.append("三月预算金额不能为空！");
        }
        //四月预算金额
        if (StringUtils.isEmpty(importsVo.getAprilNumStr())) {
            builder.append("四月预算金额不能为空！");
        }
        //五月预算金额
        if (StringUtils.isEmpty(importsVo.getMayNumStr())) {
            builder.append("五月预算金额不能为空！");
        }
        //六月预算金额
        if (StringUtils.isEmpty(importsVo.getJuneNumStr())) {
            builder.append("六月预算金额不能为空！");
        }
        //七月预算金额
        if (StringUtils.isEmpty(importsVo.getJulyNumStr())) {
            builder.append("七月预算金额不能为空！");
        }
        //八月预算金额
        if (StringUtils.isEmpty(importsVo.getAugustNumStr())) {
            builder.append("八月预算金额不能为空！");
        }
        //九月预算金额
        if (StringUtils.isEmpty(importsVo.getSeptemberNumStr())) {
            builder.append("九月预算金额不能为空！");
        }
        //十月预算金额
        if (StringUtils.isEmpty(importsVo.getOctoberNumStr())) {
            builder.append("十月预算金额不能为空！");
        }
        //十一月预算金额
        if (StringUtils.isEmpty(importsVo.getNovemberNumStr())) {
            builder.append("十一月预算金额不能为空！");
        }
        //十二月预算金额
        if (StringUtils.isEmpty(importsVo.getDecemberNumStr())) {
            builder.append("十二月预算金额不能为空！");
        }
        String errorMsg = builder.toString();
        if (StringUtils.isNotBlank(errorMsg)) {
            errorMap.put(importsVo.getLineIndex(), errorMsg);
        }
    }

    /**
     * 获取维度配置，校验基础数据
     *
     * @param dimensionMap
     * @param importsVo
     * @param clazz
     * @author huojia
     * @date 2022/11/12 10:51
     **/
    private void buildDimension(Map<String, List<DimensionDimensionInformationVo>> dimensionMap, YearBudgetImportsVo importsVo, Class<YearBudgetImportsVo> clazz) {
        List<DimensionDimensionInformationVo> dimensionVoList = new ArrayList<>();
        if (!dimensionMap.containsKey(importsVo.getBusinessFormatCode() + importsVo.getBusinessUnitCode() + MenuCodeEnum.YEAR_BUDGET.getCode() + importsVo.getSalesOrgCode())) {
            // 获取维度配置
            DimensionInformationQueryData dto = new DimensionInformationQueryData();
            dto.setBusinessFormatCode(importsVo.getBusinessFormatCode());
            dto.setBusinessUnitCode(importsVo.getBusinessUnitCode());
            dto.setMenu(MenuCodeEnum.YEAR_BUDGET.getCode());
            dto.setSalesOrgCodeList(Arrays.asList(importsVo.getSalesOrgCode()));
            dimensionVoList = dimensionDimensionInformationService.findDetailsByCodes(dto);
            dimensionMap.put(importsVo.getBusinessFormatCode() + importsVo.getBusinessUnitCode() + MenuCodeEnum.YEAR_BUDGET.getCode() + importsVo.getSalesOrgCode(), dimensionVoList);
        } else {
            dimensionVoList = dimensionMap.get(importsVo.getBusinessFormatCode() + importsVo.getBusinessUnitCode() + MenuCodeEnum.YEAR_BUDGET.getCode() + importsVo.getSalesOrgCode());
        }
        if (CollectionUtils.isEmpty(dimensionVoList)) {
            throw new IllegalArgumentException("没有找到对应维度配置数据！");
        }
        // 根据维度配置，判断必填字段
        dimensionVoList.forEach(informationVo -> {
            try {
                if (StringUtils.isEmpty(informationVo.getFieldCoding())) {
                    return;
                }
                Field field = clazz.getDeclaredField(informationVo.getFieldCoding());
                field.setAccessible(true);
                Object o = field.get(importsVo);
                if (ObjectUtils.isEmpty(o)) {
                    throw new IllegalArgumentException(informationVo.getFieldName() + "不能为空！");
                }
            } catch (NoSuchFieldException | IllegalAccessException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        });
    }

    /**
     * 校验数字类型字段
     *
     * @param importsVo
     * @author huojia
     * @date 2022/11/10 20:44
     **/
    private void buildDecimal(YearBudgetImportsVo importsVo) {
        // 年度力度
        try {
            if (!StringUtils.isEmpty(importsVo.getBudgetIntensity())) {
                importsVo.setBudgetIntensityNumerator(new BigDecimal(importsVo.getBudgetIntensity().split("/")[0]));//分子
                importsVo.setBudgetIntensityDenominator(new BigDecimal(importsVo.getBudgetIntensity().split("/")[1]));//分母
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("年度力度" + importsVo.getBudgetIntensity() + "格式错误，请检查！");
        }
        // 预算点数
        try {
            if (!StringUtils.isEmpty(importsVo.getBudgetTotalPointStr())) {
                importsVo.setBudgetTotalPoint(new BigDecimal(importsVo.getBudgetTotalPointStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("预算总点数" + importsVo.getBudgetTotalPointStr() + "格式错误，请检查！");
        }
        // 预算总金额
        try {
            if (!StringUtils.isEmpty(importsVo.getBudgetTotalAmountStr())) {
                importsVo.setBudgetTotalAmount(new BigDecimal(importsVo.getBudgetTotalAmountStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("预算总金额" + importsVo.getBudgetTotalAmountStr() + "格式错误，请检查！");
        }
        // 总目标量
        try {
            if (!StringUtils.isEmpty(importsVo.getTotalGoalQuantityStr())) {
                importsVo.setTotalGoalQuantity(new BigDecimal(importsVo.getTotalGoalQuantityStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("总目标量" + importsVo.getTotalGoalQuantityStr() + "格式错误，请检查！");
        }
        // 策略关联金额
        /*try {
            if (!StringUtils.isEmpty(importsVo.getStrategyAmountStr())) {
                importsVo.setStrategyAmount(new BigDecimal(importsVo.getStrategyAmountStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("策略关联金额" + importsVo.getStrategyAmountStr() + "格式错误，请检查！");
        }
        // 剩余可关联金额
        try {
            if (!StringUtils.isEmpty(importsVo.getRemainderAmountStr())) {
                importsVo.setRemainderAmount(new BigDecimal(importsVo.getRemainderAmountStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("剩余可关联金额" + importsVo.getRemainderAmountStr() + "格式错误，请检查！");
        }*/
    }

    /**
     * 校验基础数据
     *
     * @param importsVo
     * @author huojia
     * @date 2022/11/10 20:42
     **/
    private void buildBaseData(YearBudgetImportsVo importsVo, Map<Integer, String> errorMap) {
        StringBuilder builder = new StringBuilder();
        //部门
        if (!orgVoMap.containsKey(importsVo.getOrgCode())) {
            builder.append("部门编码").append(importsVo.getOrgCode()).append("错误，请检查！");
        } else {
            importsVo.setOrgName(orgVoMap.get(importsVo.getOrgCode()).getOrgName());
            importsVo.setOrgLevelCode(orgVoMap.get(importsVo.getOrgCode()).getOrgLevel());
        }
        // 校验预算项目
        if (budgetItemVoMap.containsKey(importsVo.getBudgetItemCode())) {
            importsVo.setBudgetItemName(budgetItemVoMap.get(importsVo.getBudgetItemCode()).getBudgetItemName());
            importsVo.setBudgetItemLevelCode(budgetItemVoMap.get(importsVo.getBudgetItemCode()).getBudgetItemLevelCode());
        } else {
            builder.append("预算项目编码").append(importsVo.getBudgetItemCode()).append("错误，请检查！");
        }
        // 销售组织
        if (!StringUtils.isEmpty(importsVo.getSalesOrgCode())) {
            String insCode = importsVo.getCustomerChannelCode() + importsVo.getBusinessFormatCode() + importsVo.getSalesInstitutionCode();
            if (!salesOrgMap.containsKey(insCode)) {
                builder.append("销售机构").append(importsVo.getSalesInstitutionCode())
                        .append("下未查找到此销售组织").append(importsVo.getSalesOrgCode()).append(",请检查！");
            } else {
                Map<String, SalesOrgVo> salesMap = salesOrgMap.get(insCode);
                if (salesMap.containsKey(importsVo.getSalesOrgCode())) {
                    SalesOrgVo salesVo = salesMap.get(importsVo.getSalesOrgCode());
                    importsVo.setSalesOrgErpCode(importsVo.getSalesOrgCode());
                    importsVo.setSalesOrgName(salesVo.getSalesOrgName());
                    importsVo.setSalesOrgLevelCode(salesVo.getSalesOrgLevel());
                    importsVo.setSalesOrgCode(salesVo.getSalesOrgCode());
                } else {
                    builder.append("销售机构").append(importsVo.getSalesInstitutionCode())
                            .append("下未查找到此销售组织").append(importsVo.getSalesOrgCode()).append(",请检查！");
                }
            }
        }
        // 客户
        if (!StringUtils.isEmpty(importsVo.getCustomerCode())) {
            String cusCode = importsVo.getCustomerCode() + importsVo.getSalesInstitutionCode() + importsVo.getCustomerChannelCode() + importsVo.getBusinessFormatCode();
            if (customerVoMap.containsKey(cusCode)) {
                CustomerVo cusVo = customerVoMap.get(cusCode);
                importsVo.setCustomerErpCode(cusVo.getErpCode());
                importsVo.setCustomerCode(cusVo.getCustomerCode());
                importsVo.setCustomerName(cusVo.getCustomerName());
            } else {
                builder.append("销售机构").append(importsVo.getSalesInstitutionCode())
                        .append("下未查找到此客户编码").append(importsVo.getCustomerCode()).append(",请检查！");
            }
        }
        // 产品品牌
        if (!StringUtils.isEmpty(importsVo.getProductBrandCode())) {
            if (productBrandVoMap.containsKey(importsVo.getProductBrandCode())) {
                importsVo.setProductBrandName(productBrandVoMap.get(importsVo.getProductBrandCode()).getProductBrandName());
            } else {
                builder.append("产品品牌").append(importsVo.getProductBrandCode()).append("错误，请检查！");
            }
        }
        // 产品品类
        if (!StringUtils.isEmpty(importsVo.getProductCategoryCode())) {
            if (productCategoryVoMap.containsKey(importsVo.getProductCategoryCode())) {
                importsVo.setProductCategoryName(productCategoryVoMap.get(importsVo.getProductCategoryCode()).getProductLevelName());
            } else {
                builder.append("产品品类").append(importsVo.getProductCategoryCode()).append("错误，请检查！");
            }
        }
        // 产品品项
        if (!StringUtils.isEmpty(importsVo.getProductItemCode())) {
            if (productItemVoMap.containsKey(importsVo.getProductItemCode())) {
                importsVo.setProductItemName(productItemVoMap.get(importsVo.getProductItemCode()).getProductLevelName());
            } else {
                builder.append("产品品项").append(importsVo.getProductCategoryCode()).append("错误，请检查！");
            }
        }
        // 产品
        if (!StringUtils.isEmpty(importsVo.getProductCode())) {
            if (productVoMap.containsKey(importsVo.getProductCode())) {
                importsVo.setProductName(productVoMap.get(importsVo.getProductCode()).getProductName());
            } else {
                builder.append("产品编码").append(importsVo.getProductCode()).append("错误，请检查！");
            }
        }
        // 年度力度
        try {
            if (!StringUtils.isEmpty(importsVo.getBudgetIntensity())) {
                importsVo.setBudgetIntensityNumerator(new BigDecimal(importsVo.getBudgetIntensity().split("/")[0]));//分子
                importsVo.setBudgetIntensityDenominator(new BigDecimal(importsVo.getBudgetIntensity().split("/")[1]));//分母
            }
        } catch (Exception e) {
            builder.append("年度力度").append(importsVo.getBudgetIntensity()).append("格式错误，请检查！");
        }
        // 预算点数
        try {
            if (!StringUtils.isEmpty(importsVo.getBudgetTotalPointStr())) {
                importsVo.setBudgetTotalPoint(new BigDecimal(importsVo.getBudgetTotalPointStr()));
            }
        } catch (Exception e) {
            builder.append("预算总点数").append(importsVo.getBudgetTotalPointStr()).append("格式错误，请检查！");
        }
        // 预算总金额
        try {
            if (!StringUtils.isEmpty(importsVo.getBudgetTotalAmountStr())) {
                importsVo.setBudgetTotalAmount(new BigDecimal(importsVo.getBudgetTotalAmountStr()));
            }
        } catch (Exception e) {
            builder.append("预算总金额").append(importsVo.getBudgetTotalAmountStr()).append("格式错误，请检查！");
        }
        // 总目标量
        try {
            if (!StringUtils.isEmpty(importsVo.getTotalGoalQuantityStr())) {
                importsVo.setTotalGoalQuantity(new BigDecimal(importsVo.getTotalGoalQuantityStr()));
            }
        } catch (Exception e) {
            builder.append("总目标量").append(importsVo.getTotalGoalQuantityStr()).append("格式错误，请检查！");
        }

        String errorMsg = builder.toString();
        if (StringUtils.isNotBlank(errorMsg)) {
            errorMap.put(importsVo.getLineIndex(), errorMsg);
        }
    }

    /**
     * 构建行明细
     *
     * @param budgetData
     * @return java.util.List<com.biz.crm.tpm.business.year.budget.sdk.dto.YearBudgetDataDto>
     * @author huojia
     * @date 2022/11/10 20:39
     **/
    private List<YearBudgetDataDto> buildDetailData(YearBudgetImportsVo budgetData, Map<Integer, String> errorMap) {
        List<YearBudgetDataDto> yearBudgetDataDtoList = new ArrayList<>();
        YearBudgetDataDto yearBudgetDataQuantityDto = new YearBudgetDataDto();
        yearBudgetDataQuantityDto.setDataType(YearBudgetDataTypeEnum.GOAL_QUANTITY.getCode());
        YearBudgetDataDto yearBudgetPointDataDto = new YearBudgetDataDto();
        yearBudgetPointDataDto.setDataType(YearBudgetDataTypeEnum.BUDGET_POINT.getCode());
        yearBudgetPointDataDto.setSortNum(dataTypeMap.get(yearBudgetPointDataDto.getDataType()));
        budgetData.setDataType(YearBudgetDataTypeEnum.BUDGET_AMOUNT.getCode());
        budgetData.setSortNum(dataTypeMap.get(budgetData.getDataType()));

        // 校验金额
        StringBuilder builder = new StringBuilder();
        // 一月份
        try {
            if (!StringUtils.isEmpty(budgetData.getJanuaryNumStr())) {
                budgetData.setJanuaryNum(new BigDecimal(budgetData.getJanuaryNumStr()));
            }
        } catch (Exception e) {
            builder.append("一月份预算金额").append(budgetData.getJanuaryNumStr()).append("格式错误，请检查！");
        }
        try {
            if (!StringUtils.isEmpty(budgetData.getJanuaryPointNumStr())) {
                yearBudgetPointDataDto.setJanuaryNum(new BigDecimal(budgetData.getJanuaryPointNumStr()));
            }
        } catch (Exception e) {
            builder.append("一月份预算点数").append(budgetData.getJanuaryPointNumStr()).append("格式错误，请检查！");
        }
        // 二月份
        try {
            if (!StringUtils.isEmpty(budgetData.getFebruaryNumStr())) {
                budgetData.setFebruaryNum(new BigDecimal(budgetData.getFebruaryNumStr()));
            }
        } catch (Exception e) {
            builder.append("二月份预算金额").append(budgetData.getFebruaryNumStr()).append("格式错误，请检查！");
        }
        try {
            if (!StringUtils.isEmpty(budgetData.getFebruaryPointNumStr())) {
                yearBudgetPointDataDto.setFebruaryNum(new BigDecimal(budgetData.getFebruaryPointNumStr()));
            }
        } catch (Exception e) {
            builder.append("二月份预算金额").append(budgetData.getFebruaryPointNumStr()).append("格式错误，请检查！");
        }
        // 三月份
        try {
            if (!StringUtils.isEmpty(budgetData.getMarchNumStr())) {
                budgetData.setMarchNum(new BigDecimal(budgetData.getMarchNumStr()));
            }
        } catch (Exception e) {
            builder.append("三月份预算金额").append(budgetData.getMarchNumStr()).append("格式错误，请检查！");
        }
        try {
            if (!StringUtils.isEmpty(budgetData.getMarchPointNumStr())) {
                yearBudgetPointDataDto.setMarchNum(new BigDecimal(budgetData.getMarchPointNumStr()));
            }
        } catch (Exception e) {
            builder.append("三月份预算点数").append(budgetData.getMarchPointNumStr()).append("格式错误，请检查！");
        }
        // 四月份
        try {
            if (!StringUtils.isEmpty(budgetData.getAprilNumStr())) {
                budgetData.setAprilNum(new BigDecimal(budgetData.getAprilNumStr()));
            }
        } catch (Exception e) {
            builder.append("四月份预算金额").append(budgetData.getAprilNumStr()).append("格式错误，请检查！");
        }
        try {
            if (!StringUtils.isEmpty(budgetData.getAprilPointNumStr())) {
                yearBudgetPointDataDto.setAprilNum(new BigDecimal(budgetData.getAprilPointNumStr()));
            }
        } catch (Exception e) {
            builder.append("四月份预算点数").append(budgetData.getAprilPointNumStr()).append("格式错误，请检查！");
        }
        // 五月份
        try {
            if (!StringUtils.isEmpty(budgetData.getMayNumStr())) {
                budgetData.setMayNum(new BigDecimal(budgetData.getMayNumStr()));
            }
        } catch (Exception e) {
            builder.append("五月份预算金额").append(budgetData.getMayNumStr()).append("格式错误，请检查！");
        }
        try {
            if (!StringUtils.isEmpty(budgetData.getMayPointNumStr())) {
                yearBudgetPointDataDto.setMayNum(new BigDecimal(budgetData.getMayPointNumStr()));
            }
        } catch (Exception e) {
            builder.append("五月份预算点数").append(budgetData.getMayPointNumStr()).append("格式错误，请检查！");
        }
        // 六月份
        try {
            if (!StringUtils.isEmpty(budgetData.getJuneNumStr())) {
                budgetData.setJuneNum(new BigDecimal(budgetData.getJuneNumStr()));
            }
        } catch (Exception e) {
            builder.append("六月份预算金额").append(budgetData.getJuneNumStr()).append("格式错误，请检查！");
        }
        try {
            if (!StringUtils.isEmpty(budgetData.getJunePointNumStr())) {
                yearBudgetPointDataDto.setJuneNum(new BigDecimal(budgetData.getJunePointNumStr()));
            }
        } catch (Exception e) {
            builder.append("六月份预算点数").append(budgetData.getJunePointNumStr()).append("格式错误，请检查！");
        }
        // 七月份
        try {
            if (!StringUtils.isEmpty(budgetData.getJulyNumStr())) {
                budgetData.setJulyNum(new BigDecimal(budgetData.getJulyNumStr()));
            }
        } catch (Exception e) {
            builder.append("七月份预算金额").append(budgetData.getJulyNumStr()).append("格式错误，请检查！");
        }
        try {
            if (!StringUtils.isEmpty(budgetData.getJulyPointNumStr())) {
                yearBudgetPointDataDto.setJulyNum(new BigDecimal(budgetData.getJulyPointNumStr()));
            }
        } catch (Exception e) {
            builder.append("七月份预算点数").append(budgetData.getJulyPointNumStr()).append("格式错误，请检查！");
        }
        // 八月份
        try {
            if (!StringUtils.isEmpty(budgetData.getAugustNumStr())) {
                budgetData.setAugustNum(new BigDecimal(budgetData.getAugustNumStr()));
            }
        } catch (Exception e) {
            builder.append("八月份预算金额").append(budgetData.getAugustNumStr()).append("格式错误，请检查！");
        }
        try {
            if (!StringUtils.isEmpty(budgetData.getAugustPointNumStr())) {
                yearBudgetPointDataDto.setAugustNum(new BigDecimal(budgetData.getAugustPointNumStr()));
            }
        } catch (Exception e) {
            builder.append("八月份预算点数").append(budgetData.getAugustPointNumStr()).append("格式错误，请检查！");
        }
        // 九月份
        try {
            if (!StringUtils.isEmpty(budgetData.getSeptemberNumStr())) {
                budgetData.setSeptemberNum(new BigDecimal(budgetData.getSeptemberNumStr()));
            }
        } catch (Exception e) {
            builder.append("九月份预算金额").append(budgetData.getSeptemberNumStr()).append("格式错误，请检查！");
        }
        try {
            if (!StringUtils.isEmpty(budgetData.getSeptemberPointNumStr())) {
                yearBudgetPointDataDto.setSeptemberNum(new BigDecimal(budgetData.getSeptemberPointNumStr()));
            }
        } catch (Exception e) {
            builder.append("九月份预算点数").append(budgetData.getSeptemberPointNumStr()).append("格式错误，请检查！");
        }
        // 十月份
        try {
            if (!StringUtils.isEmpty(budgetData.getOctoberNumStr())) {
                budgetData.setOctoberNum(new BigDecimal(budgetData.getOctoberNumStr()));
            }
        } catch (Exception e) {
            builder.append("十月份预算金额").append(budgetData.getOctoberNumStr()).append("格式错误，请检查！");
        }
        try {
            if (!StringUtils.isEmpty(budgetData.getOctoberPointNumStr())) {
                yearBudgetPointDataDto.setOctoberNum(new BigDecimal(budgetData.getOctoberPointNumStr()));
            }
        } catch (Exception e) {
            builder.append("十月份预算点数").append(budgetData.getOctoberPointNumStr()).append("格式错误，请检查！");
        }
        // 十一月份
        try {
            if (!StringUtils.isEmpty(budgetData.getNovemberNumStr())) {
                budgetData.setNovemberNum(new BigDecimal(budgetData.getNovemberNumStr()));
            }
        } catch (Exception e) {
            builder.append("十一月份预算金额").append(budgetData.getNovemberNumStr()).append("格式错误，请检查！");
        }
        try {
            if (!StringUtils.isEmpty(budgetData.getNovemberPointNumStr())) {
                yearBudgetPointDataDto.setNovemberNum(new BigDecimal(budgetData.getNovemberPointNumStr()));
            }
        } catch (Exception e) {
            builder.append("十一月份预算点数").append(budgetData.getNovemberPointNumStr()).append("格式错误，请检查！");
        }
        // 十二月份
        try {
            if (!StringUtils.isEmpty(budgetData.getDecemberNumStr())) {
                budgetData.setDecemberNum(new BigDecimal(budgetData.getDecemberNumStr()));
            }
        } catch (Exception e) {
            builder.append("十二月份预算金额").append(budgetData.getDecemberNumStr()).append("格式错误，请检查！");
        }
        try {
            if (!StringUtils.isEmpty(budgetData.getDecemberPointNumStr())) {
                yearBudgetPointDataDto.setDecemberNum(new BigDecimal(budgetData.getDecemberPointNumStr()));
            }
        } catch (Exception e) {
            builder.append("十二月份预算点数").append(budgetData.getDecemberPointNumStr()).append("格式错误，请检查！");
        }
        String errorMsg = builder.toString();
        if (StringUtils.isNotBlank(errorMsg)) {
            errorMap.put(budgetData.getLineIndex(), errorMsg);
        }
        YearBudgetDataDto yearBudgetDataDto = this.nebulaToolkitService.copyObjectByWhiteList(budgetData, YearBudgetDataDto.class, LinkedHashSet.class, ArrayList.class);
        yearBudgetDataDtoList.add(yearBudgetDataQuantityDto);
        yearBudgetDataDtoList.add(yearBudgetDataDto);
        yearBudgetDataDtoList.add(yearBudgetPointDataDto);
        return yearBudgetDataDtoList;
    }

    /**
     * 构建基础数据map
     *
     * @param yearBudgetImportsVos
     * @author huojia
     * @date 2022/11/10 20:31
     **/
    private void buildBaseMap(List<YearBudgetImportsVo> yearBudgetImportsVos) {
        // 查询主数据数据，校验
//        Set<String> orgCodeSet = yearBudgetImportsVos.stream().map(YearBudgetImportsVo::getOrgCode).filter(Objects::nonNull).collect(Collectors.toSet());
//        Set<String> yearBudgetSet = yearBudgetImportsVos.stream().map(YearBudgetImportsVo::getYearBudgetCode).filter(Objects::nonNull).collect(Collectors.toSet());
//        Set<String> budgetItemSet = yearBudgetImportsVos.stream().map(YearBudgetImportsVo::getBudgetItemCode).filter(Objects::nonNull).collect(Collectors.toSet());
//        Set<String> salesOrgCodeSet = yearBudgetImportsVos.stream().map(YearBudgetImportsVo::getSalesOrgCode).filter(Objects::nonNull).collect(Collectors.toSet());
////        Set<String> customerChannelCodeSet = yearBudgetImportsVos.stream().map(YearBudgetImportsVo::getCustomerChannelCode).filter(Objects::nonNull).collect(Collectors.toSet());
////        Set<String> terminalChannelCodeSet = yearBudgetImportsVos.stream().map(YearBudgetImportsVo::getTerminalChannelCode).filter(Objects::nonNull).collect(Collectors.toSet());
////        Set<String> systemCodeSet = yearBudgetImportsVos.stream().map(YearBudgetImportsVo::getSystemCode).filter(Objects::nonNull).collect(Collectors.toSet());
//        Set<String> customerCodeSet = yearBudgetImportsVos.stream().map(YearBudgetImportsVo::getCustomerCode).filter(Objects::nonNull).collect(Collectors.toSet());
////        Set<String> terminalCodeSet = yearBudgetImportsVos.stream().map(YearBudgetImportsVo::getTerminalCode).filter(Objects::nonNull).collect(Collectors.toSet());
//        Set<String> productBrandCodeSet = yearBudgetImportsVos.stream().map(YearBudgetImportsVo::getProductBrandCode).filter(Objects::nonNull).collect(Collectors.toSet());
//        Set<String> productCategoryCodeSet = yearBudgetImportsVos.stream().map(YearBudgetImportsVo::getProductCategoryCode).filter(Objects::nonNull).collect(Collectors.toSet());
//        Set<String> productItemCodeSet = yearBudgetImportsVos.stream().map(YearBudgetImportsVo::getProductItemCode).filter(Objects::nonNull).collect(Collectors.toSet());
//        Set<String> productCodeSet = yearBudgetImportsVos.stream().map(YearBudgetImportsVo::getProductCode).filter(Objects::nonNull).collect(Collectors.toSet());

        Set<String> orgCodeSet = new HashSet<>();
        Set<String> yearBudgetSet = new HashSet<>();
        Set<String> budgetItemSet = new HashSet<>();
        Set<String> salesOrgErpCodeSet = new HashSet<>();
        Set<String> salesInstitutionCodeSet = new HashSet<>();
        Set<String> customerCodeSet = new HashSet<>();
        Set<String> productBrandCodeSet = new HashSet<>();
        Set<String> productCategoryCodeSet = new HashSet<>();
        Set<String> productItemCodeSet = new HashSet<>();
        Set<String> productCodeSet = new HashSet<>();
        for (YearBudgetImportsVo importsVo : yearBudgetImportsVos) {
            if (StringUtils.isNotBlank(importsVo.getOrgCode())) {
                orgCodeSet.add(importsVo.getOrgCode());
            }
            if (StringUtils.isNotBlank(importsVo.getYearBudgetCode())) {
                yearBudgetSet.add(importsVo.getYearBudgetCode());
            }
            if (StringUtils.isNotBlank(importsVo.getBudgetItemCode())) {
                budgetItemSet.add(importsVo.getBudgetItemCode());
            }
            if (StringUtils.isNotBlank(importsVo.getOrgCode())) {
                orgCodeSet.add(importsVo.getOrgCode());
            }
            if (StringUtils.isNotBlank(importsVo.getSalesInstitutionCode())) {
                salesInstitutionCodeSet.add(importsVo.getCustomerChannelCode() + importsVo.getBusinessFormatCode() + importsVo.getSalesInstitutionCode());
            }
            if (StringUtils.isNotBlank(importsVo.getSalesOrgCode())) {
                salesOrgErpCodeSet.add(importsVo.getSalesOrgCode());
            }
            if (StringUtils.isNotBlank(importsVo.getCustomerCode())) {
                customerCodeSet.add(importsVo.getCustomerCode() + importsVo.getSalesInstitutionCode() + importsVo.getCustomerChannelCode() + importsVo.getBusinessFormatCode());
            }
            if (StringUtils.isNotBlank(importsVo.getProductBrandCode())) {
                productBrandCodeSet.add(importsVo.getProductBrandCode());
            }
            if (StringUtils.isNotBlank(importsVo.getProductCategoryCode())) {
                productCategoryCodeSet.add(importsVo.getProductCategoryCode());
            }
            if (StringUtils.isNotBlank(importsVo.getProductItemCode())) {
                productItemCodeSet.add(importsVo.getProductItemCode());
            }
            if (StringUtils.isNotBlank(importsVo.getProductCode())) {
                productCodeSet.add(importsVo.getProductCode());
            }
        }

        // 获取年度预算
//        if (!CollectionUtils.isEmpty(yearBudgetSet)) {
//            List<YearBudgetVo> yearBudgetVoList = yearBudgetService.listByCodes(new ArrayList<>(yearBudgetSet));
//            if (!CollectionUtils.isEmpty(yearBudgetVoList)) {
//                yearBudgetVoMap = yearBudgetVoList.stream().collect(Collectors.toMap(YearBudgetVo::getYearBudgetCode, Function.identity()));
//            }
//        }

        // 校验组织
        if (!CollectionUtils.isEmpty(orgCodeSet)) {
            List<OrgVo> orgVoList = orgVoService.findByOrgCodes(new ArrayList<>(orgCodeSet));
            if (!CollectionUtils.isEmpty(orgVoList)) {
                orgVoMap = orgVoList.stream().collect(Collectors.toMap(OrgVo::getOrgCode, Function.identity()));
            }
        }

        // 预算项目
        if (!CollectionUtils.isEmpty(budgetItemSet)) {
            List<BudgetItemVo> budgetItemVoList = budgetItemService.listByCodes(new ArrayList<>(budgetItemSet));
            if (!CollectionUtils.isEmpty(budgetItemVoList)) {
                budgetItemVoMap = budgetItemVoList.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, Function.identity()));
            }
        }

        // 销售组织
        if (!CollectionUtils.isEmpty(salesInstitutionCodeSet) && !CollectionUtils.isEmpty(salesOrgErpCodeSet)) {
            SalesOrgRangeDto rangeDto = new SalesOrgRangeDto();
            rangeDto.setErpCodes(new ArrayList<>(salesOrgErpCodeSet));
            rangeDto.setSalesInstitutionCodes(new ArrayList<>(salesInstitutionCodeSet));
            salesOrgMap = salesOrgVoService.findMapBySalesOrgErpCodesAndInsCodes(rangeDto);
        }

        // 客户渠道
//        if (!CollectionUtils.isEmpty(customerChannelCodeSet)) {
//            List<CustomerChannelVo> customerChannelVos = customerChannelVoService.findByCodes(new ArrayList<>(customerChannelCodeSet));
//            if (!CollectionUtils.isEmpty(customerChannelVos)) {
//                customerChannelVoMap = customerChannelVos.stream().collect(Collectors.toMap(CustomerChannelVo::getCustomerChannelCode, Function.identity()));
//            }
//        }

        // 终端渠道
//        if (!CollectionUtils.isEmpty(terminalChannelCodeSet)) {
//            List<MdmTerminalChannelVo> mdmTerminalChannelVos = mdmTerminalChannelVoService.listByCodes(new ArrayList<>(terminalChannelCodeSet));
//            if (!CollectionUtils.isEmpty(mdmTerminalChannelVos)) {
//                terminalChannelVoMap = mdmTerminalChannelVos.stream().collect(Collectors.toMap(MdmTerminalChannelVo::getTerminalChannelCode, Function.identity()));
//            }
//        }

        // 客户
        if (!CollectionUtils.isEmpty(customerCodeSet)) {
            List<CustomerVo> customerVos = customerVoService.findByCustomerCodes(new ArrayList<>(customerCodeSet));
            if (!CollectionUtils.isEmpty(customerVos)) {
                customerVoMap = customerVos.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
            }
        }

        // 终端
//        if (!CollectionUtils.isEmpty(terminalCodeSet)) {
//            List<TerminalVo> terminalVos = terminalVoService.findDetailsByIdsOrTerminalCodes(null, new ArrayList<>(terminalCodeSet));
//            if (!CollectionUtils.isEmpty(terminalVos)) {
//                terminalVoMap = terminalVos.stream().collect(Collectors.toMap(TerminalVo::getTerminalCode, Function.identity()));
//            }
//        }

        // 品牌
        if (!CollectionUtils.isEmpty(productBrandCodeSet)) {
            List<ProductBrandVo> productBrandVos = productBrandService.listByCodes(new ArrayList<>(productBrandCodeSet));
            if (!CollectionUtils.isEmpty(productBrandVos)) {
                productBrandVoMap = productBrandVos.stream().collect(Collectors.toMap(ProductBrandVo::getProductBrandCode, Function.identity()));
            }
        }

        // 品类
        if (!CollectionUtils.isEmpty(productCategoryCodeSet)) {
            List<ProductLevelVo> productLevelVos = productLevelVoSdkService.findListByCodes(new ArrayList<>(productCategoryCodeSet));
            if (!CollectionUtils.isEmpty(productLevelVos)) {
                productCategoryVoMap = productLevelVos.stream().collect(Collectors.toMap(ProductLevelVo::getProductLevelCode, Function.identity()));
            }
        }

        // 品项
        if (!CollectionUtils.isEmpty(productItemCodeSet)) {
            List<ProductLevelVo> productLevelVos = productLevelVoSdkService.findListByCodes(new ArrayList<>(productItemCodeSet));
            if (!CollectionUtils.isEmpty(productLevelVos)) {
                productItemVoMap = productLevelVos.stream().collect(Collectors.toMap(ProductLevelVo::getProductLevelCode, Function.identity()));
            }
        }

        // 产品
        if (!CollectionUtils.isEmpty(productCodeSet)) {
            List<ProductVo> productVoList = productVoService.findByCodes(new ArrayList<>(productCodeSet));
            if (!CollectionUtils.isEmpty(productVoList)) {
                productVoMap = productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity()));
            }
        }
    }

    @Override
    public Class<YearBudgetImportsVo> findCrmExcelVoClass() {
        return YearBudgetImportsVo.class;
    }

    @Override
    public String getTemplateCode() {
        return "TPM_YEAR_BUDGET_HEAD_IMPORT";
    }

    @Override
    public String getTemplateName() {
        return "TPM-年度预算主体导入";
    }

    @Override
    public String getBusinessCode() {
        return "TPM_YEAR_BUDGET_IMPORT";
    }

    @Override
    public String getBusinessName() {
        return "TPM-年度预算导入";
    }
}
