package com.biz.crm.tpm.business.year.budget.local.service.process;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.customer.retailer.sdk.service.CustomerRetailerVoService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.product.brand.sdk.service.ProductBrandService;
import com.biz.crm.mdm.business.product.brand.sdk.vo.ProductBrandVo;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mdm.business.terminal.channel.sdk.service.MdmTerminalChannelVoService;
import com.biz.crm.mdm.business.terminal.channel.sdk.vo.MdmTerminalChannelVo;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.ExceptionStackMsgUtil;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.service.DimensionDimensionInformationService;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.vo.DimensionDimensionInformationVo;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetImportsVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.tpm.business.sales.goal.sdk.constant.DictTypeCodeConstant;
import com.biz.crm.tpm.business.year.budget.local.service.YearBudgetService;
import com.biz.crm.tpm.business.year.budget.sdk.dto.YearBudgetDataDto;
import com.biz.crm.tpm.business.year.budget.sdk.dto.YearBudgetDto;
import com.biz.crm.tpm.business.year.budget.sdk.eunm.YearBudgetDataTypeEnum;
import com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetVerticalImportsVo;
import com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author huojia
 * @date 2022年10月28日 11:42
 */
@Slf4j
@Component
public class YearBudgetVerticalImportsProcess implements ImportProcess<YearBudgetVerticalImportsVo> {

    @Resource
    private OrgVoService orgVoService;

    @Resource
    private ProductVoService productVoService;

    @Resource
    private CustomerVoService customerVoService;

    @Resource
    private TerminalVoService terminalVoService;

    @Resource
    private SalesOrgVoService salesOrgVoService;

    @Resource
    private CustomerChannelVoService customerChannelVoService;

    @Resource
    private MdmTerminalChannelVoService mdmTerminalChannelVoService;

    @Resource
    private ProductBrandService productBrandService;

    @Resource
    private ProductLevelVoSdkService productLevelVoSdkService;

    @Resource
    private BudgetItemService budgetItemService;

    @Resource
    private YearBudgetService yearBudgetService;

    @Resource
    private DictToolkitService dictToolkitService;

    @Resource
    private NebulaToolkitService nebulaToolkitService;

    @Resource
    private DictDataVoService dictDataVoService;

    /**
     * 区域数据字典编码
     */
    private static final String DICT_REGION_CODE = "MDM_CUSTOMIZE_ORG";

    /**
     * 区域 key 区域名称， value 区域编码
     */
    private Map<String, List<DictDataVo>> dictMap = Maps.newHashMap();

    /**
     * 零售商 key 名称，value 编码
     */
    private Map<String, String> systemMap = Maps.newHashMap();

    @Autowired(required = false)
    private CustomerRetailerVoService promotersVoService;

    @Override
    public Map<Integer, String> execute(LinkedHashMap<Integer, YearBudgetVerticalImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Map<Integer, String> errMap = new HashMap<>();
        try {
            Validate.notEmpty(data, "导入数据不能为空！");
            data.forEach((z,y)->y.setLineIndex(z));
            List<YearBudgetDto> importList = this.validate(data, errMap);

            if (!errMap.isEmpty()) {
                return errMap;
            }

            //构建基础数据
            this.initDict();
            this.initBaseData(importList);
            importList.forEach(dto -> {
                //区域
                if(org.springframework.util.StringUtils.hasText(dto.getRegionName())){
                    dto.setRegionCode(this.findDictValue(dto.getRegionName(), this.DICT_REGION_CODE));
                }
                //零售商
                if(org.springframework.util.StringUtils.hasText(dto.getSystemName())){
                    dto.setSystemCode(this.systemMap.get(dto.getSystemName()));
                }
                //唯一校验
                try {
                    this.verifyUniqueness(dto);
                } catch (Exception e) {
                    this.validateIsTrue(false, "唯一校验异常【"+ e.getMessage() +"】");
                }

                String errInfo = this.validateGetErrorInfo();
                if (errInfo != null) {
                    errMap.put(dto.getLineIndex(), errInfo);
                }
            });

            if (!errMap.isEmpty()) {
                return errMap;
            }

            yearBudgetService.importSave(importList);
        } catch (IllegalArgumentException e) {
            throw e;
        } catch (Exception e) {
            String error = ExceptionStackMsgUtil.stackMsg(e);
            log.error("年度预算电商导入异常:{}", error);
            throw new IllegalArgumentException("导入异常[" + error + "]");
        }
        return errMap;
    }

    private void initBaseData(List<YearBudgetDto> importList) {
        //零售商名称集合
        Map<String, String> systemAllMap = this.promotersVoService.getAllRetailerCode();
        if(!CollectionUtils.isEmpty(systemAllMap)){
            systemAllMap.forEach((k, v) -> {
                this.systemMap.put(v, k);
            });
        }
    }

    private void initDict() {
        this.dictMap = this.dictDataVoService.findByDictTypeCodeList(
            Lists.newArrayList(this.DICT_REGION_CODE));
    }

    /**
     * 数据分片
     *
     * @return 分片长度
     */
    @Override
    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    /**
     * 是否开启先校验后导入的模式 默认false: false执行旧逻辑 true执行新逻辑(先校验再保存) <br/>
     * 新逻辑需同时实现接口 tryVerify tryConfirm（默认方法调用execute）
     *
     * @return
     */
    @Override
    public boolean importBeforeValidationFlag() {
        return Boolean.TRUE;
    }

    /**
     * 数据校验
     *
     * @param data     待处理的数据集合，k-流水号，v-excel解析后的对象
     * @param paramsVo 任务公共参数
     * @param params   导入任务自定义参数
     * @return k-对应data的k，v-对应data的k对应的v处理异常描述信息，会回写到错误文件
     */
    @Override
    public Map<Integer, String> tryVerify(LinkedHashMap<Integer, YearBudgetVerticalImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Map<Integer, String> errMap = new HashMap<>();
        for (Map.Entry<Integer, YearBudgetVerticalImportsVo> row : data.entrySet()) {
            int rowNum = row.getKey();
            YearBudgetVerticalImportsVo importsVo = row.getValue();
            if (StringUtils.isEmpty(importsVo.getBusinessFormatCode())) {
                this.validateIsTrue(false, "业态不能为空！");
            }
            if (StringUtils.isEmpty(importsVo.getBusinessUnitCode())) {
                this.validateIsTrue(false, "业务单元不能为空！");
            }
            if (StringUtils.isEmpty(importsVo.getYearLy())) {
                this.validateIsTrue(false, "年份不能为空！");
            }
            if (StringUtils.isEmpty(importsVo.getFeeBelongCode())) {
                this.validateIsTrue(false, "费用归口不能为空！");
            }
            if (StringUtils.isEmpty(importsVo.getBudgetItemCode())) {
                this.validateIsTrue(false, "预算项目编码不能为空！");
            }
            if (StringUtils.isEmpty(importsVo.getJanuaryNumStr())) {
                this.validateIsTrue(false, "一月预算金额不能为空！");
            }
            if (StringUtils.isEmpty(importsVo.getFebruaryNumStr())) {
                this.validateIsTrue(false, "二月预算金额不能为空！");
            }
            if (StringUtils.isEmpty(importsVo.getMarchNumStr())) {
                this.validateIsTrue(false, "三月预算金额不能为空！");
            }
            if (StringUtils.isEmpty(importsVo.getAprilNumStr())) {
                this.validateIsTrue(false, "四月预算金额不能为空！");
            }
            if (StringUtils.isEmpty(importsVo.getMayNumStr())) {
                this.validateIsTrue(false, "五月预算金额不能为空！");
            }
            if (StringUtils.isEmpty(importsVo.getJuneNumStr())) {
                this.validateIsTrue(false, "六月预算金额不能为空！");
            }
            if (StringUtils.isEmpty(importsVo.getJulyNumStr())) {
                this.validateIsTrue(false, "七月预算金额不能为空！");
            }
            if (StringUtils.isEmpty(importsVo.getAugustNumStr())) {
                this.validateIsTrue(false, "八月预算金额不能为空！");
            }
            if (StringUtils.isEmpty(importsVo.getSeptemberNumStr())) {
                this.validateIsTrue(false, "九月预算金额不能为空！");
            }
            if (StringUtils.isEmpty(importsVo.getOctoberNumStr())) {
                this.validateIsTrue(false, "十月预算金额不能为空！");
            }
            if (StringUtils.isEmpty(importsVo.getNovemberNumStr())) {
                this.validateIsTrue(false, "十一月预算金额不能为空！");
            }
            if (StringUtils.isEmpty(importsVo.getDecemberNumStr())) {
                this.validateIsTrue(false, "十二月预算金额不能为空！");
            }
            String errInfo = this.validateGetErrorInfo();
            if (errInfo != null) {
                errMap.put(rowNum, errInfo);
            }
        }
        return errMap;
    }

    /**
     * 校验并转换数据
     *
     * @param yearBudgetImportsVos
     * @return java.util.List<com.biz.crm.tpm.business.year.budget.sdk.dto.YearBudgetDto>
     * @author huojia
     * @date 2022/10/28 14:40
     **/
    public List<YearBudgetDto> testClass(List<YearBudgetVerticalImportsVo> yearBudgetImportsVos) {
        List<YearBudgetDto> yearBudgetDtoList = new ArrayList<>();

        // 构建基础数据map
        // this.buildBaseMap(yearBudgetImportsVos);

        // 分组前先校验编码
        /*yearBudgetImportsVos.forEach(YearBudgetVerticalImportsVo -> {
            Validate.notEmpty(YearBudgetVerticalImportsVo.getYearBudgetCode(), "年度预算编码不能为空！");
            if (yearBudgetVoMap.containsKey(YearBudgetVerticalImportsVo.getYearBudgetCode())) {
                throw new IllegalArgumentException("年度预算" + YearBudgetVerticalImportsVo.getYearBudgetCode() + "编码已存在，请检查！");
            }
        });*/

        // 通过反射，获取对象中的值
        Class<YearBudgetVerticalImportsVo> clazz = YearBudgetVerticalImportsVo.class;
        Map<String, List<DimensionDimensionInformationVo>> dimensionMap = new HashMap<>(8);
        // 分组校验
        Map<String, List<YearBudgetVerticalImportsVo>> yearBudgetMap = yearBudgetImportsVos.stream().collect(Collectors.groupingBy(YearBudgetVerticalImportsVo::getYearBudgetCode));
        yearBudgetImportsVos.forEach(importsVo -> {

            // 校验基础数据
            // this.buildBaseData(importsVo);

            // 构建行明细
            // List<YearBudgetDataDto> yearBudgetDataDtoList = this.buildDetailData(importsVo);

            // 组装明细
            YearBudgetDto yearBudgetDto = this.nebulaToolkitService.copyObjectByWhiteList(importsVo, YearBudgetDto.class, LinkedHashSet.class, ArrayList.class);
            // yearBudgetDto.setDataVos(yearBudgetDataDtoList);
            yearBudgetDtoList.add(yearBudgetDto);
        });
        return yearBudgetDtoList;
    }

    /**
     * 校验并转换数据
     *
     * @param data
     * @return java.util.List<com.biz.crm.tpm.business.year.budget.sdk.dto.YearBudgetDto>
     * @author huojia
     * @date 2022/10/28 14:40
     **/
    private List<YearBudgetDto> validate(LinkedHashMap<Integer, YearBudgetVerticalImportsVo> data, Map<Integer, String> errMap) {

        Map<String, String> mdmBusinessFormatMap = new HashMap<>();
        Map<String, String> mdmBusinessUnitMap = new HashMap<>();
        Map<String, String> tpmGroupCodeMap = new HashMap<>();
        Map<String, String> tpmFeeBelongMap = new HashMap<>();
        Map<String, String> tpmFeeBelongVerticalMap = new HashMap<>();
        Map<String, String> tpmFeeSourceMap = new HashMap<>();
        Map<String, Integer> dataTypeMap = new HashMap<>();
        Map<String, OrgVo> orgVoMap = new HashMap<>();
        Map<String, YearBudgetVo> yearBudgetVoMap = new HashMap<>();
        Map<String, BudgetItemVo> budgetItemVoMap = new HashMap<>();
        Map<String, CustomerVo> customerVoMap = new HashMap<>();
        Map<String, TerminalVo> terminalVoMap = new HashMap<>();
        Map<String, ProductVo> productVoMap = new HashMap<>();
        Map<String, SalesOrgVo> salesOrgVoMap = new HashMap<>();
        Map<String, CustomerChannelVo> customerChannelVoMap = new HashMap<>();
        Map<String, MdmTerminalChannelVo> terminalChannelVoMap = new HashMap<>();
        Map<String, ProductBrandVo> productBrandVoMap = new HashMap<>();
        Map<String, ProductLevelVo> productCategoryVoMap = new HashMap<>();
        Map<String, ProductLevelVo> productItemVoMap = new HashMap<>();

        List<YearBudgetVerticalImportsVo> yearBudgetImportsVos = Lists.newArrayList(data.values());
        List<YearBudgetDto> yearBudgetDtoList = new ArrayList<>();

        // 构建基础数据map
        this.buildBaseMap(yearBudgetImportsVos, mdmBusinessFormatMap,
                mdmBusinessUnitMap, tpmGroupCodeMap, tpmFeeBelongMap,
                tpmFeeBelongVerticalMap, tpmFeeSourceMap, dataTypeMap,
                budgetItemVoMap, customerVoMap, terminalVoMap,
                productBrandVoMap, productCategoryVoMap, productItemVoMap, productVoMap);

        // 分组校验
        data.forEach((k, importsVo) -> {

            // 校验基础数据
            this.buildBaseData(importsVo, mdmBusinessFormatMap,
                    mdmBusinessUnitMap, tpmGroupCodeMap, tpmFeeBelongMap,
                    tpmFeeBelongVerticalMap, tpmFeeSourceMap, dataTypeMap,
                    budgetItemVoMap, customerVoMap, terminalVoMap,
                    productBrandVoMap, productCategoryVoMap, productItemVoMap, productVoMap);

            // 构建行明细
            List<YearBudgetDataDto> yearBudgetDataDtoList = this.buildDetailData(importsVo, dataTypeMap);

            // 组装明细
            YearBudgetDto yearBudgetDto = this.nebulaToolkitService.copyObjectByWhiteList(importsVo, YearBudgetDto.class, LinkedHashSet.class, ArrayList.class);
            yearBudgetDto.setDataVos(yearBudgetDataDtoList);
            yearBudgetDtoList.add(yearBudgetDto);

            String errInfo = this.validateGetErrorInfo();
            if (errInfo != null) {
                errMap.put(k, errInfo);
            }
        });
        return yearBudgetDtoList;
    }

    /**
     * 校验基础数据
     *
     * @param importsVo
     * @author huojia
     * @date 2022/11/10 20:42
     **/
    private void buildBaseData(YearBudgetVerticalImportsVo importsVo,
                               Map<String, String> mdmBusinessFormatMap,
                               Map<String, String> mdmBusinessUnitMap,
                               Map<String, String> tpmGroupCodeMap,
                               Map<String, String> tpmFeeBelongMap,
                               Map<String, String> tpmFeeBelongVerticalMap,
                               Map<String, String> tpmFeeSourceMap,
                               Map<String, Integer> dataTypeMap,
                               Map<String, BudgetItemVo> budgetItemVoMap,
                               Map<String, CustomerVo> customerVoMap,
                               Map<String, TerminalVo> terminalVoMap,
                               Map<String, ProductBrandVo> productBrandVoMap,
                               Map<String, ProductLevelVo> productCategoryVoMap,
                               Map<String, ProductLevelVo> productItemVoMap,
                               Map<String, ProductVo> productVoMap) {
        // 业态
        if (!StringUtils.isEmpty(importsVo.getBusinessFormatCode())) {
            if (!mdmBusinessFormatMap.containsKey(importsVo.getBusinessFormatCode())) {
                this.validateIsTrue(false, "业态" + importsVo.getBusinessFormatCode() + "错误，请检查！");
            } else {
                importsVo.setBusinessFormatCode(mdmBusinessFormatMap.get(importsVo.getBusinessFormatCode()));
            }
        }
        // 业务单元
        if (!StringUtils.isEmpty(importsVo.getBusinessUnitCode())) {
            if (!mdmBusinessUnitMap.containsKey(importsVo.getBusinessUnitCode())) {
                this.validateIsTrue(false, "业务单元" + importsVo.getBusinessUnitCode() + "错误，请检查！");
            } else {
                String businessUnitCode = mdmBusinessUnitMap.get(importsVo.getBusinessUnitCode());
                if(!BusinessUnitEnum.VERTICAL.getCode().equals(businessUnitCode)){
                    this.validateIsTrue(false, "只能导入垂直");
                } else {
                    importsVo.setBusinessUnitCode(businessUnitCode);
                }
            }
        }
        // 年
        if (!StringUtils.isEmpty(importsVo.getYearLy())) {
            try {
                DateUtil.parseDate(importsVo.getYearLy(), "yyyy");
            } catch (Exception ignored) {
                this.validateIsTrue(false, "年份" + importsVo.getYearLy() + "格式错误，应该为" + "yyyy");
            }
        }
        // 归口
        if (!StringUtils.isEmpty(importsVo.getFeeBelongCode())) {
            if (BusinessUnitEnum.SON_COMPANY.getCode().equals(importsVo.getBusinessUnitCode())) {
                if (!tpmFeeSourceMap.containsKey(importsVo.getFeeBelongCode())) {
                    this.validateIsTrue(false, "分子公司归口" + importsVo.getFeeBelongCode() + "错误，请检查！");
                } else {
                    importsVo.setFeeBelongCode(tpmFeeSourceMap.get(importsVo.getFeeBelongCode()));
                }
            } else if (BusinessUnitEnum.VERTICAL.getCode().equals(importsVo.getBusinessUnitCode())) {
                if (!tpmFeeBelongVerticalMap.containsKey(importsVo.getFeeBelongCode())) {
                    this.validateIsTrue(false, "垂直归口" + importsVo.getFeeBelongCode() + "错误，请检查！");
                } else {
                    importsVo.setFeeBelongCode(tpmFeeBelongVerticalMap.get(importsVo.getFeeBelongCode()));
                }
            } else {
                if (!tpmFeeBelongMap.containsKey(importsVo.getFeeBelongCode())) {
                    this.validateIsTrue(false, "归口" + importsVo.getFeeBelongCode() + "错误，请检查！");
                } else {
                    importsVo.setFeeBelongCode(tpmFeeBelongMap.get(importsVo.getFeeBelongCode()));
                }
            }
        }
        // 校验预算项目
        if (!StringUtils.isEmpty(importsVo.getBudgetItemCode())) {
            if (budgetItemVoMap.containsKey(importsVo.getBudgetItemCode())) {
                importsVo.setBudgetItemName(budgetItemVoMap.get(importsVo.getBudgetItemCode()).getBudgetItemName());
                importsVo.setBudgetItemLevelCode(budgetItemVoMap.get(importsVo.getBudgetItemCode()).getBudgetItemLevelCode());
            } else {
                this.validateIsTrue(false, "预算项目编码" + importsVo.getBudgetItemCode() + "错误，请检查！");
            }
        }
        // 系统、零售商
        if (!StringUtils.isEmpty(importsVo.getSystemCode())) {

        }
        // 门店
        if (!StringUtils.isEmpty(importsVo.getTerminalCode())) {
            if (terminalVoMap.containsKey(importsVo.getTerminalCode())) {
                importsVo.setTerminalName(terminalVoMap.get(importsVo.getTerminalCode()).getTerminalName());
            } else {
                this.validateIsTrue(false, "门店编码" + importsVo.getTerminalCode() + "错误，请检查！");
            }
        }
        // 产品品牌
        if (!StringUtils.isEmpty(importsVo.getProductBrandCode())) {
            if (productBrandVoMap.containsKey(importsVo.getProductBrandCode())) {
                importsVo.setProductBrandName(productBrandVoMap.get(importsVo.getProductBrandCode()).getProductBrandName());
            } else {
                this.validateIsTrue(false, "产品品牌" + importsVo.getProductBrandCode() + "错误，请检查！");
            }
        }
        // 产品品类
        if (!StringUtils.isEmpty(importsVo.getProductCategoryCode())) {
            if (productCategoryVoMap.containsKey(importsVo.getProductCategoryCode())) {
                importsVo.setProductCategoryName(productCategoryVoMap.get(importsVo.getProductCategoryCode()).getProductLevelName());
            } else {
                this.validateIsTrue(false, "产品品类" + importsVo.getProductCategoryCode() + "错误，请检查！");
            }
        }
        // 产品品项
        if (!StringUtils.isEmpty(importsVo.getProductItemCode())) {
            if (productItemVoMap.containsKey(importsVo.getProductItemCode())) {
                importsVo.setProductItemName(productItemVoMap.get(importsVo.getProductItemCode()).getProductLevelName());
            } else {
                this.validateIsTrue(false, "产品品项" + importsVo.getProductCategoryCode() + "错误，请检查！");
            }
        }
        // 产品
        if (!StringUtils.isEmpty(importsVo.getProductCode())) {
            if (productVoMap.containsKey(importsVo.getProductCode())) {
                importsVo.setProductName(productVoMap.get(importsVo.getProductCode()).getProductName());
            } else {
                this.validateIsTrue(false, "产品编码" + importsVo.getProductCode() + "错误，请检查！");
            }
        }
    }

    /**
     * 构建行明细
     *
     * @param budgetData
     * @return java.util.List<com.biz.crm.tpm.business.year.budget.sdk.dto.YearBudgetDataDto>
     * @author huojia
     * @date 2022/11/10 20:39
     **/
    private List<YearBudgetDataDto> buildDetailData(YearBudgetVerticalImportsVo budgetData, Map<String, Integer> dataTypeMap) {
        List<YearBudgetDataDto> yearBudgetDataDtoList = new ArrayList<>();
        YearBudgetDataDto yearBudgetDataQuantityDto = new YearBudgetDataDto();
        yearBudgetDataQuantityDto.setDataType(YearBudgetDataTypeEnum.GOAL_QUANTITY.getCode());
        YearBudgetDataDto yearBudgetPointDataDto = new YearBudgetDataDto();
        yearBudgetPointDataDto.setDataType(YearBudgetDataTypeEnum.BUDGET_POINT.getCode());
        yearBudgetPointDataDto.setSortNum(dataTypeMap.get(yearBudgetPointDataDto.getDataType()));
        budgetData.setDataType(YearBudgetDataTypeEnum.BUDGET_AMOUNT.getCode());
        budgetData.setSortNum(dataTypeMap.get(budgetData.getDataType()));

        // 校验金额

        AtomicReference<BigDecimal> totalAmount = new AtomicReference<>(BigDecimal.ZERO);
        // 一月份
        try {
            if (!StringUtils.isEmpty(budgetData.getJanuaryNumStr())) {
                budgetData.setJanuaryNum(new BigDecimal(budgetData.getJanuaryNumStr()));
                totalAmount.set(totalAmount.get().add(budgetData.getJanuaryNum()));
            }
        } catch (Exception e) {
            this.validateIsTrue(false, "一月份预算金额" + budgetData.getJanuaryNumStr() + "格式错误，请检查！");
        }
        // 二月份
        try {
            if (!StringUtils.isEmpty(budgetData.getFebruaryNumStr())) {
                budgetData.setFebruaryNum(new BigDecimal(budgetData.getFebruaryNumStr()));
                totalAmount.set(totalAmount.get().add(budgetData.getFebruaryNum()));
            }
        } catch (Exception e) {
            this.validateIsTrue(false, "二月份预算金额" + budgetData.getFebruaryNumStr() + "格式错误，请检查！");
        }
        // 三月份
        try {
            if (!StringUtils.isEmpty(budgetData.getMarchNumStr())) {
                budgetData.setMarchNum(new BigDecimal(budgetData.getMarchNumStr()));
                totalAmount.set(totalAmount.get().add(budgetData.getMarchNum()));
            }
        } catch (Exception e) {
            this.validateIsTrue(false, "三月份预算金额" + budgetData.getMarchNumStr() + "格式错误，请检查！");
        }
        // 四月份
        try {
            if (!StringUtils.isEmpty(budgetData.getAprilNumStr())) {
                budgetData.setAprilNum(new BigDecimal(budgetData.getAprilNumStr()));
                totalAmount.set(totalAmount.get().add(budgetData.getAprilNum()));
            }
        } catch (Exception e) {
            this.validateIsTrue(false, "四月份预算金额" + budgetData.getAprilNumStr() + "格式错误，请检查！");
        }
        // 五月份
        try {
            if (!StringUtils.isEmpty(budgetData.getMayNumStr())) {
                budgetData.setMayNum(new BigDecimal(budgetData.getMayNumStr()));
                totalAmount.set(totalAmount.get().add(budgetData.getMayNum()));
            }
        } catch (Exception e) {
            this.validateIsTrue(false, "五月份预算金额" + budgetData.getMayNumStr() + "格式错误，请检查！");
        }
        // 六月份
        try {
            if (!StringUtils.isEmpty(budgetData.getJuneNumStr())) {
                budgetData.setJuneNum(new BigDecimal(budgetData.getJuneNumStr()));
                totalAmount.set(totalAmount.get().add(budgetData.getJuneNum()));
            }
        } catch (Exception e) {
            this.validateIsTrue(false, "六月份预算金额" + budgetData.getJuneNumStr() + "格式错误，请检查！");
        }
        // 七月份
        try {
            if (!StringUtils.isEmpty(budgetData.getJulyNumStr())) {
                budgetData.setJulyNum(new BigDecimal(budgetData.getJulyNumStr()));
                totalAmount.set(totalAmount.get().add(budgetData.getJulyNum()));
            }
        } catch (Exception e) {
            this.validateIsTrue(false, "七月份预算金额" + budgetData.getJulyNumStr() + "格式错误，请检查！");
        }
        // 八月份
        try {
            if (!StringUtils.isEmpty(budgetData.getAugustNumStr())) {
                budgetData.setAugustNum(new BigDecimal(budgetData.getAugustNumStr()));
                totalAmount.set(totalAmount.get().add(budgetData.getAugustNum()));
            }
        } catch (Exception e) {
            this.validateIsTrue(false, "八月份预算金额" + budgetData.getAugustNumStr() + "格式错误，请检查！");
        }
        // 九月份
        try {
            if (!StringUtils.isEmpty(budgetData.getSeptemberNumStr())) {
                budgetData.setSeptemberNum(new BigDecimal(budgetData.getSeptemberNumStr()));
                totalAmount.set(totalAmount.get().add(budgetData.getSeptemberNum()));
            }
        } catch (Exception e) {
            this.validateIsTrue(false, "九月份预算金额" + budgetData.getSeptemberNumStr() + "格式错误，请检查！");
        }
        // 十月份
        try {
            if (!StringUtils.isEmpty(budgetData.getOctoberNumStr())) {
                budgetData.setOctoberNum(new BigDecimal(budgetData.getOctoberNumStr()));
                totalAmount.set(totalAmount.get().add(budgetData.getOctoberNum()));
            }
        } catch (Exception e) {
            this.validateIsTrue(false, "十月份预算金额" + budgetData.getOctoberNumStr() + "格式错误，请检查！");
        }
        // 十一月份
        try {
            if (!StringUtils.isEmpty(budgetData.getNovemberNumStr())) {
                budgetData.setNovemberNum(new BigDecimal(budgetData.getNovemberNumStr()));
                totalAmount.set(totalAmount.get().add(budgetData.getNovemberNum()));
            }
        } catch (Exception e) {
            this.validateIsTrue(false, "十一月份预算金额" + budgetData.getNovemberNumStr() + "格式错误，请检查！");
        }
        // 十二月份
        try {
            if (!StringUtils.isEmpty(budgetData.getDecemberNumStr())) {
                budgetData.setDecemberNum(new BigDecimal(budgetData.getDecemberNumStr()));
                totalAmount.set(totalAmount.get().add(budgetData.getDecemberNum()));
            }
        } catch (Exception e) {
            this.validateIsTrue(false, "十二月份预算金额" + budgetData.getDecemberNumStr() + "格式错误，请检查！");
        }
        budgetData.setBudgetTotalAmount(totalAmount.get());
        YearBudgetDataDto yearBudgetDataDto = this.nebulaToolkitService.copyObjectByWhiteList(budgetData, YearBudgetDataDto.class, LinkedHashSet.class, ArrayList.class);
        yearBudgetDataDtoList.add(yearBudgetDataQuantityDto);
        yearBudgetDataDtoList.add(yearBudgetDataDto);
        yearBudgetDataDtoList.add(yearBudgetPointDataDto);
        return yearBudgetDataDtoList;
    }

    /**
     * 构建基础数据map
     *
     * @param yearBudgetImportsVos
     * @author huojia
     * @date 2022/11/10 20:31
     **/
    private void buildBaseMap(List<YearBudgetVerticalImportsVo> yearBudgetImportsVos,
                              Map<String, String> mdmBusinessFormatMap,
                              Map<String, String> mdmBusinessUnitMap,
                              Map<String, String> tpmGroupCodeMap,
                              Map<String, String> tpmFeeBelongMap,
                              Map<String, String> tpmFeeBelongVerticalMap,
                              Map<String, String> tpmFeeSourceMap,
                              Map<String, Integer> dataTypeMap,
                              Map<String, BudgetItemVo> budgetItemVoMap,
                              Map<String, CustomerVo> customerVoMap,
                              Map<String, TerminalVo> terminalVoMap,
                              Map<String, ProductBrandVo> productBrandVoMap,
                              Map<String, ProductLevelVo> productCategoryVoMap,
                              Map<String, ProductLevelVo> productItemVoMap,
                              Map<String, ProductVo> productVoMap) {
        // 查询数据字典
        mdmBusinessFormatMap.putAll(dictToolkitService.findConvertMapByDictTypeCode(DictTypeCodeConstant.MDM_BUSINESS_FORMAT));
        mdmBusinessUnitMap.putAll(dictToolkitService.findConvertMapByDictTypeCode(DictTypeCodeConstant.MDM_BUSINESS_UNIT));
        tpmGroupCodeMap.putAll(dictToolkitService.findConvertMapByDictTypeCode(DictTypeCodeConstant.TPM_GROUP_CODE));
        tpmFeeBelongMap.putAll(dictToolkitService.findConvertMapByDictTypeCode(DictTypeCodeConstant.TPM_FEE_BELONG_US));
        tpmFeeBelongVerticalMap.putAll(dictToolkitService.findConvertMapByDictTypeCode(DictTypeCodeConstant.TPM_FEE_BELONG_VERTICAL));
        tpmFeeSourceMap.putAll(dictToolkitService.findConvertMapByDictTypeCode(DictTypeCodeConstant.TPM_FEE_SOURCE));

        // 枚举类型map
        dataTypeMap.putAll(YearBudgetDataTypeEnum.concertEnumToMap());
        // 查询主数据数据，校验
        Set<String> yearBudgetSet = yearBudgetImportsVos.stream().map(YearBudgetVerticalImportsVo::getYearBudgetCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> budgetItemSet = yearBudgetImportsVos.stream().map(YearBudgetVerticalImportsVo::getBudgetItemCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> systemCodeSet = yearBudgetImportsVos.stream().map(YearBudgetVerticalImportsVo::getSystemCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> terminalCodeSet = yearBudgetImportsVos.stream().map(YearBudgetVerticalImportsVo::getTerminalCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> productBrandCodeSet = yearBudgetImportsVos.stream().map(YearBudgetVerticalImportsVo::getProductBrandCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> productCategoryCodeSet = yearBudgetImportsVos.stream().map(YearBudgetVerticalImportsVo::getProductCategoryCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> productItemCodeSet = yearBudgetImportsVos.stream().map(YearBudgetVerticalImportsVo::getProductItemCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> productCodeSet = yearBudgetImportsVos.stream().map(YearBudgetVerticalImportsVo::getProductCode).filter(Objects::nonNull).collect(Collectors.toSet());

        // 预算项目
        if (!CollectionUtils.isEmpty(budgetItemSet)) {
            List<BudgetItemVo> budgetItemVoList = budgetItemService.listByCodes(new ArrayList<>(budgetItemSet));
            if (!CollectionUtils.isEmpty(budgetItemVoList)) {
                budgetItemVoMap.putAll(budgetItemVoList.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, Function.identity())));
            }
        }

        // 终端
        if (!CollectionUtils.isEmpty(terminalCodeSet)) {
            List<TerminalVo> terminalVos = terminalVoService.findDetailsByIdsOrTerminalCodes(null, new ArrayList<>(terminalCodeSet));
            if (!CollectionUtils.isEmpty(terminalVos)) {
                terminalVoMap.putAll(terminalVos.stream().collect(Collectors.toMap(TerminalVo::getTerminalCode, Function.identity())));
            }
        }

        // 品牌
        if (!CollectionUtils.isEmpty(productBrandCodeSet)) {
            List<ProductBrandVo> productBrandVos = productBrandService.listByCodes(new ArrayList<>(productBrandCodeSet));
            if (!CollectionUtils.isEmpty(productBrandVos)) {
                productBrandVoMap.putAll(productBrandVos.stream().collect(Collectors.toMap(ProductBrandVo::getProductBrandCode, Function.identity())));
            }
        }

        // 品类
        if (!CollectionUtils.isEmpty(productCategoryCodeSet)) {
            List<ProductLevelVo> productLevelVos = productLevelVoSdkService.findListByCodes(new ArrayList<>(productCategoryCodeSet));
            if (!CollectionUtils.isEmpty(productLevelVos)) {
                productCategoryVoMap.putAll(productLevelVos.stream().collect(Collectors.toMap(ProductLevelVo::getProductLevelCode, Function.identity())));
            }
        }

        // 品项
        if (!CollectionUtils.isEmpty(productItemCodeSet)) {
            List<ProductLevelVo> productLevelVos = productLevelVoSdkService.findListByCodes(new ArrayList<>(productItemCodeSet));
            if (!CollectionUtils.isEmpty(productLevelVos)) {
                productItemVoMap.putAll(productLevelVos.stream().collect(Collectors.toMap(ProductLevelVo::getProductLevelCode, Function.identity())));
            }
        }

        // 产品
        if (!CollectionUtils.isEmpty(productCodeSet)) {
            List<ProductVo> productVoList = productVoService.findByCodes(new ArrayList<>(productCodeSet));
            if (!CollectionUtils.isEmpty(productVoList)) {
                productVoMap.putAll(productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity())));
            }
        }
    }

    /**
     * 获取字典对应的value值
     *
     * @param dictValue
     * @param typeCode
     * @return
     */
    private String findDictValue(String dictValue, String typeCode) {
        DictDataVo dictDataVo = this.dictMap.get(typeCode).stream()
            .filter(a -> a.getDictValue().equals(dictValue)).findFirst().orElse(null);
        if (!ObjectUtils.isEmpty(dictDataVo)) {
            return dictDataVo.getDictCode();
        }
        return null;
    }

    /**
     * 唯一校验
     * @param vo
     */
    private void verifyUniqueness(YearBudgetDto vo) {
        /**
         * * 业态	* 业务单元	* 年份	* 预算项目编码	预算项目名称	* 费用归口	* 零售商编码	零售商名称
         * * 区域编码	区域名称	门店编码	门店名称	品牌编码	品牌名称	品类编码	品类名称	品项编码	品项名称	产品编码	产品名称	* 费用金额
         */
        //根据必填项查询出已有的年度预算
        YearBudgetDto dto = new YearBudgetDto();
        dto.setBusinessFormatCode(vo.getBusinessFormatCode());
        dto.setBusinessUnitCode(vo.getBusinessUnitCode());
        dto.setYearLy(vo.getYearLy());
        dto.setBudgetItemCode(vo.getBudgetItemCode());
        dto.setFeeBelongCode(vo.getFeeBelongCode());
        dto.setSystemCode(vo.getSystemCode());
        List<YearBudgetVo> yearBudgetVos = this.yearBudgetService.findListByConditions(dto);
        if(CollectionUtils.isEmpty(yearBudgetVos)){
            return;
        }
        //唯一key
        String uniqKey = this.buildKey(vo.getRegionCode(),vo.getTerminalCode()
            ,vo.getProductBrandCode(),vo.getProductCategoryCode(),vo.getProductItemCode(),vo.getProductCode());
        //分组
        Map<String, YearBudgetVo> yearBudgetVoMap = yearBudgetVos.stream()
            .collect(Collectors.toMap(o -> this.buildKey(o.getRegionCode(),
                o.getTerminalCode(), o.getProductBrandCode(), o.getProductCategoryCode(),
                o.getProductItemCode(), o.getProductCode()), Function.identity()));
        YearBudgetVo yearBudgetVo = yearBudgetVoMap.get(uniqKey);
        Assert.isNull(yearBudgetVo, "已经存在相同年度度预算");
    }

    /**
     * 唯一key
     * @param regionCode
     * @param terminalCode
     * @param productBrandCode
     * @param productCategoryCode
     * @param productItemCode
     * @param productCode
     * @return {@link String}
     */
    private String buildKey(String regionCode, String terminalCode, String productBrandCode
        , String productCategoryCode, String productItemCode, String productCode) {
        StringBuilder sb = new StringBuilder(this.handleStr(regionCode));
        sb.append(this.handleStr(terminalCode));
        sb.append(this.handleStr(productBrandCode));
        sb.append(this.handleStr(productCategoryCode));
        sb.append(this.handleStr(productItemCode));
        sb.append(this.handleStr(productCode));
        return sb.toString();
    }

    private String handleStr(String regionCode) {
        return org.springframework.util.StringUtils.hasText(regionCode) ? regionCode : "0";
    }


    @Override
    public Class<YearBudgetVerticalImportsVo> findCrmExcelVoClass() {
        return YearBudgetVerticalImportsVo.class;
    }

    @Override
    public String getTemplateCode() {
        return "TPM_YEAR_BUDGET_VERTICAL_IMPORT";
    }

    @Override
    public String getTemplateName() {
        return "TPM-年度预算垂直导入";
    }

    @Override
    public String getBusinessCode() {
        return "TPM_YEAR_BUDGET_IMPORT";
    }

    @Override
    public String getBusinessName() {
        return "TPM-年度预算导入";
    }
}
