package com.biz.crm.tpm.business.year.budget.sdk.dto;

import lombok.Data;

import java.math.BigDecimal;

/**
 * 年度预算操作dto
 * @author wanghaojia
 * @date 2023/11/29 19:47
 */
@Data
public class OperateYearBudgetDto {

    /**
     * 行（给数据加上索引）
     */
    private Integer indexNo;

    /**
     * 月度预算编码
     */
    private String yearBudgetCode;

    /**
     * 操作金额
     */
    private BigDecimal operationAmount;

    /**
     * 操作类型   BudgetOperationTypeEnum
     */
    private String operationType;

    /**
     * 是否执行保存方法，默认为true
     */
    private Boolean doSave = true;

    /**
     * 是否抛异常，默认为true
     */
    private Boolean throwException = true;

    /**
     * 差额
     */
    private BigDecimal gapAmount;

    /**
     * 业务编码
     */
    private String businessCode;

    private String businessUnitCode;

}
