package com.biz.crm.tpm.business.year.budget.sdk.eunm;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author huojia
 * @date 2022年10月26日 17:39
 */
@Getter
@AllArgsConstructor
public enum YearBudgetDataTypeEnum {

    GOAL_QUANTITY("goal_quantity", "目标量", "Y", 4),

    BUDGET_POINT("budget_point", "预算点数", "Y", 3),

    BUDGET_AMOUNT("budget_amount", "预算金额", "Y", 1);

    private String code;

    private String value;

    private String editFlag;

    private Integer sortNum;

    /**
     * 转换为对应map
     *
     * @return java.util.Map<java.lang.String, java.lang.Integer>
     * @author huojia
     * @date 2022/10/26 20:17
     **/
    public static Map<String, Integer> concertEnumToMap() {
        Map<String, Integer> map = new HashMap<>();
        for (YearBudgetDataTypeEnum t : YearBudgetDataTypeEnum.values()) {
            map.put(t.getCode(), t.getSortNum());
        }
        return map;
    }

    /**
     * 查看年度预算时展示
     *
     * @return java.util.Map<java.lang.String, java.lang.Integer>
     * @author huojia
     * @date 2022/10/26 20:17
     **/
    public static List<String> concertEnumToEditList() {
        List<String> list = new ArrayList<>();
        for (YearBudgetDataTypeEnum t : YearBudgetDataTypeEnum.values()) {
            if (BooleanEnum.TRUE.getCapital().equals(t.getEditFlag())) {
                list.add(t.getCode());
            }
        }
        return list;
    }

    /**
     * 转换为对应list
     *
     * @return java.util.Map<java.lang.String, java.lang.Integer>
     * @author huojia
     * @date 2022/10/26 20:17
     **/
    public static List<String> concertEnumToList() {
        List<String> list = new ArrayList<>();
        for (YearBudgetDataTypeEnum t : YearBudgetDataTypeEnum.values()) {
            list.add(t.getCode());
        }
        return list;
    }
}
