package com.biz.crm.tpm.business.year.budget.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.tpm.business.year.budget.sdk.dto.OperateYearBudgetDto;
import com.biz.crm.tpm.business.year.budget.sdk.dto.YearBudgetDto;
import com.biz.crm.tpm.business.year.budget.sdk.dto.YearBudgetToralPointDto;
import com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetReportVo;
import com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetVo;
import org.springframework.data.domain.Pageable;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * @author: chenlong
 * @date: 2023/3/23 16:36
 * @description:
 */
public interface YearBudgetSdkService {
    /**
     * 分页查询年度预算
     *
     * @param pageable
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetVo>
     * @author huojia
     * @date 2022/11/1 21:14
     **/
    Page<YearBudgetVo> findByConditions(Pageable pageable, YearBudgetDto dto);

    /**
     * 费用归口下拉框
     *
     * @param businessFormatCode 业态
     * @param businessUnitCode 业务单元
     * @return 所有数据
     */
    List<CommonSelectVo> findBelongSelect(String businessFormatCode, String businessUnitCode);

    List<YearBudgetReportVo> findYearBudgetSumVo(YearBudgetDto queryDto);


    /**
     * 根据主键查询数据
     *
     * @param id
     * @param editFlag
     * @return com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetVo
     * @author huojia
     * @date 2022/10/26 17:01
     **/
    YearBudgetVo findById(String id, String editFlag);

    /**
     * 新增
     *
     * @param dto
     * @return com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetVo
     * @author huojia
     * @date 2022/10/26 17:01
     **/
    YearBudgetDto create(YearBudgetDto dto);

    /**
     * 编辑
     *
     * @param dto
     * @return com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetVo
     * @author huojia
     * @date 2022/10/26 17:01
     **/
    YearBudgetVo update(YearBudgetDto dto);

    List<String> generateMonthBudgetForOut(String id);

    BigDecimal sumBudgetTotalPoint(YearBudgetToralPointDto dto);

    List<YearBudgetVo> getYearBudgetTotalPointGroupBySalesOrg(YearBudgetToralPointDto dto);

    /**
     * 根据预算项目编码查询
     * @param yearBudgetCodes
     * @return
     */
    List<YearBudgetVo> findYearBudgetByYearBudgetCodes(List<String> yearBudgetCodes);

    default Page<YearBudgetVo> findPageForOut(Pageable pageable, YearBudgetDto dto){
        return null;
    };
    /**
     * 根据年度预算编码集合查询
     * @param yearBudgetCodes
     * @return
     */
    List<YearBudgetVo> findByYearBudgetCodes(List<String> yearBudgetCodes);

    /**
     * 营销费用使用进度-跑帆软
     * @param yearBudgetDtos
     * @return
     */
    List<YearBudgetVo> findListForFR(List<YearBudgetDto> yearBudgetDtos);

    /**
     * 本模块使用
     * <p>
     * 批量操作月度预算的策略占用金额
     **/
    void operateBudgetStrategy(List<OperateYearBudgetDto> operateList);

}
