package com.biz.crm.tpm.business.year.budget.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author huojia
 * @date 2022年10月26日 17:04
 */
@Data
@ApiModel(value = "YearBudgetDataVo", description = "TPM-年度预算")
public class YearBudgetDataVo extends TenantFlagOpVo {

    /**
     * 年度预算编码（关联）
     */
    @ApiModelProperty(value = "年度预算编码（关联）", notes = "")
    private String yearBudgetCode;

    /**
     * 数据类型（区分行）[数据类型:tpm_line_data_type]
     */
    @ApiModelProperty(value = "数据类型（区分行）[数据类型:tpm_line_data_type]", notes = "")
    private String dataType;

    /**
     * 数据排序
     */
    @ApiModelProperty(value = "数据排序", notes = "")
    private Integer sortNum;

    /**
     * 一月份
     */
    @ApiModelProperty("一月份")
    private BigDecimal januaryNum;

    /**
     * 二月份
     */
    @ApiModelProperty("二月份")
    private BigDecimal februaryNum;

    /**
     * 三月份
     */
    @ApiModelProperty("三月份")
    private BigDecimal marchNum;

    /**
     * 四月份
     */
    @ApiModelProperty("四月份")
    private BigDecimal aprilNum;

    /**
     * 五月份
     */
    @ApiModelProperty("五月份")
    private BigDecimal mayNum;

    /**
     * 六月份
     */
    @ApiModelProperty("六月份")
    private BigDecimal juneNum;

    /**
     * 七月份
     */
    @ApiModelProperty("七月份")
    private BigDecimal julyNum;

    /**
     * 八月份
     */
    @ApiModelProperty("八月份")
    private BigDecimal augustNum;

    /**
     * 九月份
     */
    @ApiModelProperty("九月份")
    private BigDecimal septemberNum;

    /**
     * 十月份
     */
    @ApiModelProperty("十月份")
    private BigDecimal octoberNum;

    /**
     * 十一月份
     */
    @ApiModelProperty("十一月份")
    private BigDecimal novemberNum;

    /**
     * 十二月份
     */
    @ApiModelProperty("十二月份")
    private BigDecimal decemberNum;

}
