package com.biz.crm.tpm.business.year.budget.sdk.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @author huojia
 * @date 2022年10月28日 11:42
 */
@Data
@CrmExcelImport
@EqualsAndHashCode(callSuper = true)
public class YearBudgetOnLineImportsVo extends CrmExcelVo {

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @CrmExcelColumn(value = "业态")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @CrmExcelColumn(value = "业务单元")
    private String businessUnitCode;

    /**
     * 年份
     */
    @CrmExcelColumn(value = "年份")
    private String yearLy;

    /**
     * 部门编码
     */
    @CrmExcelColumn(value = "部门编码")
    private String orgCode;

    /**
     * 部门名称
     */
    @CrmExcelColumn(value = "部门名称")
    private String orgName;

    /**
     * 分组[数据字典:tpm_group_code]
     */
    @CrmExcelColumn(value = "分组")
    private String groupCode;

    /**
     * 预算项目编码
     */
    @CrmExcelColumn(value = "预算项目编码")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @CrmExcelColumn(value = "预算项目名称")
    private String budgetItemName;

    /**
     * 费用归口[数据字典:tpm_fee_belong]
     */
    @CrmExcelColumn(value = "费用归口")
    private String feeBelongCode;

    /**
     * 销售组织编码
     */
    @CrmExcelColumn(value = "销售组织编码")
    private String salesOrgCode;

    /**
     * 销售组织名称
     */
    @CrmExcelColumn(value = "销售组织名称")
    private String salesOrgName;

//    /**
//     * 门店渠道编码
//     */
//    @CrmExcelColumn(value = "门店渠道编码")
//    private String terminalChannelCode;
//
//    /**
//     * 门店渠道名称
//     */
//    @CrmExcelColumn(value = "门店渠道名称")
//    private String terminalChannelName;
//
//    /**
//     * 客户渠道编码
//     */
//    @CrmExcelColumn(value = "客户渠道编码")
//    private String customerChannelCode;
//
//    /**
//     * 客户渠道名称
//     */
//    @CrmExcelColumn(value = "客户渠道名称")
//    private String customerChannelName;

    /**
     * 客户编码
     */
    @CrmExcelColumn(value = "客户编码")
    private String customerCode;

    /**
     * 客户名称
     */
    @CrmExcelColumn(value = "客户名称")
    private String customerName;

//    /**
//     * 门店编码
//     */
//    @CrmExcelColumn(value = "门店编码")
//    private String terminalCode;
//
//    /**
//     * 门店名称
//     */
//    @CrmExcelColumn(value = "门店名称")
//    private String terminalName;

    /**
     * 品牌编码
     */
    @CrmExcelColumn(value = "品牌编码")
    private String productBrandCode;

    /**
     * 品牌名称
     */
    @CrmExcelColumn(value = "品牌名称")
    private String productBrandName;

    /**
     * 品类编码
     */
    @CrmExcelColumn(value = "品类编码")
    private String productCategoryCode;

    /**
     * 品类名称
     */
    @CrmExcelColumn(value = "品类名称")
    private String productCategoryName;

    /**
     * 品项编码
     */
    @CrmExcelColumn(value = "品项编码")
    private String productItemCode;

    /**
     * 品项名称
     */
    @CrmExcelColumn(value = "品项名称")
    private String productItemName;

    /**
     * 产品编码
     */
    @CrmExcelColumn(value = "产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @CrmExcelColumn(value = "产品名称")
    private String productName;

    /**
     * 年度力度
     */
    @CrmExcelColumn(value = "年度力度")
    private String budgetIntensity;

    /**
     * 预算总点数
     */
    @CrmExcelColumn(value = "预算总点数")
    private String budgetTotalPointStr;

    /**
     * 预算总金额
     */
    @CrmExcelColumn(value = "预算总金额")
    private String budgetTotalAmountStr;

    /**
     * 总目标量
     */
    @CrmExcelColumn(value = "总目标量")
    private String totalGoalQuantityStr;

    /**
     * 一月预算金额
     */
    @CrmExcelColumn(value = "一月预算金额")
    private String januaryNumStr;

    /**
     * *1月销售目标（元）
     */
    @CrmExcelColumn(value = "*1月销售目标（元)")
    private String januaryQuantityStr;


    /**
     * 二月预算金额
     */
    @CrmExcelColumn(value = "二月预算金额")
    private String februaryNumStr;

    /**
     * *2月销售目标（元）
     */
    @CrmExcelColumn(value = "*2月销售目标（元)")
    private String februaryQuantityStr;


    /**
     * 三月预算金额
     */
    @CrmExcelColumn(value = "三月预算金额")
    private String marchNumStr;

    /**
     * *3月销售目标（元）
     */
    @CrmExcelColumn(value = "*3月销售目标（元)")
    private String marchQuantityStr;

    /**
     * 四月预算金额
     */
    @CrmExcelColumn(value = "四月预算金额")
    private String aprilNumStr;

    /**
     * *4月销售目标（元）
     */
    @CrmExcelColumn(value = "*4月销售目标（元)")
    private String aprilQuantityStr;

    /**
     * 五月预算金额
     */
    @CrmExcelColumn(value = "五月预算金额")
    private String mayNumStr;

    /**
     * *5月销售目标（元）
     */
    @CrmExcelColumn(value = "*5月销售目标（元)")
    private String mayQuantityStr;

    /**
     * 六月预算金额
     */
    @CrmExcelColumn(value = "六月预算金额")
    private String juneNumStr;

    /**
     * *6月销售目标（元）
     */
    @CrmExcelColumn(value = "*6月销售目标（元)")
    private String juneQuantityStr;

    /**
     * 七月预算金额
     */
    @CrmExcelColumn(value = "七月预算金额")
    private String julyNumStr;

    /**
     * *7月销售目标（元）
     */
    @CrmExcelColumn(value = "*7月销售目标（元)")
    private String julyQuantityStr;


    /**
     * 八月预算金额
     */
    @CrmExcelColumn(value = "八月预算金额")
    private String augustNumStr;

    /**
     * *8月销售目标（元）
     */
    @CrmExcelColumn(value = "*8月销售目标（元)")
    private String augustQuantityStr;


    /**
     * 九月预算金额
     */
    @CrmExcelColumn(value = "九月预算金额")
    private String septemberNumStr;

    /**
     * *9月销售目标（元）
     */
    @CrmExcelColumn(value = "*9月销售目标（元)")
    private String septemberQuantityStr;

    /**
     * 十月预算金额
     */
    @CrmExcelColumn(value = "十月预算金额")
    private String octoberNumStr;

    /**
     * *10月销售目标（元）
     */
    @CrmExcelColumn(value = "*10月销售目标（元)")
    private String octoberQuantityStr;

    /**
     * 十一月预算金额
     */
    @CrmExcelColumn(value = "十一月预算金额")
    private String novemberNumStr;

    /**
     * *11月销售目标（元）
     */
    @CrmExcelColumn(value = "*11月销售目标（元)")
    private String novemberQuantityStr;

    /**
     * 十二月预算金额
     */
    @CrmExcelColumn(value = "十二月预算金额")
    private String decemberNumStr;

    /**
     * *12月销售目标（元）
     */
    @CrmExcelColumn(value = "*12月销售目标（元)")
    private String decemberQuantityStr;

    /*数据库字段*/

    /**
     * 是否生成已月度预算[数据字典:yesOrNo]
     */
    @ExcelIgnore
    private String monthBudgetFlag;

    /**
     * 年度预算编码
     */
    @ExcelIgnore
    private String yearBudgetCode;

    /**
     * 数据类型（区分行）[数据字典:tpm_line_data_type]
     */
    @ExcelIgnore
    private String dataType;

    /**
     * 预算项目层级[数据字典:tpm_budget_item_level]
     */
    @ExcelIgnore
    private String budgetItemLevelCode;

    /**
     * 销售组织层级编码
     */
    @ExcelIgnore
    private String salesOrgLevelCode;

    /**
     * 门店渠道层级
     */
    @ExcelIgnore
    private String terminalChannelLevelCode;
    /**
     * 客户渠道层级
     */
    @ExcelIgnore
    private String customerChannelLevelCode;

    /**
     * 系统编码
     */
    @ExcelIgnore
    private String systemCode;

    /**
     * 系统名称
     */
    @ExcelIgnore
    private String systemName;

    /**
     * 部门层级
     */
    @ExcelIgnore
    private String orgLevelCode;

    /**
     * 数据排序
     */
    @ExcelIgnore
    private Integer sortNum;

    /**
     * 一月份
     */
    @ExcelIgnore
    private BigDecimal januaryNum;

    /**
     * 二月份
     */
    @ExcelIgnore
    private BigDecimal februaryNum;

    /**
     * 三月份
     */
    @ExcelIgnore
    private BigDecimal marchNum;

    /**
     * 四月份
     */
    @ExcelIgnore
    private BigDecimal aprilNum;

    /**
     * 五月份
     */
    @ExcelIgnore
    private BigDecimal mayNum;

    /**
     * 六月份
     */
    @ExcelIgnore
    private BigDecimal juneNum;

    /**
     * 七月份
     */
    @ExcelIgnore
    private BigDecimal julyNum;

    /**
     * 八月份
     */
    @ExcelIgnore
    private BigDecimal augustNum;

    /**
     * 九月份
     */
    @ExcelIgnore
    private BigDecimal septemberNum;

    /**
     * 十月份
     */
    @ExcelIgnore
    private BigDecimal octoberNum;

    /**
     * 十一月份
     */
    @ExcelIgnore
    private BigDecimal novemberNum;

    /**
     * 十二月份
     */
    @ExcelIgnore
    private BigDecimal decemberNum;

    /**
     * 预算总点数
     */
    @ExcelIgnore
    private BigDecimal budgetTotalPoint;

    /**
     * 预算总金额
     */
    @ExcelIgnore
    private BigDecimal budgetTotalAmount;

    /**
     * 总目标量
     */
    @ExcelIgnore
    private BigDecimal totalGoalQuantity;

    /**
     * 策略关联金额
     */
    @ExcelIgnore
    private BigDecimal strategyAmount;

    /**
     * 剩余可关联金额
     */
    @ExcelIgnore
    private BigDecimal remainderAmount;

    /**
     * 年度力度-分子
     */
    @ExcelIgnore
    private BigDecimal budgetIntensityNumerator;
    /**
     * 年度力度-分母
     */
    @ExcelIgnore
    private BigDecimal budgetIntensityDenominator;

}
