package com.biz.crm.tpm.business.year.budget.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author huojia
 * @date 2022年10月26日 16:19
 */
@Data
@ApiModel(value = "YearBudgetVo", description = "TPM-年度预算")
public class YearBudgetReportVo extends TenantFlagOpVo {

    /**
     * 年份
     */
    @ApiModelProperty(value = "年份", notes = "")
    private String yearLy;

    /**
     * 预算项目编码
     */
    @ApiModelProperty(value = "预算项目编码", notes = "")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称", notes = "")
    private String budgetItemName;

    /**
     * 总目标量
     */
    @ApiModelProperty(value = "总目标量", notes = "")
    private BigDecimal totalGoalQuantity;

    /**
     * 预算总金额
     */
    @ApiModelProperty(value = "预算总金额", notes = "")
    private BigDecimal budgetTotalAmount;

    /**
     * 已使用金额
     */
    @ApiModelProperty(value = "已使用金额", notes = "")
    private BigDecimal usedAmount;

    /**
     * 系统编码
     */
    @ApiModelProperty(value = "系统编码", notes = "")
    private String systemCode;

    /**
     * 系统名称
     */
    @ApiModelProperty(value = "系统名称", notes = "")
    private String systemName;

    /**
     * 区域编码
     */
    @ApiModelProperty(value = "区域编码", notes = "")
    private String regionCode;

    /**
     * 区域名称
     */
    @ApiModelProperty(value = "区域名称", notes = "")
    private String regionName;

}
