package com.biz.crm.tpm.business.year.budget.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author huojia
 * @date 2022年10月26日 16:19
 */
@Data
@ApiModel(value = "YearBudgetVo", description = "TPM-年度预算")
public class YearBudgetVo extends TenantFlagOpVo {

    /**
     * 年度预算编码
     */
    @ApiModelProperty(value = "年度预算编码", notes = "")
    private String yearBudgetCode;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(value = "业态[数据字典:mdm_business_format]", notes = "")
    private String businessFormatCode;

    /**
     * 业务单元
     */
    @ApiModelProperty(value = "业务单元", notes = "")
    private String businessUnitCode;

    /**
     * 是否生成已月度预算[数据字典:yesOrNo]
     */
    @ApiModelProperty(value = "是否生成已月度预算[数据字典:yesOrNo]", notes = "")
    private String monthBudgetFlag;

    /**
     * 年份
     */
    @ApiModelProperty(value = "年份", notes = "")
    private String yearLy;

    /**
     * 分组[数据字典:tpm_group_code]
     */
    @ApiModelProperty(value = "分组[数据字典:tpm_group_code]", notes = "")
    private String groupCode;

    /**
     * 部门编码
     */
    @ApiModelProperty(name = "部门编码", notes = "")
    private String orgCode;

    /**
     * 部门名称
     */
    @ApiModelProperty(name = "部门名称", notes = "")
    private String orgName;

    /**
     * 部门层级
     */
    @ApiModelProperty(name = "部门层级", notes = "")
    private String orgLevelCode;

    /**
     * 预算项目编码
     */
    @ApiModelProperty(value = "预算项目编码", notes = "")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称", notes = "")
    private String budgetItemName;

    /**
     * 预算项目层级[数据字典:tpm_budget_item_level]
     */
    @ApiModelProperty(value = "预算项目层级[数据字典:tpm_budget_item_level]", notes = "")
    private String budgetItemLevelCode;

    /**
     * 费用归口[数据字典:tpm_fee_belong]
     */
    @ApiModelProperty(value = "费用归口[数据字典:tpm_fee_belong]", notes = "")
    private String feeBelongCode;

    @ApiModelProperty(value = "费用归口-中文")
    private String feeSourceName;

    /**
     * 销售组织编码
     */
    @ApiModelProperty(value = "销售组织编码", notes = "")
    private String salesOrgCode;

    /**
     * 销售组织ERP编码
     */
    @ApiModelProperty(name = "销售组织ERP编码", notes = "")
    private String salesOrgErpCode;

    /**
     * 销售组织名称
     */
    @ApiModelProperty(value = "销售组织名称", notes = "")
    private String salesOrgName;

    /**
     * 销售组织层级
     */
    @ApiModelProperty(name = "销售组织层级", notes = "")
    private String salesOrgLevelCode;

    /**
     * 门店渠道层级
     */
    @ApiModelProperty(value = "门店渠道层级", notes = "")
    private String terminalChannelLevelCode;

    /**
     * 门店渠道编码
     */
    @ApiModelProperty(value = "门店渠道编码", notes = "")
    private String terminalChannelCode;

    /**
     * 门店渠道名称
     */
    @ApiModelProperty(value = "门店渠道名称", notes = "")
    private String terminalChannelName;

    /**
     * 客户渠道编码
     */
    @ApiModelProperty(value = "客户渠道编码", notes = "")
    private String customerChannelCode;

    /**
     * 客户渠道名称
     */
    @ApiModelProperty(value = "客户渠道名称", notes = "")
    private String customerChannelName;

    /**
     * 客户渠道层级
     */
    @ApiModelProperty(value = "客户渠道层级", notes = "")
    private String customerChannelLevelCode;

    /**
     * 系统编码
     */
    @ApiModelProperty(value = "系统编码", notes = "")
    private String systemCode;

    /**
     * 系统名称
     */
    @ApiModelProperty(value = "系统名称", notes = "")
    private String systemName;

    /**
     * 客户编码
     */
    @ApiModelProperty(value = "客户编码", notes = "")
    private String customerCode;

    /**
     * 客户ERP编码
     */
    @ApiModelProperty(name = "客户ERP编码", notes = "")
    private String customerErpCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(value = "客户名称", notes = "")
    private String customerName;

    /**
     * 门店编码
     */
    @ApiModelProperty(value = "门店编码", notes = "")
    private String terminalCode;

    /**
     * 门店名称
     */
    @ApiModelProperty(value = "门店名称", notes = "")
    private String terminalName;

    /**
     * 区域编码
     */
    @ApiModelProperty(value = "区域编码", notes = "")
    private String regionCode;

    /**
     * 区域名称
     */
    @ApiModelProperty(value = "区域名称", notes = "")
    private String regionName;

    /**
     * 品牌编码
     */
    @ApiModelProperty(value = "品牌编码", notes = "")
    private String productBrandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty(value = "品牌名称", notes = "")
    private String productBrandName;

    /**
     * 品类编码
     */
    @ApiModelProperty(value = "品类编码", notes = "")
    private String productCategoryCode;

    /**
     * 品类名称
     */
    @ApiModelProperty(value = "品类名称", notes = "")
    private String productCategoryName;

    /**
     * 品项编码
     */
    @ApiModelProperty(value = "品项编码", notes = "")
    private String productItemCode;

    /**
     * 品项名称
     */
    @ApiModelProperty(value = "品项名称", notes = "")
    private String productItemName;

    /**
     * 产品编码
     */
    @ApiModelProperty(value = "产品编码", notes = "")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty(value = "产品名称", notes = "")
    private String productName;

    /**
     * 预算计算编码
     */
    @ApiModelProperty(value = "预算计算编码", notes = "")
    private String budgetCalCode;

    /**
     * 预算总点数
     */
    @ApiModelProperty(value = "预算总点数", notes = "")
    private BigDecimal budgetTotalPoint;

    /**
     * 预算总金额
     */
    @ApiModelProperty(value = "预算总金额", notes = "")
    private BigDecimal budgetTotalAmount;

    /**
     * 已使用策略金额
     */
    @ApiModelProperty(value = "已使用策略金额", notes = "")
    private BigDecimal usedStrategyAmount;

    /**
     * 可使用策略金额
     */
    @ApiModelProperty(value = "可使用策略金额", notes = "")
    private BigDecimal usableStrategyAmount;


    /**
     * 总目标量
     */
    @ApiModelProperty(value = "总目标量", notes = "")
    private BigDecimal totalGoalQuantity;

    /**
     * 策略关联金额
     */
    @ApiModelProperty(value = "策略关联金额", notes = "")
    private BigDecimal strategyAmount;

    /**
     * 剩余可关联金额
     */
    @ApiModelProperty(value = "剩余可关联金额", notes = "")
    private BigDecimal remainderAmount;

    /**
     * 年度预算数据
     */
    @ApiModelProperty(value = "年度预算数据", notes = "")
    private List<YearBudgetDataVo> dataVos;

    /*冗余预算金额字段，只做列表展示用*/

    /**
     * 一月份
     */
    @ApiModelProperty("一月份")
    private BigDecimal januaryNum;

    /**
     * 二月份
     */
    @ApiModelProperty("二月份")
    private BigDecimal februaryNum;

    /**
     * 三月份
     */
    @ApiModelProperty("三月份")
    private BigDecimal marchNum;

    /**
     * 四月份
     */
    @ApiModelProperty("四月份")
    private BigDecimal aprilNum;

    /**
     * 五月份
     */
    @ApiModelProperty("五月份")
    private BigDecimal mayNum;

    /**
     * 六月份
     */
    @ApiModelProperty("六月份")
    private BigDecimal juneNum;

    /**
     * 七月份
     */
    @ApiModelProperty("七月份")
    private BigDecimal julyNum;

    /**
     * 八月份
     */
    @ApiModelProperty("八月份")
    private BigDecimal augustNum;

    /**
     * 九月份
     */
    @ApiModelProperty("九月份")
    private BigDecimal septemberNum;

    /**
     * 十月份
     */
    @ApiModelProperty("十月份")
    private BigDecimal octoberNum;

    /**
     * 十一月份
     */
    @ApiModelProperty("十一月份")
    private BigDecimal novemberNum;

    /**
     * 十二月份
     */
    @ApiModelProperty("十二月份")
    private BigDecimal decemberNum;

    /**
     * 年度力度
     */
    @ApiModelProperty(name = "年度力度", notes = "")
    private String budgetIntensity;

    /**
     * 年度力度-分子
     */
    @ApiModelProperty(name = "年度力度-分子", notes = "")
    private BigDecimal budgetIntensityNumerator;
    /**
     * 年度力度-分母
     */
    @ApiModelProperty(name = "年度力度-分母", notes = "")
    private BigDecimal budgetIntensityDenominator;

}
