package com.biz.crm.tpm.business.exe.warning.circular.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.exe.warning.circular.sdk.dto.ExeWarningCircularDto;
import com.biz.crm.tpm.business.exe.warning.circular.sdk.service.ExeWarningCircularService;
import com.biz.crm.tpm.business.exe.warning.circular.sdk.vo.ExeWarningCircularVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * (ExeWarningCircularEntity)表相关的http接口
 * 执行预警报表（新零售）
 *
 * @author makejava
 * @since 2022-11-08 12:05:57
 */

@RestController
@RequestMapping("/v1/exeWarningCircular/exeWarningCircular")
@Slf4j
@Api(tags = "TPM-活动监控中-执行预警报表（新零售）")
public class ExeWarningCircularController {


    /**
     * 服务对象 执行预警报表（新零售
     */
    @Autowired
    private ExeWarningCircularService exeWarningCircularService;

    /**
     * 分页查询所有数据
     *
     * @param pageable              分页对象
     * @param exeWarningCircularDto 查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "利润监控（分子公司）分页查询所有数据")
    @GetMapping("/findByConditions")
    public Result<Page<ExeWarningCircularVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                               @ApiParam(name = "dimensionBudget", value = "预算管理配置表") ExeWarningCircularDto exeWarningCircularDto) {
        try {
            Page<ExeWarningCircularVo> page = this.exeWarningCircularService.findByConditions(pageable, exeWarningCircularDto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
