package com.biz.crm.tpm.business.exe.warning.circular.local.dataview;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * TPM-执行预警报表（新零售）
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.5 14:23
 */
@Component
public class ExeWarningCircularDataViewRegister implements DataviewRegister {
    @Override
    public String code() {
        return "tpm_exe_warning_circular_data_view";
    }

    public String desc() {
        return "TPM-执行预警报表（新零售）配置数据视图";
    }

    @Override
    public String buildSql() {
        return "SELECT t.*  FROM tpm_exe_warning_circular t" +
                "  WHERE  t.del_flag = '" + EnableStatusEnum.ENABLE.getCode() + "' " +
                "  AND t.tenant_code = :tenantCode ";
    }
}
