package com.biz.crm.tpm.business.exe.warning.circular.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import java.math.BigDecimal;
import java.util.Date;

/**
 * (ExeWarningCircularEntity)实体类
 *
 * @author jiangyin
 * @since 2022-11-21 16:46:07
 */
@ApiModel(value = "ExeWarningCircularEntity", description = "TPM-执行预警报表（新零售）")
@TableName("tpm_exe_warning_circular")
@Data
@Entity(name = "tpm_exe_warning_circular")
@org.hibernate.annotations.Table(appliesTo = "tpm_exe_warning_circular", comment = "TPM-执行预警报表（新零售）")
public class ExeWarningCircularEntity extends TenantFlagOpEntity {

    /**
     * 日期
     */
    @ApiModelProperty(name = "日期", notes = "日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "put_cost_date", length = 32, columnDefinition = "datetime COMMENT '日期'")
    private Date putCostDate;

    /**
     * 促销规划编码
     */
    @ApiModelProperty("促销规划编码")
    @Column(name = "promotion_plan_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '促销规划编码'")
    private String promotionPlanCode;


    /**
     * 促销规划名称
     */
    @ApiModelProperty("促销规划名称")
    @Column(name = "promotion_plan_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '促销规划名称'")
    private String promotionPlanName;

    /**
     * 促销规划开始时间
     */
    @ApiModelProperty(name = "促销规划开始时间", notes = "促销规划开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "promotion_plan_begin_time", length = 20, columnDefinition = "datetime COMMENT '促销规划开始时间'")
    private Date promotionPlanBeginTime;

    /**
     * 促销规划结束时间
     */
    @ApiModelProperty(name = "促销规划结束时间", notes = "促销规划结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "promotion_plan_end_time", length = 20, columnDefinition = "datetime COMMENT '促销规划结束时间'")
    private Date promotionPlanEndTime;

    /**
     * 促销规划明细编码
     */
    @ApiModelProperty("促销规划明细编码")
    @Column(name = "expenses_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '促销规划明细编码'")
    private String expensesCode;

    /**
     * 活动类型
     */
    @ApiModelProperty("活动类型")
    @Column(name = "activity_type_code", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '活动类型'")
    private String activityTypeCode;

    /**
     * 活动类型名称 冗余
     */
    @ApiModelProperty(name = "活动类型名称", notes = "活动类型名称")
    @Column(name = "activity_type_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '活动类型名称'")
    private String activityTypeName;

    /**
     * 活动形式
     */
    @ApiModelProperty(name = "formOfActivity", notes = "活动形式")
    @Column(name = "form_of_activity", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '活动形式'")
    private String formOfActivity;

    /**
     * 关联预算
     */
    @ApiModelProperty(notes = "关联预算", value = "关联预算")
    @Column(name = "relate_budget", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '关联预算'")
    private String relateBudget;

    /**
     * 三级预算项目
     */
    @ApiModelProperty(name = "三级预算项目", notes = "三级预算项目")
    @Column(name = "third_budget_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '三级预算项目'")
    private String thirdBudgetCode;

    /**
     * 二级预算项目
     */
    @ApiModelProperty(name = "二级预算项目", notes = "二级预算项目")
    @Column(name = "second_budget_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '二级预算项目'")
    private String secondBudgetCode;

    /**
     * 一级预算项目
     */
    @ApiModelProperty(name = "一级预算项目", notes = "一级预算项目")
    @Column(name = "first_budget_amount", length = 128, columnDefinition = "VARCHAR(128) COMMENT '一级预算项目'")
    private String firstBudgetAmount;

    /**
     * 销售组织
     */
    @ApiModelProperty(name = "销售组织", notes = "销售组织")
    @Column(name = "sales_org_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '销售组织'")
    private String salesOrgCode;

    /**
     * 销售组织名称(冗余)
     */
    @ApiModelProperty(value = "销售组织名称", notes = "销售组织名称")
    @Column(name = "sales_org_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '销售组织名称'")
    private String salesOrgName;

    /**
     * 平台名称(冗余)
     */
    @ApiModelProperty(name = "平台名称", notes = "平台名称")
    @Column(name = "platform_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '平台名称'")
    private String platformName;


    /**
     * 平台
     */
    @ApiModelProperty(name = "platformCode", value = "平台", notes = "平台")
    @Column(name = "platform_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '平台 '")
    private String platformCode;


    /**
     * 客户
     */
    @ApiModelProperty("客户")
    @Column(name = "customer_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '客户'")
    private String customerCode;

    /**
     * 客户名称(冗余)
     */
    @ApiModelProperty("客户名称")
    @Column(name = "customer_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '客户名称'")
    private String customerName;


    /**
     * 品牌
     */
    @ApiModelProperty(value = "品牌", notes = "品牌")
    @Column(name = "product_brand_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '品牌 '")
    private String productBrandCode;

    /**
     * 品牌名称(冗余)
     */
    @ApiModelProperty(value = "品牌名称", notes = "品牌名称")
    @Column(name = "product_brand_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '品牌名称 '")
    private String productBrandName;

    /**
     * 产品
     */
    @ApiModelProperty(name = "产品", notes = "产品")
    @Column(name = "product_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '产品'")
    private String productCode;

    /**
     * 产品名称 (冗余)
     */
    @ApiModelProperty(name = "产品名称", notes = "产品名称")
    @Column(name = "product_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '产品名称'")
    private String productName;

    /**
     * 电商渠道
     */
    @ApiModelProperty(name = "电商渠道", notes = "电商渠道")
    @Column(name = "e_commerce_channel_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '电商渠道'")
    private String eCommerceChannelCode;

    /**
     * 电商渠道名称
     */
    @ApiModelProperty(name = "电商渠道名称", notes = "电商渠道名称")
    @Column(name = "e_commerce_channel_name",  length = 255, columnDefinition = "VARCHAR(255) COMMENT '电商渠道名称'")
    private String eCommerceChannelName;

    /**
     * 促销类型
     */
    @ApiModelProperty("促销类型")
    @Column(name = "promotion_type", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '促销类型'")
    private String promotionType;

    /**
     * 预算金额
     */
    @ApiModelProperty("预算金额（元）")
    @Column(name = "budget_amount", precision = 20, scale = 6, columnDefinition = "DECIMAL(20,6) COMMENT '预算金额（元）'")
    private BigDecimal budgetAmount;


    /**
     * 月 预计销量（箱）
     */
    @ApiModelProperty("月 预计销量（箱）")
    @Column(name = "day_estimated_sales_box", columnDefinition = "decimal(20,6) COMMENT '日 预计销量（箱）'")
    private BigDecimal dayEstimatedSalesBox;

    /**
     * 日 预计销售额（元）
     */
    @ApiModelProperty("日 预计销售额（元）")
    @Column(name = "day_estimated_amount", columnDefinition = "decimal(20,6) COMMENT  ' 日 预计销售额（元）'")
    private BigDecimal dayEstimatedAmount;


    /**
     * 月 预计销量（箱）
     */
    @ApiModelProperty("月 预计销量（箱）")
    @Column(name = "month_estimated_sales_box", columnDefinition = "decimal(20,6) COMMENT '月 预计销量（箱）'")
    private BigDecimal monthEstimatedSalesBox;

    /**
     * 月 预计销售额（元）
     */
    @ApiModelProperty("月 预计销售额（元）")
    @Column(name = "month_estimated_amount", columnDefinition = "decimal(20,6) COMMENT  ' 月 预计销售额（元）'")
    private BigDecimal monthEstimatedAmount;

    /**
     * 日实际销售额（元）
     */
    @ApiModelProperty(name = "实际销售额(元)", notes = "实际销售额(元)")
    @Column(name = "day_actual_sales_volume", columnDefinition = "decimal(20,6) COMMENT '日实际销售量（元）'")
    private BigDecimal dayActualSalesVolume;

    /**
     * 日实际销售量（箱）
     */
    @ApiModelProperty("日实际销售量（箱）")
    @Column(name = "day_actual_current_sales_volume", columnDefinition = "decimal(20,6) COMMENT '日实际销售量（箱）'")
    private BigDecimal dayActualCurrentSalesVolume;


    /**
     * 日销售进度
     */
    @ApiModelProperty(name = "salesProgress", value = "日销售进度", notes = "日销售进度")
    @Column(name = "day_sales_progress", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '日销售进度 '")
    private String daySalesProgress;

    /**
     * 月销售进度
     */
    @ApiModelProperty(name = "salesProgress", value = "月销售进度", notes = "月销售进度")
    @Column(name = "month_ales_progress", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '月销售进度 '")
    private String monthSalesProgress;

    /**
     * 费用申请金额（元）
     */
    @ApiModelProperty(name = "feeApplyAmount", value = "费用申请金额（元）", notes = "费用申请金额（元）")
    @Column(name = "fee_apply_amount", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '费用申请金额（元） '")
    private Double feeApplyAmount;




    /**
     * 规划费率
     */
    @ApiModelProperty(name = "planRate", value = "规划费率", notes = "规划费率")
    @Column(name = "plan_rate", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '规划费率 '")
    private String planRate;

    /**
     * 实际费率
     */
    @ApiModelProperty(name = "actualRate", value = "实际费率", notes = "实际费率")
    @Column(name = "actual_rate", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '实际费率 '")
    private String actualRate;

    /**
     * ROI
     */
    @ApiModelProperty(name = "ROI", value = "ROI", notes = "ROI")
    @Column(name = "ROI", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT 'ROI '")
    private String ROI;

    /**
     * 费用实际进度（元）
     */
    @ApiModelProperty(name = "feeActualProgress",value = "费用实际进度",notes = "费用实际进度")
    @Column(name = "fee_actual_progress", nullable = true,length = 24, columnDefinition = "DECIMAL(24,6) COMMENT '费用实际进度'")
    private BigDecimal feeActualProgress;

    /**
     * 费用实际消耗（元）
     */
    @ApiModelProperty(name = "feeActualConsumption", value = "费用实际消耗（元）", notes = "费用实际消耗（元）")
    @Column(name = "fee_actual_consumption", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '费用实际消耗（元）'")
    private Double feeActualConsumption;

    /**
     * 进度偏差
     */
    @ApiModelProperty(name = "进度偏差", notes = "进度偏差")
    @Column(name = "progress_variance", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '进度偏差'")
    private BigDecimal progressVariance;


}
