package com.biz.crm.tpm.business.exe.warning.circular.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.exe.warning.circular.local.entity.ExeWarningCircularEntity;
import com.biz.crm.tpm.business.exe.warning.circular.local.mapper.ExeWarningCircularMapper;
import com.biz.crm.tpm.business.exe.warning.circular.sdk.dto.ExeWarningCircularDto;
import com.biz.crm.tpm.business.exe.warning.circular.sdk.vo.ExeWarningCircularVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * (ExeWarningCircularVo)表数据库访问层
 *
 * @author makejava
 * @since 2022-11-03 17:06:39
 */

@Component
public class ExeWarningCircularRepository extends ServiceImpl<ExeWarningCircularMapper, ExeWarningCircularEntity> {

    @Autowired
    private ExeWarningCircularMapper exeWarningCircularMapper;

    /**
     * 分页查询数据
     *
     * @param pageable 分页对象
     * @param dto      实体对象
     * @return
     */
    public Page<ExeWarningCircularVo> findByConditions(Pageable pageable, ExeWarningCircularDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of(1, 50);
        }
        Page<ExeWarningCircularVo> page = new Page<ExeWarningCircularVo>(pageable.getPageNumber(), pageable.getPageSize());
        return exeWarningCircularMapper.findByConditions(page, dto);
    }
}
