package com.biz.crm.tpm.business.exe.warning.circular.local.service.internal;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.exe.warning.circular.local.repository.ExeWarningCircularRepository;
import com.biz.crm.tpm.business.exe.warning.circular.sdk.dto.ExeWarningCircularDto;
import com.biz.crm.tpm.business.exe.warning.circular.sdk.service.ExeWarningCircularService;
import com.biz.crm.tpm.business.exe.warning.circular.sdk.vo.ExeWarningCircularVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/**
 * (ExeWarningCircularServiceImpl)业务层实现类
 *
 * @author makejava
 * @since 2022-11-03 17:06:02
 */
@Slf4j
@Service("exeWarningCircularService")
public class ExeWarningCircularServiceImpl implements ExeWarningCircularService {

    @Autowired
    private ExeWarningCircularRepository exeWarningCircularRepository;

    /**
     * 分页查询数据
     *
     * @param pageable 分页对象
     * @param dto      实体对象
     * @return
     */
    @Override
    public Page<ExeWarningCircularVo> findByConditions(Pageable pageable, ExeWarningCircularDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of(1, 50);
        }
        if (dto == null) {
            dto = new ExeWarningCircularDto();
        }

        /**获取租户编号*/
        if (StringUtils.isBlank(dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }

        /**获取删除标志*/
        if (StringUtils.isBlank(dto.getDelFlag())) {
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        }

        return this.exeWarningCircularRepository.findByConditions(pageable, dto);
    }
}
