package com.biz.crm.tpm.business.exe.warning.circular.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;

/**
 * (ExeWarningCircularEntityVo)TPM-执行预警报表（新零售）
 *
 * @author makejava
 * @since 2022-11-05 12:00:01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "ExeWarningCircularEntityDto", description = "TPM-执行预警报表（新零售）")
public class ExeWarningCircularVo extends TenantFlagOpVo {
    /**
     * 日期
     */
    @ApiModelProperty(name = "日期", notes = "日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date putCostDate;

    /**
     * 促销规划编码
     */
    @ApiModelProperty("促销规划编码")
    private String promotionPlanCode;

    /**
     * 电商渠道
     */
    @ApiModelProperty(name = "电商渠道", notes = "电商渠道")
    private String eCommerceChannelCode;

    /**
     * 电商渠道名称
     */
    @ApiModelProperty(name = "电商渠道名称", notes = "电商渠道名称")
    private String eCommerceChannelName;


    /**
     * 促销规划名称
     */
    @ApiModelProperty("促销规划名称")
    private String promotionPlanName;

    /**
     * 促销规划开始时间
     */
    @ApiModelProperty(name = "促销规划开始时间", notes = "促销规划开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date promotionPlanBeginTime;

    /**
     * 促销规划结束时间
     */
    @ApiModelProperty(name = "促销规划结束时间", notes = "促销规划结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date promotionPlanEndTime;

    /**
     * 促销规划明细编码
     */
    @ApiModelProperty("促销规划明细编码")
    private String expensesCode;

    /**
     * 活动类型
     */
    @ApiModelProperty("活动类型")
    private String activityTypeCode;

    /**
     * 活动类型名称 冗余
     */
    @ApiModelProperty(name = "活动类型名称", notes = "活动类型名称")
    private String activityTypeName;

    /**
     * 活动形式
     */
    @ApiModelProperty(name = "formOfActivity", notes = "活动形式")
    private String formOfActivity;

    /**
     * 关联预算
     */
    @ApiModelProperty(notes = "关联预算", value = "关联预算")
    private String relateBudget;

    /**
     * 三级预算项目
     */
    @ApiModelProperty(name = "三级预算项目", notes = "三级预算项目")
    private String thirdBudgetCode;

    /**
     * 二级预算项目
     */
    @ApiModelProperty(name = "二级预算项目", notes = "二级预算项目")
    private String secondBudgetCode;

    /**
     * 一级预算项目
     */
    @ApiModelProperty(name = "一级预算项目", notes = "一级预算项目")
    private String firstBudgetAmount;

    /**
     * 销售组织
     */
    @ApiModelProperty(name = "销售组织", notes = "销售组织")
    private String salesOrgCode;

    /**
     * 销售组织名称(冗余)
     */
    @ApiModelProperty(value = "销售组织名称", notes = "销售组织名称")
    private String salesOrgName;

    /**
     * 平台名称(冗余)
     */
    @ApiModelProperty(name = "平台名称", notes = "平台名称")
    private String platformName;


    /**
     * 平台
     */
    @ApiModelProperty(name = "platformCode", value = "平台", notes = "平台")
    private String platformCode;


    /**
     * 客户
     */
    @ApiModelProperty("客户")
    private String customerCode;

    /**
     * 客户名称(冗余)
     */
    @ApiModelProperty("客户名称")
    private String customerName;


    /**
     * 品牌
     */
    @ApiModelProperty(value = "品牌", notes = "品牌")
    private String productBrandCode;

    /**
     * 品牌名称(冗余)
     */
    @ApiModelProperty(value = "品牌名称", notes = "品牌名称")
    private String productBrandName;

    /**
     * 产品
     */
    @ApiModelProperty(name = "产品", notes = "产品")
    private String productCode;

    /**
     * 产品名称 (冗余)
     */
    @ApiModelProperty(name = "产品名称", notes = "产品名称")
    private String productName;

    /**
     * 促销类型
     */
    @ApiModelProperty("促销类型")
    private String promotionType;

    /**
     * 预算金额（元）
     */
    @ApiModelProperty("预算金额（元）")
    private BigDecimal budgetAmount;


    /**
     * 月 预计销量（箱）
     */
    @ApiModelProperty("月 预计销量（箱）")
    private BigDecimal dayEstimatedSalesBox;

    /**
     * 日 预计销售额（元）
     */
    @ApiModelProperty("日 预计销售额（元）")
    private BigDecimal dayEstimatedAmount;


    /**
     * 月 预计销量（箱）
     */
    @ApiModelProperty("月 预计销量（箱）")
    private BigDecimal monthEstimatedSalesBox;

    /**
     * 月 预计销售额（元）
     */
    @ApiModelProperty("月 预计销售额（元）")
    private BigDecimal monthEstimatedAmount;

    /**
     * 日实际销售额（元）
     */
    @ApiModelProperty(name = "实际销售额(元)", notes = "实际销售额(元)")
    private BigDecimal dayActualSalesVolume;

    /**
     * 日实际销售量（箱）
     */
    @ApiModelProperty("日实际销售量（箱）")
    private BigDecimal dayActualCurrentSalesVolume;


    /**
     * 日销售进度
     */
    @ApiModelProperty(name = "salesProgress", value = "日销售进度", notes = "日销售进度")
    private String daySalesProgress;

    /**
     * 月销售进度
     */
    @ApiModelProperty(name = "salesProgress", value = "月销售进度", notes = "月销售进度")
    private String monthSalesProgress;

    /**
     * 费用申请金额（元）
     */
    @ApiModelProperty(name = "feeApplyAmount", value = "费用申请金额（元）", notes = "费用申请金额（元）")
    private Double feeApplyAmount;


    /**
     * 费用实际消耗（元）
     */
    @ApiModelProperty(name = "feeApplyAmount", value = "费用实际消耗（元）", notes = "费用实际消耗（元）")
    private Double feeActualConsumption;

    /**
     * 规划费率
     */
    @ApiModelProperty(name = "planRate", value = "规划费率", notes = "规划费率")
    private String planRate;

    /**
     * 实际费率
     */
    @ApiModelProperty(name = "actualRate", value = "实际费率", notes = "实际费率")
    private String actualRate;

    /**
     * ROI
     */
    @ApiModelProperty(name = "ROI", value = "ROI", notes = "ROI")
    private String ROI;

    /**
     * 费用实际消耗（元）
     */
    @ApiModelProperty(name = "feeActualProgress", value = "费用实际消耗（元）", notes = "费用实际消耗（元）")
    private Double feeActualProgress;

    /**
     * 进度偏差
     */
    @ApiModelProperty(name = "进度偏差", notes = "进度偏差")
    private BigDecimal progressVariance;

}
