package com.biz.crm.tpm.business.purchase.sale.stock.report.local.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.purchase.sale.stock.report.sdk.dto.PurchaseSaleStockDto;
import com.biz.crm.tpm.business.purchase.sale.stock.report.sdk.service.PurchaseSaleStockService;
import com.biz.crm.tpm.business.purchase.sale.stock.report.sdk.vo.PurchaseSaleStockVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 采销库存管理(PurchaseSaleStock)表相关的http接口
 *
 * @author makejava
 * @since 2022-11-29 14:25:03
 */
@RestController
@RequestMapping("/v1/purchaseSaleStock")
@Slf4j
@Api(tags = "采销库存管理")
public class PurchaseSaleStockController {
  /**
  * 服务对象
  */
  @Autowired
  private PurchaseSaleStockService purchaseSaleStockService;
  
  /**
   * 分页查询所有数据
   *
   * @param pageable 分页对象
   * @param purchaseSaleStock 查询实体
   * @return 所有数据
  */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByConditions")
  public Result<Page<PurchaseSaleStockVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                            @ApiParam(name = "purchaseSaleStock", value = "采销库存管理") PurchaseSaleStockDto purchaseSaleStock) {
    try {
      Page<PurchaseSaleStockVo> page =  this.purchaseSaleStockService.findByConditions(pageable,purchaseSaleStock);
      return Result.ok(page);
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
