package com.biz.crm.tpm.business.purchase.sale.stock.report.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @author ：dengwei
 * @date ：Created in 2022/11/29 13:56
 * @description：采销库存管理
 */
@ApiModel(value = "PurchaseSaleStock", description = "采销库存管理")
@TableName("tpm_purchase_sale_stock")
@Getter
@Setter
@Entity(name = "tpm_purchase_sale_stock")
@org.hibernate.annotations.Table(appliesTo = "tpm_purchase_sale_stock", comment = "采销库存管理")
@Table(name = "tpm_purchase_sale_stock")
public class PurchaseSaleStock extends TenantFlagOpEntity {

    /**
     * 销售组织编码
     */
    @ApiModelProperty(value = "销售组织编码", notes = "")
    @Column(name = "sales_org_code", nullable = true, length = 64, columnDefinition = " varchar(64) COMMENT '销售组织编码'")
    private String salesOrgCode;

    /**
     * 销售组织名称
     */
    @ApiModelProperty(value = "销售组织名称", notes = "")
    @Column(name = "sales_org_name", nullable = true, length = 200, columnDefinition = " varchar(200) COMMENT '销售组织名称'")
    private String salesOrgName;
    /**
     * 平台
     */
    @ApiModelProperty(name = "平台编码", notes = "平台编码")
    @Column(name = "platform_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '平台编码'")
    private String platformCode;

    /**
     * 客户编码
     */
    @ApiModelProperty(name = "客户编码", notes = "客户编码")
    @Column(name = "customer_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户编码'")
    private String customerCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(name = "客户名称", notes = "客户名称")
    @Column(name = "customer_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '客户名称'")
    private String customerName;

    /**
     * 品牌编码
     */
    @ApiModelProperty("品牌编码")
    @Column(name = "product_brand_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '品牌编码'")
    private String productBrandCode;
    /**
     * 品牌名称
     */
    @ApiModelProperty("品牌名称")
    @Column(name = "product_brand_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '品牌名称'")
    private String productBrandName;
    /**
     * 品类编码
     */
    @ApiModelProperty("品类编码")
    @Column(name = "product_category_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '品类编码'")
    private String productCategoryCode;
    /**
     * 品类名称
     */
    @ApiModelProperty("品类名称")
    @Column(name = "product_category_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '品类名称'")
    private String productCategoryName;
    /**
     * 品项编码
     */
    @ApiModelProperty("品项编码")
    @Column(name = "product_item_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '品项编码'")
    private String productItemCode;
    /**
     * 品项名称
     */
    @ApiModelProperty("品项名称")
    @Column(name = "product_item_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '品项名称'")
    private String productItemName;
    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    @Column(name = "product_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '产品编码'")
    private String productCode;
    /**
     * 产品名称
     */
    @ApiModelProperty("产品名称")
    @Column(name = "product_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '产品名称'")
    private String productName;


    /**
     * 库存年月
     */
    @ApiModelProperty("库存年月")
    @Column(name = "stock_year_and_month", columnDefinition = "varchar(10) COMMENT '库存年月'")
    private String stockYearAndMonth;
    /**
     *   上月理论库存（箱）
     */
    @ApiModelProperty("上月理论库存（箱）")
    @Column(name = "last_month_theory_stock", columnDefinition = "DECIMAL(24,6) COMMENT '上月理论库存（箱）'")
    private BigDecimal lastMonthTheoryStock;
     /**
      *   当月实际出库（箱）
      */
     @ApiModelProperty("当月实际出库（箱）")
     @Column(name = "this_month_actual_out_stock", columnDefinition = "DECIMAL(24,6) COMMENT '当月实际出库（箱）'")
     private BigDecimal thisMonthActualOutStock;
     /**
      *  当月实际销售（箱）
      */
     @ApiModelProperty("当月实际销售（箱）")
     @Column(name = "this_month_actual_sale_stock", columnDefinition = "DECIMAL(24,6) COMMENT '当月实际销售（箱）'")
     private BigDecimal thisMonthActualSaleStock;
     /**
      *  当月理论库存（箱）
      */
     @ApiModelProperty("当月理论库存（箱）")
     @Column(name = "this_month_actual_theory_stock", columnDefinition = "DECIMAL(24,6) COMMENT '当月理论库存（箱）'")
     private BigDecimal thisMonthActualTheoryStock;
}
