package com.biz.crm.tpm.business.purchase.sale.stock.report.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.day.sales.sdk.dto.TpmDaySalesSearchDto;
import com.biz.crm.tpm.business.purchase.sale.stock.report.local.entity.PurchaseSaleStock;
import com.biz.crm.tpm.business.purchase.sale.stock.report.sdk.dto.PurchaseSaleStockDto;
import com.biz.crm.tpm.business.purchase.sale.stock.report.sdk.vo.PurchaseSaleStockVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 采销库存管理(PurchaseSaleStock)表mybatis访问层
 *
 * @author makejava
 * @since 2022-11-29 14:25:07
 */
public interface PurchaseSaleStockMapper extends BaseMapper<PurchaseSaleStock> {

    /**
     * 分页查询所有数据
     *
     * @param page              分页对象
     * @param purchaseSaleStock 查询实体
     * @return 所有数据
     */
    Page<PurchaseSaleStockVo> findByConditions(@Param("page") Page<PurchaseSaleStockVo> page, @Param("dto") PurchaseSaleStockDto purchaseSaleStock);

    List<PurchaseSaleStockVo> findByConditionsNoPage(@Param("dto") List<TpmDaySalesSearchDto.QueryClass> queryClassList);

  void batchInsert(@Param("list") List<PurchaseSaleStockDto> insertResult);
}

