package com.biz.crm.tpm.business.purchase.sale.stock.report.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author ：dengwei
 * @date ：Created in 2022/11/8 14:07
 * @description：采销库存管理
 */
@Component
@Slf4j
public class SaleStockReportRegister implements DataviewRegister {
    @Override
    public String code() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String desc() {
        return "TPM-采销库存管理";
    }

    @Override
    public String buildSql() {
        return "select t.* from tpm_purchase_sale_stock t " +
                "where t.tenant_code = :tenantCode " +
                "and t.del_flag = '"+ DelFlagStatusEnum.NORMAL.getCode()+"'";
    }
}
