package com.biz.crm.tpm.business.purchase.sale.stock.report.local.repository;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.day.sales.sdk.dto.TpmDaySalesSearchDto;
import com.biz.crm.tpm.business.purchase.sale.stock.report.local.entity.PurchaseSaleStock;
import com.biz.crm.tpm.business.purchase.sale.stock.report.local.mapper.PurchaseSaleStockMapper;
import com.biz.crm.tpm.business.purchase.sale.stock.report.sdk.dto.PurchaseSaleStockDto;
import com.biz.crm.tpm.business.purchase.sale.stock.report.sdk.vo.PurchaseSaleStockVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;


/**
 * 采销库存管理(PurchaseSaleStock)表数据库访问层
 *
 * @author makejava
 * @since 2022-11-29 14:25:07
 */
@Component
public class PurchaseSaleStockRepository extends ServiceImpl<PurchaseSaleStockMapper, PurchaseSaleStock> {

  @Autowired
  private PurchaseSaleStockMapper purchaseSaleStockMapper;
  
   /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param purchaseSaleStock 实体对象
   * @return
   */
  public Page<PurchaseSaleStockVo> findByConditions(Pageable pageable, PurchaseSaleStockDto purchaseSaleStock) {
    Page<PurchaseSaleStockVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<PurchaseSaleStockVo> pageList = this.purchaseSaleStockMapper.findByConditions(page, purchaseSaleStock);
    return pageList;
  }

  public List<PurchaseSaleStockVo> findByConditionsNoPage(List<TpmDaySalesSearchDto.QueryClass> queryClassList) {
    return this.purchaseSaleStockMapper.findByConditionsNoPage(queryClassList);
  }

  public void batchInsert(List<PurchaseSaleStockDto> insertResult) {
    this.purchaseSaleStockMapper.batchInsert(insertResult);
  }
}

