package com.biz.crm.tpm.business.purchase.sale.stock.report.local.service.internal;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.product.brand.sdk.service.ProductBrandService;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgCacheService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.tpm.business.day.sales.sdk.dto.TpmDaySalesSearchDto;
import com.biz.crm.tpm.business.day.sales.sdk.service.TpmDaySalesService;
import com.biz.crm.tpm.business.day.sales.sdk.vo.TpmDaySalesVo;
import com.biz.crm.tpm.business.purchase.sale.stock.report.local.repository.PurchaseSaleStockRepository;
import com.biz.crm.tpm.business.purchase.sale.stock.report.sdk.dto.PurchaseSaleStockDto;
import com.biz.crm.tpm.business.purchase.sale.stock.report.sdk.service.PurchaseSaleStockService;
import com.biz.crm.tpm.business.purchase.sale.stock.report.sdk.vo.PurchaseSaleStockVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 采销库存管理(PurchaseSaleStock)表服务实现类
 *
 * @author makejava
 * @since 2022-11-29 14:25:05
 */
@Service("purchaseSaleStockService")
public class PurchaseSaleStockServiceImpl implements PurchaseSaleStockService {

  @Autowired(required = false)
  private PurchaseSaleStockRepository purchaseSaleStockRepository;

  @Autowired(required = false)
  private TpmDaySalesService tpmDaySalesService;
  
  @Autowired(required =false)
  private SalesOrgCacheService salesOrgCacheService;

  @Autowired(required = false)
  private ProductVoService productVoService;

  @Autowired(required = false)
  private ProductBrandService productBrandService;

  /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param purchaseSaleStock 实体对象
   * @return
   */
  @Override
  public Page<PurchaseSaleStockVo> findByConditions(Pageable pageable, PurchaseSaleStockDto purchaseSaleStock) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
    if (Objects.isNull(purchaseSaleStock)) {
      purchaseSaleStock = new PurchaseSaleStockDto();
    }
    return this.purchaseSaleStockRepository.findByConditions(pageable, purchaseSaleStock);
  }

  @Override
  public void savePurchaseSaleStock(List<PurchaseSaleStockDto> dtos) {
    if(CollectionUtils.isNotEmpty(dtos)){
      return;
    }
    TpmDaySalesSearchDto tpmDaySalesSearchDto = new TpmDaySalesSearchDto();
    List<TpmDaySalesSearchDto.QueryClass> queryClassList = new ArrayList<>();
    for (PurchaseSaleStockDto dto : dtos) {
      TpmDaySalesSearchDto.QueryClass queryClass = new TpmDaySalesSearchDto.QueryClass();
      if(StringUtils.isEmpty(dto.getCustomerCode())){
        continue;
      }
      queryClass.setCustomerCode(dto.getCustomerCode());
      if(StringUtils.isEmpty(dto.getProductCode())){
        continue;
      }
      queryClass.setProductCode(dto.getProductCode());
      if(StringUtils.isEmpty(dto.getStockYearAndMonth())){
        continue;
      }
      queryClass.setStockYearAndMonth(dto.getStockYearAndMonth());
      DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM");
      LocalDate yearAndMonth = LocalDate.parse(dto.getStockYearAndMonth(),df);
      queryClass.setStockYearAndLastMonth(yearAndMonth.format(df));
      queryClassList.add(queryClass);
    }
    Set<String> orgCodes = dtos.stream().map(PurchaseSaleStockDto::getSalesOrgCode).filter(Objects::nonNull).collect(Collectors.toSet());
    Map<String, SalesOrgVo> salesOrgVoMap = new HashMap<>();
    if(CollectionUtils.isNotEmpty(orgCodes)) {
      List<SalesOrgVo> salesOrgVos = salesOrgCacheService.findByOrgCodes(new ArrayList<>(orgCodes));
      salesOrgVoMap = salesOrgVos.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity()));
    }
    Set<String> productCodes = dtos.stream().map(PurchaseSaleStockDto::getProductCode).filter(Objects::nonNull).collect(Collectors.toSet());
    Map<String, ProductVo> productVoMap = new HashMap<>();
    if(CollectionUtils.isNotEmpty(productCodes)){
      List<ProductVo> productVoList = productVoService.findDetailsByIdsOrProductCodes(null, new ArrayList<>(productCodes));
      productVoMap = productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity()));
    }
    //map(客户+产品+年月,实体)
    Map<String, PurchaseSaleStockDto> purchaseSaleStockDtoMap = dtos.stream().collect(Collectors.toMap(o -> o.getCustomerCode() + "-" + o.getProductCode() + "-" + o.getStockYearAndMonth(), Function.identity()));

    //获取当月实际销售（箱）
    if(CollectionUtils.isNotEmpty(queryClassList)){
      List<TpmDaySalesVo> tpmDaySalesVos = tpmDaySalesService.findByConditionsNoPage2(tpmDaySalesSearchDto);
      Map<String, Map<String, Map<String, List<TpmDaySalesVo>>>> tpmDaySalesVoMap = tpmDaySalesVos.stream().collect(Collectors.groupingBy(TpmDaySalesVo::getCustomer, Collectors.groupingBy(TpmDaySalesVo::getGoodsCode, Collectors.groupingBy(TpmDaySalesVo::getStockYearAndMonth))));
      tpmDaySalesVoMap.forEach((key,value)->{
        value.forEach((key2,value2)->{
          value2.forEach((key3,value3)->{
            PurchaseSaleStockDto purchaseSaleStockDto = purchaseSaleStockDtoMap.get(key + "-" + key2 + "-" + key3);
            if(purchaseSaleStockDto != null){
              /*purchaseSaleStockDto.setThisMonthActualSaleStock(BigDecimal.valueOf(value3.stream().map(TpmDaySalesVo::getNum).filter(Objects::nonNull).reduce(Integer::sum).orElse(0)));*/
            }
          });
        });
      });
    }

    List<PurchaseSaleStockVo> purchaseSaleStockVoList = purchaseSaleStockRepository.findByConditionsNoPage(queryClassList);
    Map<String, PurchaseSaleStockVo> purchaseSaleStockVoMap = new HashMap<>();
    if(CollectionUtils.isNotEmpty(purchaseSaleStockVoList)){
      purchaseSaleStockVoMap = purchaseSaleStockVoList.stream().collect(Collectors.toMap(o -> o.getCustomerCode() + "-" + o.getProductCode() + "-" + o.getStockYearAndMonth(), Function.identity()));
    }
    //要更新的数据
    List<PurchaseSaleStockDto> updateResult = new ArrayList<>();
    //要插入的数据
    List<PurchaseSaleStockDto> insertResult = new ArrayList<>();
    for (TpmDaySalesSearchDto.QueryClass queryClass : queryClassList) {
      //上个月的数据
      PurchaseSaleStockVo lastPurchaseSaleStockVo = purchaseSaleStockVoMap.get(queryClass.getCustomerCode() + "-"+queryClass.getProductCode() + "-" + queryClass.getStockYearAndLastMonth());

      //这个月的数据
      PurchaseSaleStockVo thisPurchaseSaleStockVo = purchaseSaleStockVoMap.get(queryClass.getCustomerCode() + "-"+queryClass.getProductCode() + "-" + queryClass.getStockYearAndMonth());
      if(thisPurchaseSaleStockVo == null){
        PurchaseSaleStockDto purchaseSaleStockDto = purchaseSaleStockDtoMap.get(queryClass.getCustomerCode() + "-" + queryClass.getProductCode() + "-" + queryClass.getStockYearAndMonth());
        SalesOrgVo salesOrgVo = salesOrgVoMap.get(purchaseSaleStockDto.getSalesOrgCode());
        if(salesOrgVo != null) {
          purchaseSaleStockDto.setSalesOrgName(salesOrgVo.getSalesOrgName());
        }

        ProductVo productVo = productVoMap.get(purchaseSaleStockDto.getProductCode());
        if(productVo != null){
          purchaseSaleStockDto.setProductName(productVo.getProductName());
          //todo 产品品牌，品类，品项
        }
        purchaseSaleStockDto.setLastMonthTheoryStock(Optional.ofNullable(lastPurchaseSaleStockVo.getThisMonthActualTheoryStock()).orElse(BigDecimal.ZERO));
        purchaseSaleStockDto.setThisMonthActualTheoryStock(Optional.ofNullable(purchaseSaleStockDto.getLastMonthTheoryStock()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(purchaseSaleStockDto.getThisMonthActualOutStock()).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(purchaseSaleStockDto.getThisMonthActualSaleStock()).orElse(BigDecimal.ZERO)));
        purchaseSaleStockDto.setTenantCode(TenantUtils.getTenantCode());
        insertResult.add(purchaseSaleStockDto);
      }else {

      }
    }
    if(CollectionUtils.isNotEmpty(insertResult)){
      purchaseSaleStockRepository.batchInsert(insertResult);
    }
  }

}

