/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.purchase.sale.stock.report.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.product.brand.sdk.service.ProductBrandService;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgCacheService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.tpm.business.day.sales.sdk.dto.TpmDaySalesSearchDto;
import com.biz.crm.tpm.business.day.sales.sdk.service.TpmDaySalesService;
import com.biz.crm.tpm.business.day.sales.sdk.vo.TpmDaySalesVo;
import com.biz.crm.tpm.business.purchase.sale.stock.report.local.repository.PurchaseSaleStockRepository;
import com.biz.crm.tpm.business.purchase.sale.stock.report.sdk.dto.PurchaseSaleStockDto;
import com.biz.crm.tpm.business.purchase.sale.stock.report.sdk.service.PurchaseSaleStockService;
import com.biz.crm.tpm.business.purchase.sale.stock.report.sdk.vo.PurchaseSaleStockVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service(value="purchaseSaleStockService")
public class PurchaseSaleStockServiceImpl
implements PurchaseSaleStockService {
    @Autowired(required=false)
    private PurchaseSaleStockRepository purchaseSaleStockRepository;
    @Autowired(required=false)
    private TpmDaySalesService tpmDaySalesService;
    @Autowired(required=false)
    private SalesOrgCacheService salesOrgCacheService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private ProductBrandService productBrandService;

    public Page<PurchaseSaleStockVo> findByConditions(Pageable pageable, PurchaseSaleStockDto purchaseSaleStock) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(purchaseSaleStock)) {
            purchaseSaleStock = new PurchaseSaleStockDto();
        }
        return this.purchaseSaleStockRepository.findByConditions(pageable, purchaseSaleStock);
    }

    public void savePurchaseSaleStock(List<PurchaseSaleStockDto> dtos) {
        if (CollectionUtils.isNotEmpty(dtos)) {
            return;
        }
        TpmDaySalesSearchDto tpmDaySalesSearchDto = new TpmDaySalesSearchDto();
        ArrayList<TpmDaySalesSearchDto.QueryClass> queryClassList = new ArrayList<TpmDaySalesSearchDto.QueryClass>();
        for (PurchaseSaleStockDto dto : dtos) {
            TpmDaySalesSearchDto.QueryClass queryClass = new TpmDaySalesSearchDto.QueryClass();
            if (StringUtils.isEmpty((CharSequence)dto.getCustomerCode())) continue;
            queryClass.setCustomerCode(dto.getCustomerCode());
            if (StringUtils.isEmpty((CharSequence)dto.getProductCode())) continue;
            queryClass.setProductCode(dto.getProductCode());
            if (StringUtils.isEmpty((CharSequence)dto.getStockYearAndMonth())) continue;
            queryClass.setStockYearAndMonth(dto.getStockYearAndMonth());
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM");
            LocalDate yearAndMonth = LocalDate.parse(dto.getStockYearAndMonth(), df);
            queryClass.setStockYearAndLastMonth(yearAndMonth.format(df));
            queryClassList.add(queryClass);
        }
        Set orgCodes = dtos.stream().map(PurchaseSaleStockDto::getSalesOrgCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Map<Object, Object> salesOrgVoMap = new HashMap();
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            List salesOrgVos = this.salesOrgCacheService.findByOrgCodes(new ArrayList(orgCodes));
            salesOrgVoMap = salesOrgVos.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity()));
        }
        Set productCodes = dtos.stream().map(PurchaseSaleStockDto::getProductCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Map<Object, Object> productVoMap = new HashMap();
        if (CollectionUtils.isNotEmpty(productCodes)) {
            List productVoList = this.productVoService.findDetailsByIdsOrProductCodes(null, new ArrayList(productCodes));
            productVoMap = productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity()));
        }
        Map purchaseSaleStockDtoMap = dtos.stream().collect(Collectors.toMap(o -> o.getCustomerCode() + "-" + o.getProductCode() + "-" + o.getStockYearAndMonth(), Function.identity()));
        if (CollectionUtils.isNotEmpty(queryClassList)) {
            List tpmDaySalesVos = this.tpmDaySalesService.findByConditionsNoPage2(tpmDaySalesSearchDto);
            Map<String, Map<String, Map<String, List<TpmDaySalesVo>>>> tpmDaySalesVoMap = tpmDaySalesVos.stream().collect(Collectors.groupingBy(TpmDaySalesVo::getCustomer, Collectors.groupingBy(TpmDaySalesVo::getGoodsCode, Collectors.groupingBy(TpmDaySalesVo::getStockYearAndMonth))));
            tpmDaySalesVoMap.forEach((key, value) -> value.forEach((key2, value2) -> value2.forEach((key3, value3) -> {
                PurchaseSaleStockDto purchaseSaleStockDto = (PurchaseSaleStockDto)purchaseSaleStockDtoMap.get(key + "-" + key2 + "-" + key3);
                if (purchaseSaleStockDto != null) {
                    // empty if block
                }
            })));
        }
        List<PurchaseSaleStockVo> purchaseSaleStockVoList = this.purchaseSaleStockRepository.findByConditionsNoPage(queryClassList);
        Map<Object, Object> purchaseSaleStockVoMap = new HashMap();
        if (CollectionUtils.isNotEmpty(purchaseSaleStockVoList)) {
            purchaseSaleStockVoMap = purchaseSaleStockVoList.stream().collect(Collectors.toMap(o -> o.getCustomerCode() + "-" + o.getProductCode() + "-" + o.getStockYearAndMonth(), Function.identity()));
        }
        ArrayList updateResult = new ArrayList();
        ArrayList<PurchaseSaleStockDto> insertResult = new ArrayList<PurchaseSaleStockDto>();
        for (TpmDaySalesSearchDto.QueryClass queryClass : queryClassList) {
            ProductVo productVo;
            PurchaseSaleStockVo lastPurchaseSaleStockVo = (PurchaseSaleStockVo)purchaseSaleStockVoMap.get(queryClass.getCustomerCode() + "-" + queryClass.getProductCode() + "-" + queryClass.getStockYearAndLastMonth());
            PurchaseSaleStockVo thisPurchaseSaleStockVo = (PurchaseSaleStockVo)purchaseSaleStockVoMap.get(queryClass.getCustomerCode() + "-" + queryClass.getProductCode() + "-" + queryClass.getStockYearAndMonth());
            if (thisPurchaseSaleStockVo != null) continue;
            PurchaseSaleStockDto purchaseSaleStockDto = (PurchaseSaleStockDto)purchaseSaleStockDtoMap.get(queryClass.getCustomerCode() + "-" + queryClass.getProductCode() + "-" + queryClass.getStockYearAndMonth());
            SalesOrgVo salesOrgVo = (SalesOrgVo)salesOrgVoMap.get(purchaseSaleStockDto.getSalesOrgCode());
            if (salesOrgVo != null) {
                purchaseSaleStockDto.setSalesOrgName(salesOrgVo.getSalesOrgName());
            }
            if ((productVo = (ProductVo)productVoMap.get(purchaseSaleStockDto.getProductCode())) != null) {
                purchaseSaleStockDto.setProductName(productVo.getProductName());
            }
            purchaseSaleStockDto.setLastMonthTheoryStock(Optional.ofNullable(lastPurchaseSaleStockVo.getThisMonthActualTheoryStock()).orElse(BigDecimal.ZERO));
            purchaseSaleStockDto.setThisMonthActualTheoryStock(Optional.ofNullable(purchaseSaleStockDto.getLastMonthTheoryStock()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(purchaseSaleStockDto.getThisMonthActualOutStock()).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(purchaseSaleStockDto.getThisMonthActualSaleStock()).orElse(BigDecimal.ZERO)));
            purchaseSaleStockDto.setTenantCode(TenantUtils.getTenantCode());
            insertResult.add(purchaseSaleStockDto);
        }
        if (CollectionUtils.isNotEmpty(insertResult)) {
            this.purchaseSaleStockRepository.batchInsert(insertResult);
        }
    }
}

