package com.biz.crm.tpm.business.purchase.sale.stock.report.sdk.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.purchase.sale.stock.report.sdk.dto.PurchaseSaleStockDto;
import com.biz.crm.tpm.business.purchase.sale.stock.report.sdk.vo.PurchaseSaleStockVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 采销库存管理(PurchaseSaleStock)表服务接口
 *
 * @author makejava
 * @since 2022-11-29 14:25:05
 */
public interface PurchaseSaleStockService {

    /**
     * 分页查询数据
     *
     * @param pageable          分页对象
     * @param purchaseSaleStock 实体对象
     * @return
     */
    Page<PurchaseSaleStockVo> findByConditions(Pageable pageable, PurchaseSaleStockDto purchaseSaleStock);

    /**
     * 保存更新采销库存数据
     * @param dtos
     */
    void savePurchaseSaleStock(List<PurchaseSaleStockDto> dtos);

}

