package com.biz.crm.tpm.business.purchase.sale.stock.report.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * @author ：dengwei
 * @date ：Created in 2022/11/29 19:07
 * @description：采购库存关联vo
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "PurchaseSaleStockVo", description = "采购库存关联vo")
public class PurchaseSaleStockVo extends TenantFlagOpVo {
    /**
     * 销售组织编码
     */
    @ApiModelProperty(value = "销售组织编码", notes = "")
    private String salesOrgCode;

    /**
     * 销售组织名称
     */
    @ApiModelProperty(value = "销售组织名称", notes = "")
    private String salesOrgName;
    /**
     * 平台
     */
    @ApiModelProperty(name = "平台编码", notes = "平台编码")
    private String platformCode;

    /**
     * 客户编码
     */
    @ApiModelProperty(name = "客户编码", notes = "客户编码")
    private String customerCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(name = "客户名称", notes = "客户名称")
    private String customerName;

    /**
     * 品牌编码
     */
    @ApiModelProperty("品牌编码")
    private String productBrandCode;
    /**
     * 品牌名称
     */
    @ApiModelProperty("品牌名称")
    private String productBrandName;
    /**
     * 品类编码
     */
    @ApiModelProperty("品类编码")
    private String productCategoryCode;
    /**
     * 品类名称
     */
    @ApiModelProperty("品类名称")
    private String productCategoryName;
    /**
     * 品项编码
     */
    @ApiModelProperty("品项编码")
    private String productItemCode;
    /**
     * 品项名称
     */
    @ApiModelProperty("品项名称")
    private String productItemName;
    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    private String productCode;
    /**
     * 产品名称
     */
    @ApiModelProperty("产品名称")
    private String productName;


    /**
     * 库存年月
     */
    @ApiModelProperty("库存年月")
    private String stockYearAndMonth;
    /**
     *   上月理论库存（箱）
     */
    @ApiModelProperty("上月理论库存（箱）")
    private BigDecimal lastMonthTheoryStock;
    /**
     *   当月实际出库（箱）
     */
    @ApiModelProperty("当月实际出库（箱）")
    private BigDecimal thisMonthActualOutStock;
    /**
     *  当月实际销售（箱）
     */
    @ApiModelProperty("当月实际销售（箱）")
    private BigDecimal thisMonthActualSaleStock;
    /**
     *  当月理论库存（箱）
     */
    @ApiModelProperty("当月理论库存（箱）")
    private BigDecimal thisMonthActualTheoryStock;
}
