package com.biz.crm.tpm.business.variable.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.variable.feign.impl.ForeignAuditExecuteIndicatorApiFeignImpl;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 外部系统调用处理执行指标表接口
 * @author wanghaojia
 * @date 2023/11/24 12:16
 */
@FeignClient(
        name = "${mdm.feign-client.name:crm-tpm}",
        path = "crm-tpm",
        fallbackFactory = ForeignAuditExecuteIndicatorApiFeignImpl.class)
public interface ForeignAuditExecuteIndicatorApiFeign {

    /**
     * 根据活动细案创建执行指标表数据
     */
    @PostMapping(value = "/v1/foreign/api/auditExecuteIndicator/createFromActivityDetailPlan")
    Result createFromActivityDetailPlan(@RequestBody List<AuditExecuteIndicatorDto> list);

}
