package com.biz.crm.tpm.business.variable.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.variable.feign.ForeignAuditExecuteIndicatorApiFeign;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import com.biz.crm.tpm.business.variable.sdk.service.ForeignAuditExecuteIndicatorApiService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 外部系统调用处理执行指标表接口
 * @author wanghaojia
 * @date 2023/11/24 10:52
 */
@Service
public class ForeignAuditExecuteIndicatorApiServiceImpl implements ForeignAuditExecuteIndicatorApiService {

    @Autowired(required = false)
    private ForeignAuditExecuteIndicatorApiFeign foreignAuditExecuteIndicatorApiFeign;

    /**
     * 根据活动细案创建执行指标表数据
     */
    @Override
    public Result createFromActivityDetailPlan(List<AuditExecuteIndicatorDto> list){
        Result<Page<Object>> result = foreignAuditExecuteIndicatorApiFeign.createFromActivityDetailPlan(list);
        if (!result.isSuccess()) {
            throw new UnsupportedOperationException("根据活动细案创建执行指标表数据失败：" + result.getMessage());
        }
        return result;
    }

}
