package com.biz.crm.tpm.business.variable.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.variable.sdk.dto.SourceCustomVariableDto;
import com.biz.crm.tpm.business.variable.sdk.service.SourceCustomVariableService;
import com.biz.crm.tpm.business.variable.sdk.vo.SourceCustomVariableVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-04-24
 */
@RestController
@RequestMapping("/v1/sourceCustomVariable")
@Slf4j
@Api(tags = "固定数据源自定义核销变量表")
public class SourceCustomVariableController {

    @Autowired(required = false)
    private SourceCustomVariableService sourceCustomVariableService;

    @ApiOperation(value = "详情")
    @GetMapping(value = "findById")
    public Result<SourceCustomVariableVo> findById(@RequestParam("id") String id) {
        try {
            return Result.ok(this.sourceCustomVariableService.findById(id));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "新增")
    @PostMapping(value = "create")
    public Result<?> create(@RequestBody SourceCustomVariableDto dto) {
        try {
            this.sourceCustomVariableService.create(dto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "编辑")
    @PostMapping(value = "update")
    public Result<?> update(@RequestBody SourceCustomVariableDto dto) {
        try {
            this.sourceCustomVariableService.update(dto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "启用")
    @PostMapping(value = "enable")
    public Result<?> enable(@RequestBody List<String> ids) {
        try {
            this.sourceCustomVariableService.enable(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "禁用")
    @PostMapping(value = "disable")
    public Result<?> disable(@RequestBody List<String> ids) {
        try {
            this.sourceCustomVariableService.disable(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
