package com.biz.crm.tpm.business.variable.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.variable.local.register.ecommerce.ECommerceAuditDateRegister;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.dto.ControlsDto;
import com.biz.crm.tpm.business.variable.sdk.service.VariableService;
import com.biz.crm.tpm.business.variable.sdk.vo.ControlsVo;
import com.biz.crm.tpm.business.variable.sdk.vo.RegisterVariableVo;
import com.biz.crm.tpm.business.variable.sdk.vo.VariableCalTestVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @author ：dengwei
 * @date ：Created in 2022/11/18 11:15
 * @description：变量
 */
@RestController
@RequestMapping("/v1/variable")
@Slf4j
@Api(tags = "变量主表")
public class VariableController {

    @Autowired(required = false)
    private VariableService variableService;

    @ApiOperation(value = "获取变量列表")
    @GetMapping("variableList")
    public Result<List<RegisterVariableVo>> variableList(@RequestParam("isConfigure") String isConfigure,
                                                         @RequestParam("function") String function,
                                                         @RequestParam(value = "name",required = false) String name,
                                                         @RequestParam(value = "pageSize",required = false) Integer pageSize) {
        try {
            return Result.ok(this.variableService.variableList(isConfigure,function,name, pageSize));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "获取变量列表（可做权限）")
    @GetMapping("variableAuthList")
    public Result<List<RegisterVariableVo>> variableAuthList(@RequestParam("isConfigure") String isConfigure,
                                                         @RequestParam("function") String function,
                                                         @RequestParam(value = "name",required = false) String name,
                                                         @RequestParam(value = "pageSize",required = false) Integer pageSize) {
        try {
            return Result.ok(this.variableService.variableAuthList(isConfigure,function,name, pageSize));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "测试计算")
    @PostMapping("calTest")
    public Result<VariableCalTestVo> calTest(@RequestBody CalculateDto dto) {
        try {
            return Result.ok(this.variableService.calTest(dto));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "整体管控测试")
    @PostMapping("overallControl")
    public Result<ControlsVo> calTest(@RequestBody ControlsDto dto) {
        try {
            return Result.ok(this.variableService.overallControl(dto));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @Autowired(required = false)
    private ECommerceAuditDateRegister eCommerceAuditDateRegister;

    @ApiOperation("测试指标取值")
    @PostMapping("ecloseTest`")
    public Result<?> ecloseTest(@RequestBody CalculateDto calculate){
        try {
            Map<String, BigDecimal> resultMap = eCommerceAuditDateRegister.calculateVariable(calculate);
            return Result.ok(resultMap);
        }catch (Exception e){
            log.error(e.getMessage());
            return Result.error(e.getMessage());
        }
    }
}
