package com.biz.crm.tpm.business.variable.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Description 配置变量详情
 * @Author YangWei
 * @Date 2023/3/17 上午10:14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ConVariableDetailEntity", description = "核销公式可配置变量明细表")
@TableName("tpm_con_variable_detail")
@Entity
@Table(name = "tpm_con_variable_detail", indexes = {
    @Index(name = "tpm_con_variable_detail_index1", columnList = "audit_formula_code")
})
@org.hibernate.annotations.Table(appliesTo = "tpm_con_variable_detail", comment = "核销公式可配置变量明细表")
public class ConVariableDetailEntity extends TenantFlagOpEntity {

    @ApiModelProperty(name = "核销公式编码", notes = "核销code")
    @Column(name = "audit_formula_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '核销公式编码'")
    private String auditFormulaCode;

    @ApiModelProperty(name = "配置变量编码code", notes = "配置变量编码code")
    @Column(name = "variable_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '配置变量编码code'")
    private String variableCode;

    /**
     * 开始时间
     */
    @ApiModelProperty(name = "开始时间", notes = "开始时间")
    @Column(name = "begin_time", nullable = false, columnDefinition = "DATETIME COMMENT '开始时间 '")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date beginTime;

    /**
     * 结束时间
     */
    @ApiModelProperty(name = "结束时间", notes = "结束时间")
    @Column(name = "end_time", nullable = false, columnDefinition = "DATETIME COMMENT '结束时间 '")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    @ApiModelProperty(name = "summaryDimension",value = "汇总维度", notes = "汇总维度")
    @Column(name = "summary_dimension",  length = 64, columnDefinition = "VARCHAR(64) COMMENT '汇总维度'")
    private String summaryDimension;

    @ApiModelProperty(name = "item_type",value = "条件类型", notes = "条件类型")
    @Column(name = "item_type",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '条件类型'")
    private String itemType;

    @ApiModelProperty(name = "item_code",value = "条件编码", notes = "条件编码")
    @Column(name = "item_code",  length = 64, columnDefinition = "VARCHAR(64) COMMENT '条件编码'")
    private String itemCode;

    @ApiModelProperty(name = "item_name",value = "条件名称", notes = "条件名称")
    @Column(name = "item_name",  length = 255, columnDefinition = "VARCHAR(255) COMMENT '条件名称'")
    private String itemName;

    /**
     * 品牌编码
     */
    @Column(name = "product_brand_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '品牌编码'")
    private String productBrandCode;

    /**
     * 品牌名称
     */
    @Column(name = "product_brand_name",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '品牌名称'")
    private String productBrandName;

    /**
     * 品类编码
     */
    @Column(name = "product_category_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '品类编码'")
    private String productCategoryCode;

    /**
     * 品类名称
     */
    @Column(name = "product_category_name",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '品类名称'")
    private String productCategoryName;

    /**
     * 品项编码
     */
    @Column(name = "product_item_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '品项编码'")
    private String productItemCode;

    /**
     * 品项名称
     */
    @Column(name = "product_item_name",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '品项名称'")
    private String productItemName;

    /**
     * 点数
     */
    @Column(name = "point", columnDefinition = "DECIMAL(20,10) COMMENT '点数'")
    private BigDecimal point;
}