package com.biz.crm.tpm.business.variable.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-04-24
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SourceCustomVariableEntity", description = "固定数据源自定义核销变量表")
@TableName("tpm_source_custom_variable")
@Entity
@Table(name = "tpm_source_custom_variable", indexes = {
        @Index(name = "tpm_source_custom_variable_index1", columnList = "variable_code"),
        @Index(name = "tpm_source_custom_variable_index2", columnList = "only_key", unique = true)
})
@org.hibernate.annotations.Table(appliesTo = "tpm_source_custom_variable", comment = "固定数据源自定义核销变量表")
public class SourceCustomVariableEntity extends TenantFlagOpEntity {

    @ApiModelProperty(name = "数据源", notes = "数据源")
    @Column(name = "data_source",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '数据源'")
    private String dataSource;

    @ApiModelProperty(name = "业务单元", notes = "业务单元")
    @Column(name = "business_unit_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '业务单元'")
    private String businessUnitCode;

    @ApiModelProperty(value = "业态", notes = "业态")
    @Column(name = "business_format_code", length = 128, columnDefinition = "varchar(128) COMMENT '业态'")
    private String businessFormatCode;

    @ApiModelProperty(name = "变量编码", notes = "变量编码")
    @Column(name = "variable_code", unique = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '变量编码'")
    private String variableCode;

    @ApiModelProperty(name = "变量名称", notes = "变量名称")
    @Column(name = "variable_name", unique = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '变量名称'")
    private String variableName;

    @ApiModelProperty(name = "自定义参数", notes = "自定义参数")
    @Column(name = "params_json",  columnDefinition = "text COMMENT '自定义参数'")
    private String paramsJson;
}
