package com.biz.crm.tpm.business.variable.local.executeIndicator.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.third.system.sd.sdk.dto.PromotionActivityCallbackDto;
import com.biz.crm.mn.third.system.sd.sdk.service.QueryActivitySapCallbackService;
import com.biz.crm.tpm.business.variable.local.executeIndicator.service.CowManagerActivityExecutionService;
import com.biz.crm.tpm.business.variable.local.executeIndicator.service.internal.CowManagerActivityExecutionAsyncService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author: chenlong
 * @date: 2022/11/14 19:27
 * @description: 结案核销-执行指标管理表(AuditExecuteIndicator)表相关的http接口
 */
@RestController
@RequestMapping("/v1/auditExecuteIndicator")
@Slf4j
@Api(tags = "结案核销-执行指标管理")
public class AuditExecuteIndicatorController {

    @Autowired(required = false)
    private AuditExecuteIndicatorService auditExecuteIndicatorService;

    @Autowired(required = false)
    private CowManagerActivityExecutionService cowManagerActivityExecutionService;

    @Autowired(required = false)
    private CowManagerActivityExecutionAsyncService cowManagerActivityExecutionAsyncService;

    @Autowired(required = false)
    private LoginUserService loginUserService;


    /**
     * 分页查询所有数据
     *
     * @param pageable                 分页对象
     * @param auditExecuteIndicatorDto 查询dto
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("findByConditions")
    public Result<Page<AuditExecuteIndicatorVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                  @ApiParam(name = "auditExecuteIndicatorDto", value = "结案核销执行指标主表vo") AuditExecuteIndicatorDto auditExecuteIndicatorDto) {
        try {
            Page<AuditExecuteIndicatorVo> page = this.auditExecuteIndicatorService.findByConditions(pageable, auditExecuteIndicatorDto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @ApiOperation(value = "通过主键查询单条数据")
    @GetMapping("{id}")
    public Result<AuditExecuteIndicatorVo> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
        try {
            AuditExecuteIndicatorVo auditExecuteIndicatorVo = this.auditExecuteIndicatorService.findById(id);
            return Result.ok(auditExecuteIndicatorVo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 修改数据
     *
     * @param dto dto对象
     * @return 修改结果
     */
    @ApiOperation(value = "修改数据")
    @PatchMapping
    public Result<?> update(@ApiParam(name = "dto", value = "结案核销执行指标主表Dto") @RequestBody AuditExecuteIndicatorDto dto) {
        try {
            this.auditExecuteIndicatorService.update(dto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 删除数据
     *
     * @param ids 主键结合
     * @return 删除结果
     */
    @ApiOperation(value = "删除数据")
    @DeleteMapping("delete")
    public Result<?> delete(@RequestParam("ids") List<String> ids) {
        try {
            this.auditExecuteIndicatorService.delete(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 启用
     *
     * @param ids 主键列表
     * @return 启用结果
     */
    @ApiOperation(value = "启用", httpMethod = "PATCH")
    @PatchMapping("/enable")
    public Result<?> enable(@RequestBody List<String> ids) {
        try {
            this.auditExecuteIndicatorService.enableBatch(ids);
            return Result.ok("启用成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 禁用
     *
     * @param ids 主键列表
     * @return 禁用结果
     */
    @ApiOperation(value = "禁用", httpMethod = "PATCH")
    @PatchMapping("/disable")
    public Result<?> disable(@RequestBody List<String> ids) {
        try {
            this.auditExecuteIndicatorService.disableBatch(ids);
            return Result.ok("禁用成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "牛人管家活动查询", httpMethod = "Get")
    @GetMapping("/queryActivityExecution/cowManager")
    public Result<?> queryExecutionFromCowManager(@RequestParam("type") String type,@RequestParam("upDateTime")String upDateTime) {
        try {
            AbstractCrmUserIdentity userIdentity = loginUserService.getAbstractLoginUser();
            this.cowManagerActivityExecutionAsyncService.queryDisplayCostFromCowManager(type,upDateTime, userIdentity);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "Sap-活动执行查询-分公司", httpMethod = "POST")
    @PostMapping("/queryActivityExecution/sapBranch/all")
    public Result<?> queryAllExecutionFromSapBranch() {
        try {
            this.auditExecuteIndicatorService.queryAllExecutionSapBranch();
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "Sap-活动执行查询-分公司-单查询", httpMethod = "POST")
    @PostMapping("/queryActivityExecution/sapBranch/one")
    public Result<?> queryOneExecutionFromSapBranch(@ApiParam(name = "orgCode", value = "销售组织编码") @RequestParam("orgCode") String orgCode,
                                                    @ApiParam(name = "itemCode", value = "促销活动号") @RequestParam("itemCode") String itemCode,
                                                    @ApiParam(name = "activityDate", value = "日期") @RequestParam(value = "activityDate", required = false) String activityDate) {
        try {
            this.auditExecuteIndicatorService.queryExecutionSapBranch(orgCode, itemCode, activityDate);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @Autowired
    private QueryActivitySapCallbackService queryActivitySapCallbackService;

    @ApiOperation(value = "TEST——SAP促销活动执行结果-分公司回调", httpMethod = "POST")
    @PostMapping("/TEST/TEST")
    public Result<?> testTest(@ApiParam(name = "dto", value = "dto") @RequestBody PromotionActivityCallbackDto dto) {
        try {
            queryActivitySapCallbackService.queryBranchCallback(dto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


}
