package com.biz.crm.tpm.business.variable.local.executeIndicator.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.log.sdk.constant.ForeignLogGlobalConstants;
import com.biz.crm.mn.common.log.sdk.dto.ForeignLogDetailDto;
import com.biz.crm.mn.common.log.sdk.service.ForeignLogVoService;
import com.biz.crm.mn.common.log.sdk.util.ForeignLogUtil;
import com.biz.crm.tpm.business.variable.local.executeIndicator.service.ForeignAuditExecuteIndicatorApiAsyncService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;


/**
 * 外部系统调用处理执行指标表接口
 *
 * @author wanghaojia
 * @date 2023/11/26 12:20
 */
@RestController
@RequestMapping("/v1/foreign/api/auditExecuteIndicator")
@Slf4j
@Api(tags = "外部系统调用处理执行指标表接口")
public class ForeignAuditExecuteIndicatorApiController {

    @Autowired(required = false)
    private ForeignAuditExecuteIndicatorApiAsyncService foreignAuditExecuteIndicatorApiAsyncService;

    @Autowired(required = false)
    private ForeignLogVoService foreignLogVoService;

    /**
     * 执行指标表根据活动细案创建接口
     * @param list 活动对象
     */
    @PostMapping(value = "createFromActivityDetailPlan")
    public Result createFromActivityDetailPlan(@RequestBody List<AuditExecuteIndicatorDto> list) {
        Result<?> result = Result.ok();
        try {
            ForeignLogDetailDto detailDto = ForeignLogUtil.buildLogSaveInfo(list);
            detailDto.setMethod("ForeignAuditExecuteIndicatorApiController.create");
            detailDto.setMethodMsg("外部系统调用处理执行指标表接口");
            detailDto.setInvokeType(ForeignLogGlobalConstants.EXTERNAL_INTERFACE);
            foreignLogVoService.addOrUpdateLog(detailDto, true);
            foreignAuditExecuteIndicatorApiAsyncService.createFromActivityDetailPlan(list);
            ForeignLogUtil.buildLogResult(detailDto, result);
            foreignLogVoService.addOrUpdateLog(detailDto, false);
        }catch (Exception e){
            log.error("执行指标表数据创建失败",e);
            result = Result.error("执行指标表数据创建失败:"+e.getMessage());
        }
        return result;
    }

}
