package com.biz.crm.tpm.business.variable.local.executeIndicator.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author: chenlong
 * @date: 2022/11/14 16:59
 * @description:
 */
@ApiModel(value = "AuditExecuteIndicator", description = "结案核销-执行指标表")
@TableName("tpm_audit_execute_indicator")
@Getter
@Setter
@Entity(name = "tpm_audit_execute_indicator")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_execute_indicator", comment = "结案核销-执行指标表")
@Table(name = "tpm_audit_execute_indicator", indexes = {
        @Index(name = "tpm_audit_execute_indicator_INDEX1", columnList = "indicator_code", unique = true),
        @Index(name = "tpm_audit_execute_indicator_INDEX2", columnList = "active_number", unique = false),
        @Index(name = "tpm_audit_execute_indicator_INDEX4", columnList = "customer_code,year_and_month", unique = false),
        @Index(name = "tpm_audit_execute_indicator_INDEX5", columnList = "customer_code", unique = false),
        @Index(name = "tpm_audit_execute_indicator_INDEX6", columnList = "tenant_code,del_flag,active_number", unique = false),
})
public class AuditExecuteIndicator extends TenantFlagOpEntity {

    @ApiModelProperty(name = "业态", notes = "业态")
    @Column(name = "business_format_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '业态'")
    private String businessFormatCode;

    @ApiModelProperty(name = "业务单元", notes = "业务单元")
    @Column(name = "business_unit_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '业务单元'")
    private String businessUnitCode;

    @ApiModelProperty(name = "指标编码", notes = "指标编码")
    @Column(name = "indicator_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '指标编码'")
    private String indicatorCode;

    @ApiModelProperty(name = "指标名称", notes = "指标名称")
    @Column(name = "indicator_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '指标名称'")
    private String indicatorName;

    @ApiModelProperty(name = "变量编码", notes = "变量编码")
    @Column(name = "variable_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '变量编码'")
    private String variableCode;

    @ApiModelProperty(name = "指标值", notes = "指标值")
    @Column(name = "indicator_value", length = 24, columnDefinition = "decimal(24,6) COMMENT '指标值'")
    private BigDecimal indicatorValue;

    @ApiModelProperty(name = "对接系统", notes = "对接系统")
    @Column(name = "docking_system", length = 128, columnDefinition = "VARCHAR(128) COMMENT '对接系统'")
    private String dockingSystem;

    @ApiModelProperty(name = "年月", notes = "年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "year_and_month", length = 32, columnDefinition = "date COMMENT '年月'")
    private Date yearAndMonth;

    @ApiModelProperty(value = "salesInstitutionCode", name = "销售机构编码", notes = "销售机构编码")
    @Column(name = "sales_institution_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售机构编码'")
    private String salesInstitutionCode;

    @ApiModelProperty(value = "salesInstitutionName", name = "销售机构名称", notes = "销售机构名称")
    @Column(name = "sales_institution_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '销售机构名称'")
    private String salesInstitutionName;

    @ApiModelProperty(value = "salesInstitutionErpCode", name = "销售机构erp编码", notes = "销售机构erp编码")
    @Column(name = "sales_institution_erp_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售机构erp编码'")
    private String salesInstitutionErpCode;

    @ApiModelProperty(value = "salesRegionCode", name = "销售部门编码", notes = "销售部门编码")
    @Column(name = "sales_region_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售部门编码'")
    private String salesRegionCode;

    @ApiModelProperty(value = "salesRegionName", name = "销售部门名称", notes = "销售部门名称")
    @Column(name = "sales_region_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '销售部门名称'")
    private String salesRegionName;

    @ApiModelProperty(value = "salesRegionErpCode", name = "销售部门erp编码", notes = "销售部门erp编码")
    @Column(name = "sales_region_erp_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售部门erp编码'")
    private String salesRegionErpCode;

    @ApiModelProperty(name = "销售组织编码", notes = "销售组织编码")
    @Column(name = "sales_org_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织编码'")
    private String salesOrgCode;

    @ApiModelProperty(name = "销售组织名称", notes = "销售组织名称")
    @Column(name = "sales_org_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '销售组织名称'")
    private String salesOrgName;

    @ApiModelProperty(value = "salesOrgErpCode", name = "销售组织erp编码", notes = "销售组织erp编码")
    @Column(name = "sales_org_erp_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织erp编码'")
    private String salesOrgErpCode;

    @ApiModelProperty(name = "渠道编码", notes = "渠道编码")
    @Column(name = "channel_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '渠道编码'")
    private String channelCode;

    @ApiModelProperty(name = "渠道名称", notes = "渠道名称")
    @Column(name = "channel_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '渠道名称'")
    private String channelName;

    @ApiModelProperty(name = "客户编码", notes = "客户编码")
    @Column(name = "customer_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户编码'")
    private String customerCode;

    @ApiModelProperty(name = "客户名称", notes = "客户名称")
    @Column(name = "customer_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '客户名称'")
    private String customerName;

    @ApiModelProperty(name = "客户erp编码", notes = "客户erp编码")
    @Column(name = "customer_erp_code", length = 256, columnDefinition = "VARCHAR(256) COMMENT '客户erp编码'")
    private String customerErpCode;

    @ApiModelProperty(name = "门店编码", notes = "门店编码")
    @Column(name = "stores_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '门店编码'")
    private String storesCode;

    @ApiModelProperty(name = "门店名称", notes = "门店名称")
    @Column(name = "stores_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '门店名称'")
    private String storesName;

    @ApiModelProperty(name = "人员类型", notes = "人员类型")
    @Column(name = "personnel_type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '人员类型'")
    private String personnelType;

    @ApiModelProperty(name = "人员Id", notes = "人员Id")
    @Column(name = "personnel_id", length = 32, columnDefinition = "VARCHAR(32) COMMENT '人员Id'")
    private String personnelId;


    /**
     * 牛人管家活动执行结果信息字段
     */
    @ApiModelProperty(name = "费用类型")
    @Column(name = "cost_type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '费用类型'")
    private String costType;

    @ApiModelProperty(name = "活动细案明细编码")
    @Column(name = "active_number", length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动细案明细编码'")
    private String activeNumber;

    @ApiModelProperty(name = "状态编码", notes = "0不合格,1合格 ")
    @Column(name = "is_qualified_code", length = 2, columnDefinition = "VARCHAR(32) COMMENT '状态编码 0不合格,1合格 '")
    private String isQualifiedCode;

    @ApiModelProperty(name = "状态", notes = "合格/不合格")
    @Column(name = "is_qualified", length = 10, columnDefinition = "VARCHAR(32) COMMENT '状态 合格/不合格'")
    private String isQualified;

    @ApiModelProperty(name = "不合格原因")
    @Column(name = "is_qualified_reason", length = 255, columnDefinition = "VARCHAR(255) COMMENT '不合格原因'")
    private String isQualifiedReason;

    @ApiModelProperty(name = "是否关闭活动编码", notes = "0否,1是")
    @Column(name = "activity_status_code", length = 2, columnDefinition = "VARCHAR(2) COMMENT '是否关闭活动编码 0否,1是'")
    private String activityStatusCode;

    @ApiModelProperty(name = "是否关闭活动")
    @Column(name = "activity_status", length = 10, columnDefinition = "VARCHAR(10) COMMENT '是否关闭活动'")
    private String activityStatus;

    @ApiModelProperty(name = "扣减活动金额")
    @Column(name = "inspect_costs", length = 24, columnDefinition = "decimal(24,6) COMMENT '扣减活动金额'")
    private BigDecimal inspectCosts;

    @ApiModelProperty(name = "扣减大区金额")
    @Column(name = "region_inspect_costs", length = 24, columnDefinition = "decimal(24,6) COMMENT '扣减大区金额'")
    private BigDecimal regionInspectCosts;

    @ApiModelProperty("更新时间")
    @Column(name = "up_data_time", length = 10, columnDefinition = "VARCHAR(10) COMMENT '更新时间'")
    private String upDataTime;

    /**
     * SAP活动执行结果字段
     */
    @ApiModelProperty(name = "活动发生数量")
    @Column(name = "expenses_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '活动发生费用'")
    private BigDecimal expensesAmount;

    @ApiModelProperty(name = "活动发生费用")
    @Column(name = "expenses_incurred", length = 24, columnDefinition = "decimal(24,6) COMMENT '活动发生费用'")
    private BigDecimal expensesIncurred;
    /**
     * 垂直增加字段
     */
    @ApiModelProperty("人员编码")
    @Column(name = "person_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '人员编码'")
    private String personCode;

    @ApiModelProperty("人员名称")
    @Column(name = "person_name", length = 32, columnDefinition = "VARCHAR(32) COMMENT '人员名称'")
    private String personName;

    @ApiModelProperty("员工类型编码")
    @Column(name = "employee_type_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '员工类型编码'")
    private String employeeTypeCode;

    @ApiModelProperty("员工类型名称")
    @Column(name = "employee_type_name", length = 32, columnDefinition = "VARCHAR(32) COMMENT '员工类型名称'")
    private String employeeTypeName;

    @ApiModelProperty("所属大区编码")
    @Column(name = "region_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属大区编码'")
    private String regionCode;

    @ApiModelProperty("所属大区名称")
    @Column(name = "region_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '所属大区名称'")
    private String regionName;

    @ApiModelProperty(name = "customerRetailerCode", notes = "所属零售商编码")
    @TableField(value = "customer_retailer_code")
    @Column(name = "customer_retailer_code", length = 32, columnDefinition = "varchar(32) COMMENT '所属零售商编码'")
    private String customerRetailerCode;

    @ApiModelProperty(name = "customerRetailerName", notes = "所属零售商名称")
    @TableField(value = "customer_retailer_name")
    @Column(name = "customer_retailer_name", length = 256, columnDefinition = "varchar(256) COMMENT '所属零售商名称'")
    private String customerRetailerName;

    /**
     * 产品编码
     */
    @ApiModelProperty(name = "产品编码", notes = "产品编码")
    @Column(name = "product_code", length = 64, columnDefinition = "varchar(64) COMMENT '产品编码'")
    private String productCode;
    /**
     * 产品名称
     */
    @ApiModelProperty(name = "产品名称", notes = "产品名称")
    @Column(name = "product_name", length = 64, columnDefinition = "varchar(64) COMMENT '产品名称'")
    private String productName;
    /**
     * 品牌编码
     */
    @ApiModelProperty(name = "品牌编码", notes = "品牌编码")
    @TableField(value = "product_brand_code")
    @Column(name = "product_brand_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 品牌编码 '")
    private String productBrandCode;
    /**
     * 品牌名称
     */
    @ApiModelProperty(name = "品牌名称", notes = "品牌名称")
    @Column(name = "product_brand_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 品牌名称 '")
    private String productBrandName;
    /**
     * 所属品类编码
     */
    @ApiModelProperty("所属品类编码")
    @Column(name = "product_category_code", length = 64, columnDefinition = "varchar(64) COMMENT '所属品类编码'")
    private String productCategoryCode;
    /**
     * 所属品类名称
     */
    @ApiModelProperty(name = "所属品类名称", notes = "所属品类名称")
    @Column(name = "product_category_name", length = 64, columnDefinition = "varchar(64) COMMENT '所属品类名称'")
    private String productCategoryName;
    /**
     * 品项编码
     */
    @ApiModelProperty("品项编码")
    @Column(name = "product_item_code", length = 64, columnDefinition = "varchar(64) COMMENT '品项编码'")
    private String productItemCode;
    /**
     * 品项名称
     */
    @ApiModelProperty(name = "品项名称", notes = "品项名称")
    @Column(name = "product_item_name", length = 64, columnDefinition = "varchar(64) COMMENT '品项名称'")
    private String productItemName;

    @ApiModelProperty(name = "活动类型编码", notes = "活动类型编码")
    @Column(name = "activity_type_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '活动类型编码'")
    private String activityTypeCode;

    @ApiModelProperty(name = "活动类型名称", notes = "活动类型名称")
    @Column(name = "activity_type_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '活动类型名称'")
    private String activityTypeName;

    @ApiModelProperty(name = "活动形式名称", notes = "活动形式名称")
    @Column(name = "activity_form_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '活动形式名称'")
    private String activityFormName;

    @ApiModelProperty(name = "活动形式Code", notes = "活动形式Code")
    @Column(name = "activity_form_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '活动形式Code'")
    private String activityFormCode;

    @ApiModelProperty(name = "活动开始时间", notes = "活动开始时间")
    @Column(name = "activity_begin_date", length = 20, columnDefinition = "VARCHAR(20) COMMENT '活动开始时间'")
    private String activityBeginDate;

    @ApiModelProperty(name = "活动结束时间", notes = "活动结束时间")
    @Column(name = "activity_end_date", length = 20, columnDefinition = "VARCHAR(20) COMMENT '活动结束时间'")
    private String activityEndDate;

    @ApiModelProperty(name = "人员身份证", notes = "人员身份证")
    @Column(name = "person_id_card", length = 32, columnDefinition = "VARCHAR(32) COMMENT '人员身份证'")
    private String personIdCard;

//    @ApiModelProperty(name = "细案明细编码", notes = "细案明细编码")
//    @Column(name = "detail_plan_item_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '细案明细编码'")
//    private String detailPlanItemCode;

    @ApiModelProperty("一级渠道编码")
    @Column(name = "first_channel_code", length = 32, columnDefinition = "varchar(32) COMMENT '一级渠道编码'")
    private String firstChannelCode;

    @ApiModelProperty("一级渠道名称")
    @Column(name = "first_channel_name", length = 256, columnDefinition = "varchar(256) COMMENT '一级渠道名称'")
    private String firstChannelName;

    @ApiModelProperty("二级渠道编码")
    @Column(name = "second_channel_code", length = 32, columnDefinition = "varchar(32) COMMENT '二级渠道编码'")
    private String secondChannelCode;

    @ApiModelProperty("二级渠道名称")
    @Column(name = "second_channel_name", length = 256, columnDefinition = "varchar(256) COMMENT '二级渠道名称'")
    private String secondChannelName;

    @ApiModelProperty("总部统筹预算项目编码")
    @Column(name = "head_budget_item_code", length = 32, columnDefinition = "varchar(32) COMMENT '总部统筹预算项目编码'")
    private String headBudgetItemCode;

    @ApiModelProperty("大区预算项目编码")
    @Column(name = "month_budget_code", length = 32, columnDefinition = "varchar(32) COMMENT '大区预算项目编码'")
    private String monthBudgetCode;

    @ApiModelProperty("形式说明")
    @Column(name = "specification", length = 256, columnDefinition = "varchar(256) COMMENT '形式说明'")
    private String specification;

    @ApiModelProperty("是否临时活动")
    @Column(name = "is_temporary", length = 10, columnDefinition = "varchar(10) COMMENT '是否临时活动'")
    private String isTemporary;

}
