package com.biz.crm.tpm.business.variable.local.executeIndicator.listener;

import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignSapEventDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.event.SubComActivityDesignSapEventListener;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignSapEventResponse;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.constant.AuditExecuteIndicatorConstant;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author: chenlong
 * @date: 2023/3/28 16:23
 * @description: 分子公司活动规划获取执行指标表sap发生额和发生量事件实现
 */
@Slf4j
@Component
public class SubComActivityDesignSapEventListenerImpl implements SubComActivityDesignSapEventListener {


    @Autowired(required = false)
    private AuditExecuteIndicatorService auditExecuteIndicatorService;


    /**
     * 获取执行指标表sap发生额和发生量
     * @param sapDto 参数
     * @return SubComActivityDesignSapEventResponse
     */
    @Override
    public SubComActivityDesignSapEventResponse getSapAmountAndQuantity(SubComActivityDesignSapEventDto sapDto) {
        SubComActivityDesignSapEventResponse sapEventResponse = new SubComActivityDesignSapEventResponse();
        if(CollectionUtils.isEmpty(sapDto.getActivityNos())){
            return sapEventResponse;
        }
        Map<String,BigDecimal> sapAmountMap = new HashMap<>();
        Map<String,BigDecimal> sapQuantityMap = new HashMap<>();
        List<AuditExecuteIndicatorVo> list = auditExecuteIndicatorService.getSapAmountAndQuantityByDetailItemNos(sapDto.getActivityNos());
        if(CollectionUtils.isEmpty(list)){
            sapEventResponse.setSapAmountMap(sapAmountMap);
            sapEventResponse.setSapQuantityMap(sapQuantityMap);
            return sapEventResponse;
        }
        for (AuditExecuteIndicatorVo indicatorVo : list) {
            if(AuditExecuteIndicatorConstant.DICT_VALUE_SAP_OCCURRENCE_AMOUNT.equals(indicatorVo.getIndicatorName())){
                if(sapAmountMap.containsKey(indicatorVo.getActiveNumber())){
                    BigDecimal b = sapAmountMap.get(indicatorVo.getActiveNumber());
                    b = b.add(null!=indicatorVo.getIndicatorValue()?indicatorVo.getIndicatorValue():BigDecimal.ZERO);
                    sapAmountMap.put(indicatorVo.getActiveNumber(),b);
                }else {
                    sapAmountMap.put(indicatorVo.getActiveNumber(),null!=indicatorVo.getIndicatorValue()?indicatorVo.getIndicatorValue():BigDecimal.ZERO);
                }
            }else if(AuditExecuteIndicatorConstant.DICT_VALUE_SAP_OCCURRENCE_QUANTITY.equals(indicatorVo.getIndicatorName())){
                if(sapQuantityMap.containsKey(indicatorVo.getActiveNumber())){
                    BigDecimal b = sapQuantityMap.get(indicatorVo.getActiveNumber());
                    b = b.add(null!=indicatorVo.getIndicatorValue()?indicatorVo.getIndicatorValue():BigDecimal.ZERO);
                    sapQuantityMap.put(indicatorVo.getActiveNumber(),b);
                }else {
                    sapQuantityMap.put(indicatorVo.getActiveNumber(),null!=indicatorVo.getIndicatorValue()?indicatorVo.getIndicatorValue():BigDecimal.ZERO);
                }
            }
        }
        sapEventResponse.setSapAmountMap(sapAmountMap);
        sapEventResponse.setSapQuantityMap(sapQuantityMap);
        return sapEventResponse;
    }
}
