package com.biz.crm.tpm.business.variable.local.executeIndicator.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.common.base.mapper.MnBaseMapper;
import com.biz.crm.tpm.business.variable.local.executeIndicator.entity.AuditExecuteIndicator;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorOnlyKeyVo;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author: chenlong
 * @date: 2022/11/14 19:19
 * @description: 结案核销-执行指标表(AuditExecuteIndicator)表mybatis访问层
 */
public interface AuditExecuteIndicatorMapper extends MnBaseMapper<AuditExecuteIndicator> {

    /**
     * 分页查询所有数据
     *
     * @param page                     分页对象
     * @param auditExecuteIndicatorDto 查询Dto
     * @return 所有数据
     */
    Page<AuditExecuteIndicatorVo> findByConditions(@Param("page") Page<AuditExecuteIndicatorVo> page, @Param("auditExecuteIndicatorDto") AuditExecuteIndicatorDto auditExecuteIndicatorDto);

    /**
     * 大批量保存
     *
     * @param entities 数据列表
     */
    void bulkSave(@Param("indicators") List<AuditExecuteIndicator> entities);

    /**根据活动细案明细编码查询指标
     *
     * @param activeNumberList
     * @param indicatorName
     * @return
     */
    List<AuditExecuteIndicator> findByCode(@Param("activeNumber")String activeNumberList,@Param("indicatorName")String indicatorName);

    List<AuditExecuteIndicatorVo> findByCodeList(@Param("activeNumberList")List<String> activeNumberList,@Param("indicatorName")String indicatorName);

    /**
     * 时间+客户+销售组织维度查询数据
     * @param dto
     * @return
     */
    List<AuditExecuteIndicator> findData(@Param("dto")AuditExecuteIndicatorDto dto);

    /**
     *
     * @param activeNumber 活动号
     * @param dockingSystem 来源系统
     * @param businessUnitCode 业务单元
     * @return
     */
    List<AuditExecuteIndicatorVo> findByActiveNumber(@Param("activeNumbers") List<String> activeNumber, @Param("dockingSystem") String dockingSystem, @Param("businessUnitCode") String businessUnitCode);

    /**
     * 通过唯一维度查询Id
     *
     * @param keys       唯一维度拼接编码列表
     * @param tenantCode 租户
     * @return List<AuditExecuteIndicatorOnlyKeyVo>
     */
    List<AuditExecuteIndicatorOnlyKeyVo> findByOnlyKeys(@Param("keys")List<List<String>> keys,@Param("tenantCode") String tenantCode);
}
