package com.biz.crm.tpm.business.variable.local.executeIndicator.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author: chenlong
 * @date: 2022/11/16 10:48
 * @description: 结案核销-执行指标数据视图
 */
@Component
@Slf4j
public class AuditExecuteIndicatorDataviewRegister implements DataviewRegister {
    @Override
    public String code() {
        return "tpm_audit_execute_indicator_data_view";
    }

    @Override
    public String desc() {
        return "TPM-结案核销-执行指标表";
    }

    @Override
    public String buildSql() {
        return "select t.*,\n" +
                "DATE_FORMAT(t.year_and_month,'%Y-%m') as year_and_month_str\n" +
                "from tpm_audit_execute_indicator t\n" +
                "where t.tenant_code = :tenantCode\n" +
                "and t.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "'";
    }
}
