package com.biz.crm.tpm.business.variable.local.executeIndicator.repository;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.variable.local.executeIndicator.entity.AuditExecuteIndicator;
import com.biz.crm.tpm.business.variable.local.executeIndicator.mapper.AuditExecuteIndicatorMapper;
import com.biz.crm.tpm.business.variable.local.register.auditExecuteIndicator.common.AuditExecuteIndicatorParamBuilder;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorOnlyKeyVo;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * @author: chenlong
 * @date: 2022/11/14 19:21
 * @description: 结案核销-执行指标表(AuditExecuteIndicator)表数据库访问层
 */
@Component
public class AuditExecuteIndicatorRepository extends ServiceImpl<AuditExecuteIndicatorMapper, AuditExecuteIndicator> {

    @Autowired(required = false)
    private AuditExecuteIndicatorMapper auditExecuteIndicatorMapper;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;


    /**
     * 分页查询数据
     *
     * @param pageable                 分页对象
     * @param auditExecuteIndicatorDto 查询Dto
     * @return Page<AuditExecuteIndicatorVo>
     */
    public Page<AuditExecuteIndicatorVo> findByConditions(Pageable pageable, AuditExecuteIndicatorDto auditExecuteIndicatorDto) {
        Page<AuditExecuteIndicatorVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.auditExecuteIndicatorMapper.findByConditions(page, auditExecuteIndicatorDto);
    }

    /**
     * 大批量保存
     *
     * @param entities 数据列表
     */
    public void bulkSave(List<AuditExecuteIndicator> entities) {
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        //保存
        this.auditExecuteIndicatorMapper.bulkSave(entities);
    }

    /**
     * 重构修改方法
     *
     * @param entity     实体类
     * @param tenantCode 租户编码
     */
    public void updateByIdAndTenantCode(AuditExecuteIndicator entity, String tenantCode) {
        if (null == entity) {
            return;
        }
        if (StringUtils.isEmpty(tenantCode) || StringUtils.isEmpty(entity.getId())) {
            return;
        }
        LambdaUpdateWrapper<AuditExecuteIndicator> lambdaUpdateWrapper = Wrappers.lambdaUpdate();
        lambdaUpdateWrapper.eq(AuditExecuteIndicator::getTenantCode, tenantCode);
        lambdaUpdateWrapper.eq(AuditExecuteIndicator::getId, entity.getId());
        this.baseMapper.update(entity, lambdaUpdateWrapper);
    }

    /**
     * 重构批量修改方法
     *
     * @param entitys    实体类集合
     * @param tenantCode 租户编码
     */
    public void updateBatchByIdAndTenantCode(Collection<AuditExecuteIndicator> entitys, String tenantCode) {
        if (CollectionUtils.isEmpty(entitys)) {
            return;
        }
        if (StringUtils.isEmpty(tenantCode)) {
            return;
        }
        entitys.forEach(item -> {
            if (StringUtils.isNotBlank(item.getId())) {
                LambdaUpdateWrapper<AuditExecuteIndicator> lambdaUpdateWrapper = Wrappers.lambdaUpdate();
                lambdaUpdateWrapper.eq(AuditExecuteIndicator::getTenantCode, tenantCode);
                lambdaUpdateWrapper.eq(AuditExecuteIndicator::getId, item.getId());
                this.baseMapper.update(item, lambdaUpdateWrapper);
            }
        });
    }


    public List<AuditExecuteIndicator> findListByCondition(AuditExecuteIndicatorDto dto) {

        if (StringUtils.isEmpty(dto.getBusinessFormatCode()) || StringUtils.isEmpty(dto.getBusinessUnitCode())
                || Objects.isNull(dto.getYearAndMonth()) || StringUtils.isEmpty(dto.getSalesOrgCode())
                || StringUtils.isEmpty(dto.getCustomerCode()) || StringUtils.isEmpty(dto.getIndicatorCode())) {
            throw new RuntimeException("业态，业务单元，年月，销售组织，客户编码,指标编码不能为空");
        }
        List<AuditExecuteIndicator> list = this.lambdaQuery().eq(AuditExecuteIndicator::getBusinessFormatCode, dto.getBusinessFormatCode())
                .eq(AuditExecuteIndicator::getBusinessUnitCode, dto.getBusinessUnitCode())
                .eq(AuditExecuteIndicator::getYearAndMonth, dto.getYearAndMonth())
                .eq(AuditExecuteIndicator::getSalesOrgCode, dto.getSalesOrgCode())
                .eq(AuditExecuteIndicator::getCustomerCode, dto.getCustomerCode())
                .eq(AuditExecuteIndicator::getVariableCode, dto.getIndicatorCode())
                .eq(StringUtils.isNotEmpty(dto.getStoresCode()), AuditExecuteIndicator::getStoresCode, dto.getStoresCode()).list();

        return list;
    }

    public List<AuditExecuteIndicator> findByCode(String activeNumber, String indicatorName) {
        if (StringUtils.isEmpty(activeNumber) || StringUtils.isEmpty(indicatorName)) {
            throw new RuntimeException("活动细案明细编码、指标名称不能为空！");
        }
        return this.auditExecuteIndicatorMapper.findByCode(activeNumber, indicatorName);
    }

    public List<AuditExecuteIndicatorVo> findByCodeList(List<String> activeNumberList, String indicatorName) {
        if (CollectionUtils.isEmpty(activeNumberList) || StringUtils.isEmpty(indicatorName)) {
            throw new RuntimeException("活动细案明细编码、指标名称不能为空！");
        }
        return this.auditExecuteIndicatorMapper.findByCodeList(activeNumberList, indicatorName);
    }

    /**
     * 时间+客户+销售组织维度查询数据
     *
     * @param dto
     * @return
     */
    public List<AuditExecuteIndicator> findData(AuditExecuteIndicatorDto dto) {
        return this.auditExecuteIndicatorMapper.findData(dto);
    }

    public List<AuditExecuteIndicatorVo> findByActiveNumber(List<String> activeNumbers, String dockingSystem, String businessUnitCode) {
        return this.auditExecuteIndicatorMapper.findByActiveNumber(activeNumbers, dockingSystem, businessUnitCode);
    }

    /**
     * 通过唯一维度查询Id
     *
     * @param keys       唯一维度拼接编码列表
     * @param tenantCode 租户
     * @return List<AuditExecuteIndicatorOnlyKeyVo>
     */
    public List<AuditExecuteIndicatorOnlyKeyVo> findByOnlyKeys(List<List<String>> keys, String tenantCode) {
        return this.auditExecuteIndicatorMapper.findByOnlyKeys(keys, tenantCode);
    }

    public AuditExecuteIndicator findByPeopleMonth(AuditExecuteIndicatorDto indicatorDto) {
        return this.lambdaQuery()
                .eq(AuditExecuteIndicator::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditExecuteIndicator::getTenantCode, TenantUtils.getTenantCode())
                .eq(AuditExecuteIndicator::getPersonCode, indicatorDto.getPersonCode())
                .eq(AuditExecuteIndicator::getYearAndMonth, indicatorDto.getYearAndMonth()).one();
    }

    public List<AuditExecuteIndicator> findListForVariable(AuditExecuteIndicatorDto dto) {
        Validate.isTrue(StringUtils.isNotEmpty(dto.getActiveNumber())
                        || AuditExecuteIndicatorParamBuilder.otherParamsVal(dto),
                "变量查询执行指标数据，缺少必要参数！");
        return this.lambdaQuery()
                .eq(AuditExecuteIndicator::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditExecuteIndicator::getTenantCode, TenantUtils.getTenantCode())
                .eq(StringUtils.isNotEmpty(dto.getBusinessFormatCode()), AuditExecuteIndicator::getBusinessFormatCode, dto.getBusinessFormatCode())
                .eq(StringUtils.isNotEmpty(dto.getBusinessUnitCode()), AuditExecuteIndicator::getBusinessUnitCode, dto.getBusinessUnitCode())
                .eq(StringUtils.isNotEmpty(dto.getActivityTypeCode()), AuditExecuteIndicator::getActivityTypeCode, dto.getActivityTypeCode())
                .eq(StringUtils.isNotEmpty(dto.getActivityFormCode()), AuditExecuteIndicator::getActivityFormCode, dto.getActivityFormCode())
                .eq(StringUtils.isNotEmpty(dto.getActiveNumber()), AuditExecuteIndicator::getActiveNumber, dto.getActiveNumber())
                .eq(StringUtils.isNotEmpty(dto.getCustomerCode()), AuditExecuteIndicator::getCustomerCode, dto.getCustomerCode())
                .eq(StringUtils.isNotEmpty(dto.getSalesInstitutionCode()), AuditExecuteIndicator::getSalesInstitutionCode, dto.getSalesInstitutionCode())
                .eq(StringUtils.isNotEmpty(dto.getSalesRegionCode()), AuditExecuteIndicator::getSalesRegionCode, dto.getSalesRegionCode())
                .eq(StringUtils.isNotEmpty(dto.getSalesOrgCode()), AuditExecuteIndicator::getSalesOrgCode, dto.getSalesOrgCode())
                .eq(StringUtils.isNotEmpty(dto.getStoresCode()), AuditExecuteIndicator::getStoresCode, dto.getStoresCode())
                .eq(StringUtils.isNotEmpty(dto.getCustomerRetailerCode()), AuditExecuteIndicator::getCustomerRetailerCode, dto.getCustomerRetailerCode())
                .eq(StringUtils.isNotEmpty(dto.getPersonIdCard()), AuditExecuteIndicator::getPersonIdCard, dto.getPersonIdCard())
                .eq(StringUtils.isNotEmpty(dto.getFirstChannelCode()), AuditExecuteIndicator::getFirstChannelCode, dto.getFirstChannelCode())
                .eq(StringUtils.isNotEmpty(dto.getSecondChannelCode()), AuditExecuteIndicator::getSecondChannelCode, dto.getSecondChannelCode())
                .eq(StringUtils.isNotEmpty(dto.getProductBrandCode()), AuditExecuteIndicator::getProductBrandCode, dto.getProductBrandCode())
                .in(!CollectionUtils.isEmpty(dto.getProductBrandCodeList()), AuditExecuteIndicator::getProductBrandCode, dto.getProductBrandCodeList())
                .eq(StringUtils.isNotEmpty(dto.getProductCategoryCode()), AuditExecuteIndicator::getProductCategoryCode, dto.getProductCategoryCode())
                .in(!CollectionUtils.isEmpty(dto.getProductCategoryCodeList()), AuditExecuteIndicator::getProductCategoryCode, dto.getProductCategoryCodeList())
                .eq(StringUtils.isNotEmpty(dto.getProductItemCode()), AuditExecuteIndicator::getProductItemCode, dto.getProductItemCode())
                .in(!CollectionUtils.isEmpty(dto.getProductItemCodeList()), AuditExecuteIndicator::getProductItemCode, dto.getProductItemCodeList())
                .eq(StringUtils.isNotEmpty(dto.getProductCode()), AuditExecuteIndicator::getProductCode, dto.getProductCode())
                .in(!CollectionUtils.isEmpty(dto.getProductCodeList()), AuditExecuteIndicator::getProductCode, dto.getProductCodeList())
                .eq(StringUtils.isNotEmpty(dto.getHeadBudgetItemCode()), AuditExecuteIndicator::getHeadBudgetItemCode, dto.getHeadBudgetItemCode())
                .eq(StringUtils.isNotEmpty(dto.getMonthBudgetCode()), AuditExecuteIndicator::getMonthBudgetCode, dto.getMonthBudgetCode())
                .eq(StringUtils.isNotEmpty(dto.getSpecification()), AuditExecuteIndicator::getSpecification, dto.getSpecification())
                .eq(StringUtils.isNotEmpty(dto.getIsTemporary()), AuditExecuteIndicator::getIsTemporary, dto.getIsTemporary())
                .eq(Objects.nonNull(dto.getYearAndMonth()), AuditExecuteIndicator::getYearAndMonth, dto.getYearAndMonth())
                .likeRight(Objects.nonNull(dto.getYearStr()), AuditExecuteIndicator::getYearAndMonth, dto.getYearStr())
                .eq(Objects.nonNull(dto.getActivityBeginDate()), AuditExecuteIndicator::getActivityBeginDate, dto.getActivityBeginDate())
                .eq(Objects.nonNull(dto.getActivityEndDate()), AuditExecuteIndicator::getActivityEndDate, dto.getActivityEndDate())
                .eq(StringUtils.isNotEmpty(dto.getVariableCode()), AuditExecuteIndicator::getVariableCode, dto.getVariableCode())
                .eq(StringUtils.isNotEmpty(dto.getIndicatorName()), AuditExecuteIndicator::getIndicatorName,dto.getIndicatorName())
                .eq(StringUtils.isNotEmpty(dto.getDockingSystem()), AuditExecuteIndicator::getDockingSystem,dto.getDockingSystem())
                .in(!CollectionUtils.isEmpty(dto.getCustomerCodes()), AuditExecuteIndicator::getCustomerCode, dto.getCustomerCodes())
                .in(!CollectionUtils.isEmpty(dto.getStoresCodes()), AuditExecuteIndicator::getStoresCode, dto.getStoresCodes())
                .list();
    }

    /**
     * 人员工资
     *
     * @param dto 参数
     * @return List<AuditExecuteIndicatorVo>
     **/
    public List<AuditExecuteIndicator> getPersonnelWage(AuditExecuteIndicatorDto dto) {
        if (StringUtils.isEmpty(dto.getBusinessFormatCode())) {
            throw new RuntimeException("业态不能为空！");
        }
        if (StringUtils.isEmpty(dto.getBusinessUnitCode())) {
            throw new RuntimeException("业务单元不能为空！");
        }
        if (StringUtils.isEmpty(dto.getPersonCode())) {
            throw new RuntimeException("人员编码不能为空！");
        }
        if (Objects.isNull(dto.getYearAndMonth())) {
            throw new RuntimeException("年月不能为空！");
        }
        List<AuditExecuteIndicator> list = this.lambdaQuery()
                .eq(AuditExecuteIndicator::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditExecuteIndicator::getTenantCode,TenantUtils.getTenantCode())
                .eq(AuditExecuteIndicator::getBusinessFormatCode,dto.getBusinessFormatCode())
                .eq(AuditExecuteIndicator::getBusinessUnitCode,dto.getBusinessUnitCode())
                .eq(AuditExecuteIndicator::getPersonCode,dto.getPersonCode())
                .eq(AuditExecuteIndicator::getYearAndMonth,dto.getYearAndMonth())
                .eq(AuditExecuteIndicator::getIndicatorName,dto.getIndicatorName())
                .list();
        if(CollectionUtils.isEmpty(list)){
            list = new ArrayList<>();
        }
        return list;
    }

    public List<AuditExecuteIndicator> findSapDataByActiveNumbers(List<String> detailPlanItemCodes,List<String> indicatorNames) {
        return  this.lambdaQuery()
                .eq(AuditExecuteIndicator::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditExecuteIndicator::getTenantCode,TenantUtils.getTenantCode())
                .in(AuditExecuteIndicator::getActiveNumber,detailPlanItemCodes)
                .in(AuditExecuteIndicator::getIndicatorName,indicatorNames)
                .select(AuditExecuteIndicator::getActiveNumber,AuditExecuteIndicator::getIndicatorName,AuditExecuteIndicator::getIndicatorValue,
                        AuditExecuteIndicator::getBusinessFormatCode,AuditExecuteIndicator::getBusinessUnitCode)
                .list();
    }

    public List<AuditExecuteIndicatorVo> getMinusCompostQuantity(AuditExecuteIndicatorDto dto) {
        if(Objects.isNull(dto)){
            return Lists.newArrayList();
        }
        List<AuditExecuteIndicator> list = this.lambdaQuery().eq(AuditExecuteIndicator::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditExecuteIndicator::getTenantCode, TenantUtils.getTenantCode())
                .in(AuditExecuteIndicator::getActiveNumber, dto.getDetailPlanItemCodes())
                .eq(AuditExecuteIndicator::getBusinessFormatCode, dto.getBusinessFormatCode())
                .eq(AuditExecuteIndicator::getBusinessUnitCode, dto.getBusinessUnitCode())
                .eq(AuditExecuteIndicator::getDockingSystem, dto.getDockingSystem())
                .eq(AuditExecuteIndicator::getIndicatorName, dto.getIndicatorName())
                .select(AuditExecuteIndicator::getActiveNumber, AuditExecuteIndicator::getIndicatorValue)
                .list();
        if(CollectionUtils.isEmpty(list)){
            return Lists.newArrayList();
        }
        Collection<AuditExecuteIndicatorVo> auditExecuteIndicatorVos = this.nebulaToolkitService.copyCollectionByWhiteList(list, AuditExecuteIndicator.class, AuditExecuteIndicatorVo.class, LinkedHashSet.class, ArrayList.class);
        return (List<AuditExecuteIndicatorVo>) auditExecuteIndicatorVos;
    }
}
