package com.biz.crm.tpm.business.variable.local.executeIndicator.service.internal;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditDetailEventDto;
import com.biz.crm.tpm.business.audit.sdk.service.AuditExecuteIndicatorListener;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditDetailResponse;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditDetailResponseData;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorSdkVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import org.springframework.util.ObjectUtils;

import java.util.*;


@Slf4j
@Service("auditExecuteIndicatorListener")
public class AuditExecuteIndicatorListenerImpl implements AuditExecuteIndicatorListener {
    @Autowired(required = false)
    private AuditExecuteIndicatorService auditExecuteIndicatorService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;


    @Override
    public AuditDetailResponse findSapDataByConditions(AuditDetailEventDto dto) {
        AuditDetailResponse auditDetailResponse = new AuditDetailResponse();
        if (ObjectUtils.isEmpty(dto) || CollectionUtils.isEmpty(dto.getDetailPlanItemCodes()) || CollectionUtils.isEmpty(dto.getIndicatorNames())) {
            return auditDetailResponse;
        }
        List<AuditExecuteIndicatorSdkVo> auditExecuteIndicatorSdkVos = auditExecuteIndicatorService.findSapDataByActiveNumbers(dto.getDetailPlanItemCodes(),dto.getIndicatorNames());
        if (CollectionUtils.isEmpty(auditExecuteIndicatorSdkVos)){
            return auditDetailResponse;
        }
        List<AuditDetailResponseData> detailResponseDataList = (List<AuditDetailResponseData>) nebulaToolkitService.copyCollectionByWhiteList(auditExecuteIndicatorSdkVos, AuditExecuteIndicatorSdkVo.class, AuditDetailResponseData.class, HashSet.class, ArrayList.class);
        auditDetailResponse.setAuditDetailResponseDataList(detailResponseDataList);
        return auditDetailResponse;
    }
}