package com.biz.crm.tpm.business.variable.local.executeIndicator.service.internal;

import com.biz.crm.tpm.business.variable.local.executeIndicator.service.AuditExecuteIndicatorLogService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorLogEventDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.log.AuditExecuteIndicatorEventListener;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author: chenlong
 * @date: 2023/2/25 15:54
 * @description: 批量日志异步服务实现类
 */
@Service("AuditExecuteIndicatorLogService")
public class AuditExecuteIndicatorLogServiceImpl implements AuditExecuteIndicatorLogService {

    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Async
    @Override
    public void addLogAsync(List<AuditExecuteIndicatorDto> addList) {
        SerializableBiConsumer<AuditExecuteIndicatorEventListener, AuditExecuteIndicatorLogEventDto> onCreate =
                AuditExecuteIndicatorEventListener::onCreate;
        for (AuditExecuteIndicatorDto in : addList) {
            //新增业务日志
            AuditExecuteIndicatorLogEventDto logEventDto = new AuditExecuteIndicatorLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(in);
            this.nebulaNetEventClient.publish(logEventDto, AuditExecuteIndicatorEventListener.class, onCreate);
        }
    }

    @Override
    public void updateLogAsync(List<AuditExecuteIndicatorLogEventDto> editLogs) {
        SerializableBiConsumer<AuditExecuteIndicatorEventListener, AuditExecuteIndicatorLogEventDto> onUpdate =
                AuditExecuteIndicatorEventListener::onUpdate;
        for (AuditExecuteIndicatorLogEventDto log : editLogs) {
            this.nebulaNetEventClient.publish(log, AuditExecuteIndicatorEventListener.class, onUpdate);
        }
    }
}
