package com.biz.crm.tpm.business.variable.local.executeIndicator.service.internal;

import com.alibaba.excel.util.Validate;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.retailer.sdk.service.CustomerRetailerVoService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.product.brand.sdk.service.ProductBrandService;
import com.biz.crm.mdm.business.product.brand.sdk.vo.ProductBrandVo;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanItemService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.service.SubComActivityDesignDetailService;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignDetailVo;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.constant.AuditExecuteIndicatorConstant;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorSapImportVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * @author: hd
 * @description: 结案核销-执行指标表(AuditExecuteIndicator)导入实现层
 */
@Slf4j
@Component
public class AuditExecuteIndicatorSapImportProcess implements ImportProcess<AuditExecuteIndicatorSapImportVo> {

    @Autowired(required = false)
    private AuditExecuteIndicatorService auditExecuteIndicatorService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private DictToolkitService dictToolkitService;
    @Autowired(required = false)
    private CustomerVoService customerVoService;
    @Autowired(required = false)
    private ProductVoService productVoService;
    @Autowired(required = false)
    private CustomerRetailerVoService customerRetailerVoService;
    @Autowired(required = false)
    private ProductBrandService productBrandService;
    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required = false)
    private ProductLevelVoSdkService productLevelVoSdkService;
    @Autowired(required = false)
    private ActivityDetailPlanItemService activityDetailPlanItemService;
    @Autowired(required = false)
    private SubComActivityDesignDetailService subComActivityDesignDetailService;

    @Override
    public Integer getBatchCount() {
        return 5000;
    }

    /**
     * 是否开启先校验后导入的模式 默认false: false执行旧逻辑 true执行新逻辑(先校验再保存) <br/>
     * 新逻辑需同时实现接口 tryVerify tryConfirm（默认方法调用execute）
     *
     * @return
     */
    @Override
    public boolean importBeforeValidationFlag() {
        return Boolean.TRUE;
    }


    /**
     * 数据校验
     *
     * @param data     待处理的数据集合，k-流水号，v-excel解析后的对象
     * @param paramsVo 任务公共参数
     * @param params   导入任务自定义参数
     * @return k-对应data的k，v-对应data的k对应的v处理异常描述信息，会回写到错误文件
     */
    @Override
    public Map<Integer, String> tryVerify(LinkedHashMap<Integer, AuditExecuteIndicatorSapImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Map<Integer, String> errMap = new HashMap<>();
        for (Map.Entry<Integer, AuditExecuteIndicatorSapImportVo>  row : data.entrySet()) {
            int rowNum = row.getKey();
            AuditExecuteIndicatorSapImportVo vo = row.getValue();

            this.validateIsTrue(StringUtils.isNotBlank(vo.getBusinessFormatCode()), "业态不能为空!");
            this.validateIsTrue(StringUtils.isNotBlank(vo.getBusinessUnitCode()), "业务单元不能为空!");
            this.validateIsTrue(StringUtils.isNotBlank(vo.getYearAndMonthStr()), "年月不能为空!");
            this.validateIsTrue(StringUtils.isNotBlank(vo.getIndicatorName()), "执行指标名称不能为空!");
            this.validateIsTrue(vo.getIndicatorValue() != null, "指标值不能为空!");

            String errInfo = this.validateGetErrorInfo();
            if (errInfo != null) {
                errMap.put(rowNum, errInfo);
            }
        }
        return errMap;
    }

    /**
     * 数据处理
     *
     * @param data     待处理的数据集合，k-流水号，v-excel解析后的对象
     * @param paramsVo 任务公共参数
     * @param params   导入任务自定义参数
     * @return k-对应data的k，v-对应data的k对应的v处理异常描述信息，会回写到错误文件
     */
    @Override
    public Map<Integer, String> execute(LinkedHashMap<Integer, AuditExecuteIndicatorSapImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Validate.notNull(data, "导入数据不能为空！");
        Map<Integer, String> errMap = new HashMap<>();
        log.error("执行指标导入第一步");
        Map<Integer,String> resultErrorMap = new HashMap<>();
        List<AuditExecuteIndicatorDto> importList = this.validate(data, resultErrorMap);
        if (!resultErrorMap.isEmpty()) {
            return resultErrorMap;
        }
        //大批量保存
        auditExecuteIndicatorService.bulkImportSave(importList);
        log.error("执行指标导入第二步");
        return null;
    }

    /**
     * 校验数据
     *
     * @param data data
     **/
    private List<AuditExecuteIndicatorDto> validate(LinkedHashMap<Integer, AuditExecuteIndicatorSapImportVo> data, Map<Integer,String> resultErrorMap) {
        List<AuditExecuteIndicatorSapImportVo> importList = new ArrayList<>(data.values());

        //获取业态字典
        Map<String, String> formatMap = dictToolkitService.findConvertMapByDictTypeCode(AuditExecuteIndicatorConstant.AUDIT_EXECUTE_BUSINESS_FORMAT);
        //获取业务单元字典
        Map<String, String> unitMap = dictToolkitService.findConvertMapByDictTypeCode(AuditExecuteIndicatorConstant.AUDIT_EXECUTE_BUSINESS_UNIT);
        // MDM_CUSTOMIZE_ORG编码  大区数据字典
        Map<String, String> regionMap = dictToolkitService.findConvertMapByDictTypeCode(AuditExecuteIndicatorConstant.MDM_CUSTOMIZE_ORG);
        Validate.isTrue(ObjectUtils.isNotEmpty(regionMap), "未查询到零售商区域数据字典!");
        Map<String, String> indicatorsMap = dictToolkitService.findConvertMapByDictTypeCode(AuditExecuteIndicatorConstant.TPM_IMPLEMENTATION_INDICATORS);
        Validate.isTrue(ObjectUtils.isNotEmpty(indicatorsMap), "未查询到执行指标数据字典!");
        int i = 1;
        for (AuditExecuteIndicatorSapImportVo item : importList) {
            i++;
            try {
                this.validateData(item, formatMap, unitMap, regionMap, indicatorsMap,resultErrorMap,i);
            } catch (Exception e) {
                log.error(e.getMessage(),e);
                String msg = "第【"+ i +"】行错误，错误信息为：" + e.getMessage();
                resultErrorMap.put(i, msg);
                return new ArrayList<>();
            }
        }
        Collection<AuditExecuteIndicatorDto> dtoList = nebulaToolkitService.copyCollectionByWhiteList(importList, AuditExecuteIndicatorSapImportVo.class, AuditExecuteIndicatorDto.class, LinkedHashSet.class, ArrayList.class);
        return new ArrayList<>(dtoList);
    }


    /**
     * 校验数据
     *
     * @param dto       导入数据
     * @param formatMap 业态map
     * @param unitMap   业务单元map
     **/
    private void validateData(AuditExecuteIndicatorSapImportVo dto, Map<String, String> formatMap, Map<String, String> unitMap,
                              Map<String, String> regionMap, Map<String, String> indicatorsMap, Map<Integer, String> errMap, Integer rowNum) {

        String employeeCode = indicatorsMap.get(dto.getIndicatorName());
        Validate.isTrue(StringUtils.isNotBlank(employeeCode), "执行指标名称:" + dto.getIndicatorName() + "未匹配到执行指标编码!");
        dto.setIndicatorName(employeeCode);
        String salesInstitutionCode = dto.getSalesInstitutionCode();
        if (StringUtils.isNotBlank(salesInstitutionCode)) {
            SalesOrgVo salesOrgVo = salesOrgVoService.findBySalesOrgCode(salesInstitutionCode);
            if (salesOrgVo != null) {
                dto.setSalesInstitutionName(salesOrgVo.getSalesOrgName());
            } else {
                validateIsTrue(false, "销售机构编码" + salesInstitutionCode + "未匹配到，请检查！");
            }
        }
        String customerCode = dto.getCustomerCode();
        if (StringUtils.isNotEmpty(customerCode) && StringUtils.isEmpty(dto.getCustomerName())) {
            List<String> codes = new ArrayList<>(1);
            codes.add(customerCode);
            List<CustomerVo> baseByCustomerCodes = customerVoService.findBaseByCustomerCodes(codes);
            if (CollectionUtils.isNotEmpty(baseByCustomerCodes) && baseByCustomerCodes.size() > 0) {
                dto.setCustomerName(baseByCustomerCodes.get(0).getCustomerName());
            } else {
                validateIsTrue(false, "客户编码" + customerCode + "为匹配到，请检查！");
            }
        }
        String regionName = dto.getRegionName();
        if (StringUtils.isNotEmpty(regionName)) {
            String regionCode = regionMap.get(regionName);
            if (StringUtils.isNotBlank(regionCode)) {
                dto.setRegionCode(regionCode);
            } else {
                validateIsTrue(false, "所属大区名称:" + regionName + "未匹配到所属大区编码!");
            }
        }
        String retailerName = dto.getCustomerRetailerName();
        if (StringUtils.isNotBlank(retailerName)) {
            List<String> customerRetailerVoList = customerRetailerVoService.findByName(retailerName);
            if (CollectionUtils.isNotEmpty(customerRetailerVoList)) {
                if (customerRetailerVoList.size() == 1) {
                    dto.setCustomerRetailerCode(customerRetailerVoList.get(0));
                } else {
                    validateIsTrue(false,  "所属零售商名称:" + regionName + "匹配到所属零售商编码不止一个!");
                }
            } else {
                validateIsTrue(false, "所属零售商名称:" + regionName + "未匹配到所属零售商编码!");
            }
        }
        if (formatMap.containsKey(dto.getBusinessFormatCode())) {
            dto.setBusinessFormatCode(formatMap.get(dto.getBusinessFormatCode()));
        } else {
            validateIsTrue(false, "业态未能识别");
        }
        if (unitMap.containsKey(dto.getBusinessUnitCode())) {
            dto.setBusinessUnitCode(unitMap.get(dto.getBusinessUnitCode()));
        } else {
            validateIsTrue(false, "业务单元未能识别");
        }
        try {
            dto.setYearAndMonth(DateUtil.date_yyyy_MM.parse(dto.getYearAndMonthStr()));
        } catch (Exception e) {
            validateIsTrue(false, "年月格式错误【yyyy-MM】");
        }
        dto.setDockingSystem(AuditExecuteIndicatorConstant.SAP);
        String productBrandCode = dto.getProductBrandCode();
        String productCategoryCode = dto.getProductCategoryCode();
        String productItemCode = dto.getProductItemCode();
        String productCode = dto.getProductCode();
        if (StringUtils.isNotBlank(productBrandCode)) {
            List<String> productBrandCodes = new ArrayList<>(1);
            productBrandCodes.add(productBrandCode);
            List<ProductBrandVo> productBrandVos = productBrandService.listByCodes(productBrandCodes);
            if (CollectionUtils.isNotEmpty(productBrandVos) && productBrandVos.size() > 0) {
                dto.setProductName(productBrandVos.get(0).getProductBrandName());
            } else {
                validateIsTrue(false, "品牌编码" + productBrandCode + "未匹配到，请检查！");
            }
        }
        if (StringUtils.isNotBlank(productCategoryCode)) {
            List<String> productCategoryCodes = new ArrayList<>(1);
            productCategoryCodes.add(productCategoryCode);
            List<ProductLevelVo> listByCodes = productLevelVoSdkService.findListByCodes(productCategoryCodes);
            if (CollectionUtils.isNotEmpty(listByCodes) && listByCodes.size() > 0) {
                dto.setProductCategoryName(listByCodes.get(0).getProductLevelName());
            } else {
                validateIsTrue(false,  "品类编码" + productCategoryCode + "未匹配到，请检查！");
            }
        }
        if (StringUtils.isNotBlank(productItemCode)) {
            List<String> productItemCodes = new ArrayList<>(1);
            productItemCodes.add(productCategoryCode);
            List<ProductLevelVo> listByProductItemCodes = productLevelVoSdkService.findListByCodes(productItemCodes);
            if (CollectionUtils.isNotEmpty(listByProductItemCodes) && listByProductItemCodes.size() > 0) {
                dto.setProductCategoryName(listByProductItemCodes.get(0).getProductLevelName());
            } else {
                validateIsTrue(false,  "品类编码" + productCategoryCode + "未匹配到，请检查！");
            }
        }
        if (StringUtils.isNotBlank(productCode)) {
            List<String> productCodes = new ArrayList<>(1);
            productCodes.add(productCode);
            List<ProductVo> byProductCodes = productVoService.findByCodes(productCodes);
            if (CollectionUtils.isNotEmpty(byProductCodes) && byProductCodes.size() > 0) {
                dto.setProductName(byProductCodes.get(0).getProductName());
            } else {
                validateIsTrue(false, "产品编码" + productCode + "未匹配到，请检查！");
            }
        }
        if (StringUtils.isNotBlank(dto.getActiveNumber())) {
            //区分活动细案和分子活动规划
            if (dto.getActiveNumber().startsWith("P")) {
                List<String> itemCodes = new ArrayList<>(1);
                itemCodes.add(dto.getActiveNumber());
                List<SubComActivityDesignDetailVo> itemList = subComActivityDesignDetailService.findDetailByDetailCodes(itemCodes);
                if (CollectionUtils.isNotEmpty(itemList) && itemList.size() > 0) {
                    SubComActivityDesignDetailVo itemVo = itemList.get(0);
                    if (StringUtils.isBlank(dto.getSalesInstitutionCode())) {
                        dto.setSalesInstitutionCode(itemVo.getSalesInstitutionCode());
                        dto.setSalesInstitutionName(itemVo.getSalesInstitutionName());
                        dto.setSalesRegionCode(itemVo.getSalesOrgCode());
                        dto.setSalesRegionName(itemVo.getSalesOrgName());
                        dto.setSalesOrgCode(itemVo.getSalesGroupCode());
                        dto.setSalesOrgName(itemVo.getSalesGroupName());
                    }
                    dto.setChannelCode(itemVo.getDistributionChannelCode());
                    dto.setChannelName(itemVo.getDistributionChannelName());
                    if (StringUtils.isNotBlank(dto.getCustomerCode())) {
                        dto.setCustomerCode(itemVo.getCustomerCode());
                        dto.setCustomerName(itemVo.getCustomerName());
                    }
                    dto.setStoresCode(itemVo.getTerminalCode());
                    dto.setStoresName(itemVo.getTerminalName());
                    dto.setPersonnelType(itemVo.getPersonType());
                    dto.setPersonnelId(itemVo.getPersonCode());
                    try {
                        dto.setActivityBeginDate(DateUtil.dateToStr(DateUtil.date_yyyy_MM_dd, itemVo.getActivityBeginTime()));
                        dto.setActivityEndDate(DateUtil.dateToStr(DateUtil.date_yyyy_MM_dd, itemVo.getActivityEndTime()));
                    } catch (Exception e) {
                        log.error("", e);
                    }
                    if (StringUtils.isBlank(dto.getProductBrandCode())) {
                        dto.setProductBrandCode(itemVo.getProductBrandCode());
                        dto.setProductBrandName(itemVo.getProductBrandName());
                    }
                    if (StringUtils.isBlank(dto.getProductCategoryCode())) {
                        dto.setProductCategoryCode(itemVo.getProductCategoryCode());
                        dto.setProductCategoryName(itemVo.getProductCategoryName());
                    }
                    if (StringUtils.isBlank(dto.getProductItemCode())) {
                        dto.setProductItemCode(itemVo.getProductItemCode());
                        dto.setProductItemName(itemVo.getProductItemName());
                    }
                    if (StringUtils.isBlank(dto.getProductCode())) {
                        dto.setProductCode(itemVo.getProductCode());
                        dto.setProductName(itemVo.getProductName());
                    }
                    dto.setActivityFormCode(itemVo.getActivityFormCode());
                    dto.setActivityFormName(itemVo.getActivityFormName());
                    dto.setActivityTypeCode(itemVo.getActivityTypeCode());
                    dto.setActivityTypeName(itemVo.getActivityTypeName());
                } else {
                    validateIsTrue(false, "活动细案编码" + dto.getActiveNumber() + "未匹配到分子活动规划明细，请检查！");
                }
            } else if (dto.getActiveNumber().startsWith("Z")) {
                List<String> itemCodes = new ArrayList<>(1);
                itemCodes.add(dto.getActiveNumber());
                List<ActivityDetailPlanItemVo> itemList = activityDetailPlanItemService.findByItemCodes(itemCodes);
                if (CollectionUtils.isNotEmpty(itemList) && itemList.size() > 0) {
                    ActivityDetailPlanItemVo itemVo = itemList.get(0);
                    if (StringUtils.isBlank(dto.getSalesInstitutionCode())) {
                        dto.setSalesInstitutionCode(itemVo.getSalesInstitutionCode());
                        dto.setSalesInstitutionName(itemVo.getSalesInstitutionName());
                        dto.setSalesRegionCode(itemVo.getSalesRegionCode());
                        dto.setSalesRegionName(itemVo.getSalesRegionName());
                        dto.setSalesOrgCode(itemVo.getSalesOrgCode());
                        dto.setSalesOrgName(itemVo.getSalesOrgName());
                    }
                    dto.setChannelCode(itemVo.getDistributionChannelCode());
                    dto.setChannelName(itemVo.getDistributionChannelName());
                    if (StringUtils.isNotBlank(dto.getCustomerCode())) {
                        dto.setCustomerCode(itemVo.getCustomerCode());
                        dto.setCustomerName(itemVo.getCustomerName());
                    }
                    dto.setStoresCode(itemVo.getTerminalCode());
                    dto.setStoresName(itemVo.getTerminalName());
                    dto.setPersonnelType(itemVo.getPersonType());
                    dto.setPersonnelId(itemVo.getPersonCode());
                    try {
                        dto.setActivityBeginDate(DateUtil.dateToStr(DateUtil.date_yyyy_MM_dd, itemVo.getActivityBeginDate()));
                        dto.setActivityEndDate(DateUtil.dateToStr(DateUtil.date_yyyy_MM_dd, itemVo.getActivityEndDate()));
                    } catch (Exception e) {
                        log.error("", e);
                    }
                    if (StringUtils.isBlank(dto.getProductBrandCode())) {
                        dto.setProductBrandCode(itemVo.getProductBrandCode());
                        dto.setProductBrandName(itemVo.getProductBrandName());
                    }
                    if (StringUtils.isBlank(dto.getProductCategoryCode())) {
                        dto.setProductCategoryCode(itemVo.getProductCategoryCode());
                        dto.setProductCategoryName(itemVo.getProductCategoryName());
                    }
                    if (StringUtils.isBlank(dto.getProductItemCode())) {
                        dto.setProductItemCode(itemVo.getProductItemCode());
                        dto.setProductItemName(itemVo.getProductItemName());
                    }
                    if (StringUtils.isBlank(dto.getProductCode())) {
                        dto.setProductCode(itemVo.getProductCode());
                        dto.setProductName(itemVo.getProductName());
                    }
                    dto.setActivityFormCode(itemVo.getActivityFormCode());
                    dto.setActivityFormName(itemVo.getActivityFormName());
                    dto.setActivityTypeCode(itemVo.getActivityTypeCode());
                    dto.setActivityTypeName(itemVo.getActivityTypeName());
                } else {
                    validateIsTrue(false,  "活动细案编码" + dto.getActiveNumber() + "未匹配到细案明细，请检查！");
                }
            }
        }
        String errInfo = this.validateGetErrorInfo();
        if (errInfo != null) {
            errMap.put(rowNum, errInfo);
        }
    }


    /**
     * 获取数据实体
     *
     * @return Class<AuditExecuteIndicatorImportVo>
     */
    @Override
    public Class<AuditExecuteIndicatorSapImportVo> findCrmExcelVoClass() {
        return AuditExecuteIndicatorSapImportVo.class;
    }

    /**
     * 获取业务编码
     *
     * @return String
     */
    @Override
    public String getBusinessCode() {
        return "TPM_AUDIT_EXECUTE_INDICATOR_IMPORT";
    }

    /**
     * 获取业务名称
     *
     * @return String
     */
    @Override
    public String getBusinessName() {
        return "TPM-结案核销执行指标表";
    }

    /**
     * 获取数据实体
     *
     * @return String
     */
    @Override
    public String getTemplateCode() {
        return "TPM_AUDIT_EXECUTE_INDICATOR_SAP_IMPORT";
    }

    /**
     * 获取业务对应的模板描述
     *
     * @return String
     */
    @Override
    public String getTemplateName() {
        return "TPM-结案核销执行指标表-SAP发生";
    }
}
