package com.biz.crm.tpm.business.variable.local.executeIndicator.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.variable.local.executeIndicator.entity.AuditExecuteIndicator;
import com.biz.crm.tpm.business.variable.local.executeIndicator.repository.AuditExecuteIndicatorRepository;
import com.biz.crm.tpm.business.variable.local.executeIndicator.service.AuditExecuteIndicatorLogService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.constant.AuditExecuteIndicatorConstant;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorLogEventDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.enums.IndicatorNameEnum;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.log.AuditExecuteIndicatorEventListener;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.SapActivityExecution;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorOnlyKeyVo;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorSdkVo;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author: chenlong
 * @date: 2022/11/14 19:33
 * @description:
 */
@Slf4j
@Service("auditExecuteIndicatorService")
public class AuditExecuteIndicatorServiceImpl implements AuditExecuteIndicatorService {

    @Autowired(required = false)
    private AuditExecuteIndicatorRepository auditExecuteIndicatorRepository;
    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required = false)
    private GenerateCodeService generateCodeService;
    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required = false)
    private LoginUserService loginUserService;
    @Autowired(required = false)
    private SapActivityExecution sapActivityExecution;
    @Autowired(required = false)
    private AuditExecuteIndicatorLogService auditExecuteIndicatorLogService;
    @Autowired(required = false)
    private DictToolkitService dictToolkitService;

    /**
     * 分页查询所有数据
     *
     * @param pageable                 分页对象
     * @param auditExecuteIndicatorDto 查询dto
     * @return 所有数据
     */
    @Override
    public Page<AuditExecuteIndicatorVo> findByConditions(Pageable pageable, AuditExecuteIndicatorDto auditExecuteIndicatorDto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(auditExecuteIndicatorDto)) {
            auditExecuteIndicatorDto = new AuditExecuteIndicatorDto();
        }
        return this.auditExecuteIndicatorRepository.findByConditions(pageable, auditExecuteIndicatorDto);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @Override
    public AuditExecuteIndicatorVo findById(String id) {
        if (StringUtils.isBlank(id)) {
            return null;
        }
        AuditExecuteIndicator invoice = this.auditExecuteIndicatorRepository.lambdaQuery()
                .eq(AuditExecuteIndicator::getId, id)
                .eq(AuditExecuteIndicator::getTenantCode, TenantUtils.getTenantCode())
                .eq(AuditExecuteIndicator::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .one();
        if (null == invoice) {
            return null;
        }
        return this.nebulaToolkitService.copyObjectByWhiteList(invoice, AuditExecuteIndicatorVo.class, null, null);
    }

    /**
     * 修改数据
     *
     * @param dto dto对象
     * @return 修改结果
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void update(AuditExecuteIndicatorDto dto) {
        this.updateValidate(dto);
        //获取历史vo
        AuditExecuteIndicatorVo oldVo = this.findById(dto.getId());
        Validate.notNull(oldVo, "未查找到指标数据");

        AuditExecuteIndicator indicator = nebulaToolkitService.copyObjectByWhiteList(dto, AuditExecuteIndicator.class, null, null);
        this.auditExecuteIndicatorRepository.updateByIdAndTenantCode(indicator, TenantUtils.getTenantCode());

        //修改业务日志
        AuditExecuteIndicatorLogEventDto logEventDto = new AuditExecuteIndicatorLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(dto);
        SerializableBiConsumer<AuditExecuteIndicatorEventListener, AuditExecuteIndicatorLogEventDto> onUpdate =
                AuditExecuteIndicatorEventListener::onUpdate;
        this.nebulaNetEventClient.publish(logEventDto, AuditExecuteIndicatorEventListener.class, onUpdate);
    }

    /**
     * 编辑验证
     *
     * @param dto dto对象
     */
    private void updateValidate(AuditExecuteIndicatorDto dto) {
        Validate.notNull(dto, "编辑时，对象信息不能为空！");
        Validate.notBlank(dto.getId(), "编辑数据时，id不能为空！");
        Validate.notBlank(dto.getBusinessFormatCode(), "编辑数据时，业态不能为空！");
        Validate.notBlank(dto.getBusinessUnitCode(), "编辑数据时，业务单元不能为空！");
        Validate.notNull(dto.getYearAndMonth(), "编辑数据时，年月不能为空！");
        Validate.notBlank(dto.getCustomerCode(), "编辑数据时，客户编码不能为空！");
        Validate.notBlank(dto.getCustomerName(), "编辑数据时，客户名称不能为空！");
        Validate.notBlank(dto.getSalesOrgCode(), "编辑数据时，销售组织编码不能为空！");
        Validate.notBlank(dto.getSalesOrgName(), "编辑数据时，销售组织名称不能为空！");
        Validate.notBlank(dto.getChannelCode(), "编辑数据时，渠道编码不能为空！");
        Validate.notBlank(dto.getChannelName(), "编辑数据时，渠道名称不能为空！");
        if (StringUtils.isBlank(dto.getStoresCode())) {
            dto.setStoresCode("");
        }
        if (StringUtils.isBlank(dto.getStoresName())) {
            dto.setStoresName("");
        }
        Validate.notBlank(dto.getIndicatorCode(), "编辑数据时，指标编码不能为空！");
        Validate.notBlank(dto.getIndicatorName(), "编辑数据时，指标名称不能为空！");
        Validate.notNull(dto.getIndicatorValue(), "编辑数据时，指标值不能为空！");
    }

    /**
     * 删除数据
     *
     * @param idList 主键结合
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void delete(List<String> idList) {
        Validate.isTrue(!CollectionUtils.isEmpty(idList), "删除数据时，主键集合不能为空！");
        List<AuditExecuteIndicator> rulesList = this.auditExecuteIndicatorRepository.listByIds(idList);
        ArrayList<AuditExecuteIndicator> executeIndicators = new ArrayList<>();
        rulesList.forEach(item -> {
            AuditExecuteIndicator indicator = new AuditExecuteIndicator();
            indicator.setId(item.getId());
            indicator.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            executeIndicators.add(indicator);


            //删除业务日志
            AuditExecuteIndicatorLogEventDto logEventDto = new AuditExecuteIndicatorLogEventDto();
            AuditExecuteIndicatorVo oldVo = this.nebulaToolkitService.copyObjectByWhiteList(item, AuditExecuteIndicatorVo.class, null, null);
            logEventDto.setOriginal(oldVo);
            AuditExecuteIndicatorDto newDto = this.nebulaToolkitService.copyObjectByWhiteList(item, AuditExecuteIndicatorDto.class, null, null);
            newDto.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            logEventDto.setNewest(newDto);
            SerializableBiConsumer<AuditExecuteIndicatorEventListener, AuditExecuteIndicatorLogEventDto> onDelete =
                    AuditExecuteIndicatorEventListener::onDelete;
            this.nebulaNetEventClient.publish(logEventDto, AuditExecuteIndicatorEventListener.class, onDelete);
        });
        this.auditExecuteIndicatorRepository.updateBatchById(executeIndicators);
    }

    /**
     * 启用
     *
     * @param ids 主键列表
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void enableBatch(List<String> ids) {
        Validate.isTrue(!CollectionUtils.isEmpty(ids), "请选择要操作的数据");
        List<AuditExecuteIndicator> activityApplyRuless = this.auditExecuteIndicatorRepository.listByIds(ids);
        Validate.isTrue(!CollectionUtils.isEmpty(activityApplyRuless), "不存在或已删除!");

        ArrayList<AuditExecuteIndicator> executeIndicators = new ArrayList<>();
        activityApplyRuless.forEach(item -> {
            AuditExecuteIndicator indicator = new AuditExecuteIndicator();
            indicator.setId(item.getId());
            indicator.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            executeIndicators.add(indicator);

            //禁用业务日志
            AuditExecuteIndicatorLogEventDto logEventDto = new AuditExecuteIndicatorLogEventDto();
            AuditExecuteIndicatorVo oldVo = this.nebulaToolkitService.copyObjectByWhiteList(item, AuditExecuteIndicatorVo.class, null, null);
            logEventDto.setOriginal(oldVo);
            AuditExecuteIndicatorDto newDto = this.nebulaToolkitService.copyObjectByWhiteList(item, AuditExecuteIndicatorDto.class, null, null);
            newDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            logEventDto.setNewest(newDto);
            SerializableBiConsumer<AuditExecuteIndicatorEventListener, AuditExecuteIndicatorLogEventDto> onEnable =
                    AuditExecuteIndicatorEventListener::onEnable;
            this.nebulaNetEventClient.publish(logEventDto, AuditExecuteIndicatorEventListener.class, onEnable);
        });
        this.auditExecuteIndicatorRepository.updateBatchById(executeIndicators);
    }

    /**
     * 禁用
     *
     * @param ids 主键列表
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void disableBatch(List<String> ids) {
        Validate.isTrue(!CollectionUtils.isEmpty(ids), "请选择要操作的数据");
        List<AuditExecuteIndicator> activityApplyRuless = this.auditExecuteIndicatorRepository.listByIds(ids);
        Validate.isTrue(!CollectionUtils.isEmpty(activityApplyRuless), "不存在或已删除!");

        ArrayList<AuditExecuteIndicator> executeIndicators = new ArrayList<>();
        activityApplyRuless.forEach(item -> {
            AuditExecuteIndicator indicator = new AuditExecuteIndicator();
            indicator.setId(item.getId());
            indicator.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            executeIndicators.add(indicator);

            //禁用业务日志
            AuditExecuteIndicatorLogEventDto logEventDto = new AuditExecuteIndicatorLogEventDto();
            AuditExecuteIndicatorVo oldVo = this.nebulaToolkitService.copyObjectByWhiteList(item, AuditExecuteIndicatorVo.class, null, null);
            logEventDto.setOriginal(oldVo);
            AuditExecuteIndicatorDto newDto = this.nebulaToolkitService.copyObjectByWhiteList(item, AuditExecuteIndicatorDto.class, null, null);
            newDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            logEventDto.setNewest(newDto);
            SerializableBiConsumer<AuditExecuteIndicatorEventListener, AuditExecuteIndicatorLogEventDto> onDisable =
                    AuditExecuteIndicatorEventListener::onDisable;
            this.nebulaNetEventClient.publish(logEventDto, AuditExecuteIndicatorEventListener.class, onDisable);
        });
        this.auditExecuteIndicatorRepository.updateBatchById(executeIndicators);
    }

    /**
     * 大批量保存
     *
     * @param importList 导入数据列表
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void bulkImportSave(List<AuditExecuteIndicatorDto> importList) {
        try {
            if (CollectionUtils.isEmpty(importList)) {
                return;
            }
            //设置基础信息
            AbstractCrmUserIdentity loginDetails = this.loginUserService.getAbstractLoginUser();
            Date date = new Date();
            //循环设置信息并区分编辑和新增数据
            List<AuditExecuteIndicatorDto> addList = new ArrayList<>();
            List<AuditExecuteIndicatorDto> editList = new ArrayList<>();
            for (AuditExecuteIndicatorDto dto : importList) {
                if (StringUtils.isNotBlank(dto.getId())) {
                    dto.setModifyAccount(loginDetails.getUsername());
                    dto.setModifyName(loginDetails.getRealName());
                    dto.setModifyTime(date);
                    editList.add(dto);
                } else {
                    dto.setCreateAccount(loginDetails.getUsername());
                    dto.setCreateName(loginDetails.getRealName());
                    dto.setCreateTime(date);
                    dto.setTenantCode(loginDetails.getTenantCode());
                    dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                    addList.add(dto);
                }
            }
            //新增数据
            if (!CollectionUtils.isEmpty(addList)) {
                log.info("开始执行大批量保存-----------------新增数据条数：{}", addList.size());
//                String ruleCode = StringUtils.join(AuditExecuteIndicatorConstant.AUDIT_EXECUTE_INDICATOR_PREFIX, DateFormatUtils.format(new Date(), DateUtil.DEFAULT_YEAR_MONTH_DAY_NO_CH));
                List<String> codes = this.generateCodeService.generateCode(AuditExecuteIndicatorConstant.AUDIT_EXECUTE_INDICATOR_PREFIX, addList.size(), 5, 2, TimeUnit.DAYS);
                for (int i = 0; i < addList.size(); i++) {
                    AuditExecuteIndicatorDto inDto = addList.get(i);
                    inDto.setIndicatorCode(codes.get(i));
                }
                addList.forEach(a->a.setIndicatorValue(Optional.ofNullable(a.getIndicatorValue()).orElse(BigDecimal.ZERO)));
                Collection<AuditExecuteIndicator> adds = this.nebulaToolkitService.copyCollectionByWhiteList(
                        addList, AuditExecuteIndicatorDto.class, AuditExecuteIndicator.class, LinkedHashSet.class, ArrayList.class);
                List<AuditExecuteIndicator> rateList = (List<AuditExecuteIndicator>) adds;
                //分批保存
                int partialLimit = 500;
                int size = rateList.size();
                if (partialLimit < size) {
                    int start = 0;
                    for (; size > 0; ) {
                        if (size < partialLimit) {
                            partialLimit = size;
                        }
                        List<AuditExecuteIndicator> partList = rateList.subList(start, partialLimit);
                        size -= partialLimit;
                        this.auditExecuteIndicatorRepository.bulkSave(partList);
                        partList.clear();
                    }
                }else {
                    this.auditExecuteIndicatorRepository.bulkSave(rateList);
                }
                rateList.clear();
            }
            //更新数据
            List<AuditExecuteIndicatorLogEventDto> editLogs = new ArrayList<>();
            if (!CollectionUtils.isEmpty(editList)) {
                log.info("开始执行大批量保存-----------------编辑数据条数：{}", editList.size());
                //分批保存
                List<List<AuditExecuteIndicatorDto>> rates = Lists.partition(editList, 500);
                for (List<AuditExecuteIndicatorDto> list : rates) {
                    List<String> ids = list.stream().map(AuditExecuteIndicatorDto::getId).collect(Collectors.toList());
                    List<AuditExecuteIndicator> oldList = this.auditExecuteIndicatorRepository.lambdaQuery()
                            .in(AuditExecuteIndicator::getId, ids)
                            .eq(AuditExecuteIndicator::getTenantCode, TenantUtils.getTenantCode())
                            .list();
                    Collection<AuditExecuteIndicatorVo> oldDtoList = this.nebulaToolkitService.copyCollectionByWhiteList(
                            oldList, AuditExecuteIndicator.class, AuditExecuteIndicatorVo.class, LinkedHashSet.class, ArrayList.class);
                    Map<String, AuditExecuteIndicatorVo> oldMap = oldDtoList.stream().collect(Collectors.toMap(AuditExecuteIndicatorVo::getId, Function.identity()));
                    for (AuditExecuteIndicatorDto dto : list) {
                        AuditExecuteIndicatorLogEventDto eventDto = new AuditExecuteIndicatorLogEventDto();
                        eventDto.setNewest(dto);
                        eventDto.setOriginal(oldMap.getOrDefault(dto.getId(), new AuditExecuteIndicatorVo()));
                        editLogs.add(eventDto);
                    }
                    Collection<AuditExecuteIndicator> res = this.nebulaToolkitService.copyCollectionByWhiteList(
                            list, AuditExecuteIndicatorDto.class, AuditExecuteIndicator.class, LinkedHashSet.class, ArrayList.class);
                    this.auditExecuteIndicatorRepository.updateBatchByIdAndTenantCode(res, TenantUtils.getTenantCode());
                }
            }

            //新增日志
            if (!CollectionUtils.isEmpty(addList)) {
                log.info("开始执行大批量保存-----------------新增日志");
                auditExecuteIndicatorLogService.addLogAsync(addList);
            }
            //编辑日志
            if (!CollectionUtils.isEmpty(editLogs)) {
                log.info("开始执行大批量保存-----------------编辑日志");
                auditExecuteIndicatorLogService.updateLogAsync(editLogs);
            }
        } catch (Exception e) {
            log.error("", e);
            throw new NullPointerException(e.getMessage());
        }
    }

    @Override
    public List<AuditExecuteIndicatorVo> findListByCondition(AuditExecuteIndicatorDto dto) {

        List<AuditExecuteIndicator> auditExecuteIndicatorList = this.auditExecuteIndicatorRepository.findListByCondition(dto);
        if (CollectionUtils.isEmpty(auditExecuteIndicatorList)) {
            return new ArrayList<>();
        }

        Collection<AuditExecuteIndicatorVo> auditExecuteIndicatorVos = this.nebulaToolkitService.copyCollectionByBlankList(auditExecuteIndicatorList, AuditExecuteIndicator.class, AuditExecuteIndicatorVo.class, LinkedHashSet.class, ArrayList.class);
        return (List<AuditExecuteIndicatorVo>) auditExecuteIndicatorVos;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void bulkSaveOrUpdate(List<AuditExecuteIndicatorDto> saveList, List<AuditExecuteIndicatorDto> updateList) {

        if (!CollectionUtils.isEmpty(saveList)) {
            //分批保存
            List<List<AuditExecuteIndicatorDto>> indicators = Lists.partition(saveList, 500);
            for (List<AuditExecuteIndicatorDto> list : indicators) {
                List<AuditExecuteIndicator> entyList =
                        (List<AuditExecuteIndicator>) nebulaToolkitService.copyCollectionByWhiteList(list, AuditExecuteIndicatorDto.class, AuditExecuteIndicator.class, HashSet.class, ArrayList.class);
                entyList.forEach(a->a.setIndicatorValue(Optional.ofNullable(a.getIndicatorValue()).orElse(BigDecimal.ZERO)));
                /*List<String> verticalItemCodes = entyList.stream().filter(k -> k.getActiveNumber().startsWith(ActivityDetailPlanConstant.ACTIVITY_DETAIL_PLAN_ITEM_RULE_CODE_PRE)).map(AuditExecuteIndicator::getActiveNumber).filter(Objects::nonNull).collect(Collectors.toList());
                List<String> subItemCodes = entyList.stream().filter(k -> k.getActiveNumber().startsWith(SubComActivityDetailPlanConstant.ACTIVITY_CONST_DETAIL_PLAN_PROMOTION_NO)).map(AuditExecuteIndicator::getActiveNumber).filter(Objects::nonNull).collect(Collectors.toList());
                if(!CollectionUtils.isEmpty(verticalItemCodes)){

                }
                if(!CollectionUtils.isEmpty(subItemCodes)){}*/

                this.auditExecuteIndicatorRepository.saveBatch(entyList);
            }
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            //分批更新
            List<List<AuditExecuteIndicatorDto>> indicators = Lists.partition(updateList, 500);
            for (List<AuditExecuteIndicatorDto> list : indicators) {
                List<AuditExecuteIndicator> entyList =
                        (List<AuditExecuteIndicator>) nebulaToolkitService.copyCollectionByWhiteList(list, AuditExecuteIndicatorDto.class, AuditExecuteIndicator.class, HashSet.class, ArrayList.class);
                entyList.forEach(a->a.setIndicatorValue(Optional.ofNullable(a.getIndicatorValue()).orElse(BigDecimal.ZERO)));
                this.auditExecuteIndicatorRepository.updateBatchById(entyList);
            }
        }

    }

    @Override
    public void queryAllExecutionSapBranch() {
        sapActivityExecution.queryAllExecutionSapBranch();
    }

    @Override
    public void queryExecutionSapBranch(String orgCode, String itemCode, String activityDate) {
        sapActivityExecution.queryExecutionSapBranch(orgCode, itemCode, activityDate);
    }

    /**
     * 根据活动细案明细编码+指标名称查询
     *
     * @param activeNumber
     * @return
     */
    @Override
    public List<AuditExecuteIndicatorVo> findByCode(String activeNumber, String indicatorName) {
        List<AuditExecuteIndicator> auditExecuteIndicatorList = this.auditExecuteIndicatorRepository.findByCode(activeNumber, indicatorName);
        if (CollectionUtils.isEmpty(auditExecuteIndicatorList)) {
            return new ArrayList<>();
        }
        Collection<AuditExecuteIndicatorVo> auditExecuteIndicatorVos = this.nebulaToolkitService.copyCollectionByBlankList(auditExecuteIndicatorList, AuditExecuteIndicator.class, AuditExecuteIndicatorVo.class, LinkedHashSet.class, ArrayList.class);
        return (List<AuditExecuteIndicatorVo>) auditExecuteIndicatorVos;
    }

    /**
     * 根据活动细案明细编码+指标名称查询
     */
    @Override
    public List<AuditExecuteIndicatorVo> findByCodeList(List<String> activeNumberList, String indicatorName) {
        List<AuditExecuteIndicatorVo> auditExecuteIndicatorList = this.auditExecuteIndicatorRepository.findByCodeList(activeNumberList, indicatorName);
        if (CollectionUtils.isEmpty(auditExecuteIndicatorList)) {
            return new ArrayList<>();
        }
        return auditExecuteIndicatorList;
    }

    /**
     * 时间+客户+销售组织维度查询数据
     *
     * @param dto
     * @return
     */
    @Override
    public List<AuditExecuteIndicatorVo> findData(AuditExecuteIndicatorDto dto) {
        if (ObjectUtils.isEmpty(dto)) {
            return new ArrayList<>();
        }
        List<AuditExecuteIndicator> auditExecuteIndicatorList = this.auditExecuteIndicatorRepository.findData(dto);
        if (CollectionUtils.isEmpty(auditExecuteIndicatorList)) {
            return new ArrayList<>();
        }
        return (List<AuditExecuteIndicatorVo>) this.nebulaToolkitService.copyCollectionByBlankList(auditExecuteIndicatorList, AuditExecuteIndicator.class, AuditExecuteIndicatorVo.class, LinkedHashSet.class, ArrayList.class);
    }

    /**
     *
     * @param activeNumbers 明细编码集合
     * @param dockingSystem 来源系统
     * @param businessUnitCode 业务单元
     * @return
     */
    @Override
    public List<AuditExecuteIndicatorVo> findByActiveNumber(List<String> activeNumbers,String dockingSystem,String businessUnitCode) {
        if (CollectionUtils.isEmpty(activeNumbers) || StringUtils.isBlank(dockingSystem) || StringUtils.isBlank(businessUnitCode)) {
            return Lists.newArrayList();
        }
        List<AuditExecuteIndicatorVo> indicatorVoList = auditExecuteIndicatorRepository.findByActiveNumber(activeNumbers, dockingSystem, businessUnitCode);
        if (CollectionUtils.isEmpty(indicatorVoList)) {
           return Lists.newArrayList();
        }
        return indicatorVoList;
    }

    /**
     * 通过唯一维度查询Id
     *
     * @param onlyKeys 唯一维度拼接编码列表
     * @return Map<String, String>
     */
    @Override
    public Map<String, String> findByOnlyKeys(List<String> onlyKeys) {
        if (CollectionUtils.isEmpty(onlyKeys)) {
            return Maps.newHashMap();
        }
        List<List<String>> keys = Lists.partition(onlyKeys, 500);
        List<AuditExecuteIndicatorOnlyKeyVo> list = auditExecuteIndicatorRepository.findByOnlyKeys(keys,TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        return list.stream().collect(Collectors.toMap(AuditExecuteIndicatorOnlyKeyVo::getOnlyKey, AuditExecuteIndicatorOnlyKeyVo::getId,
                (oldValue, newValue) -> newValue));
    }

    /**
     * 查询sap发生额通过活动细案编码
     *
     * @param itemNos 细案明细编码
     * @param nameType 名字映射数据字典编码
     * @return Map<String, BigDecimal>
     **/
    @Override
    public Map<String, BigDecimal> getSapAmountByDetailItemNos(List<String> itemNos, String nameType) {
        if (CollectionUtils.isEmpty(itemNos)) {
            return Maps.newHashMap();
        }
        Validate.notBlank(nameType, "未指定查询名称类型");
        //获取数据字典
        Map<String,String> dictMap = this.dictToolkitService.findMapByDictTypeCode(AuditExecuteIndicatorConstant.TPM_IMPLEMENTATION_INDICATORS);
        if (!dictMap.containsKey(nameType)) {
            return Maps.newHashMap();
        }
        List<AuditExecuteIndicator> list = this.auditExecuteIndicatorRepository.lambdaQuery()
                .eq(AuditExecuteIndicator::getDelFlag,DelFlagStatusEnum.NORMAL.getCode())
                .in(AuditExecuteIndicator::getActiveNumber,itemNos)
                .eq(AuditExecuteIndicator::getIndicatorName,nameType)
                .eq(AuditExecuteIndicator::getTenantCode,TenantUtils.getTenantCode())
                .list();
        if(CollectionUtils.isEmpty(list)){
            return Maps.newHashMap();
        }
        Map<String, BigDecimal> map = new HashMap<>();
        for (AuditExecuteIndicator indicator : list) {
            if(null == indicator.getIndicatorValue()){
                indicator.setIndicatorValue(BigDecimal.ZERO);
            }
            if(map.containsKey(indicator.getActiveNumber())){
                BigDecimal b = map.get(indicator.getActiveNumber()).add(indicator.getIndicatorValue());
                map.put(indicator.getActiveNumber(),b);
            }else {
                map.put(indicator.getActiveNumber(),indicator.getIndicatorValue());
            }
        }
        log.error("sap发生额数据：{},组装map：{}",list,map);
        return map;
    }

    /**
     * 查询sap发生额和发生两量通过活动细案编码
     *
     * @param itemNos 细案明细编码
     * @return List<AuditExecuteIndicatorVo>
     **/
    @Override
    public List<AuditExecuteIndicatorVo> getSapAmountAndQuantityByDetailItemNos(List<String> itemNos) {
        if (CollectionUtils.isEmpty(itemNos)) {
            return Lists.newArrayList();
        }
        List<String> nameList = new ArrayList<>();
        nameList.add(AuditExecuteIndicatorConstant.DICT_VALUE_SAP_OCCURRENCE_AMOUNT);
        nameList.add(AuditExecuteIndicatorConstant.DICT_VALUE_SAP_OCCURRENCE_QUANTITY);
        List<AuditExecuteIndicator> list = this.auditExecuteIndicatorRepository.lambdaQuery()
                .eq(AuditExecuteIndicator::getDelFlag,DelFlagStatusEnum.NORMAL.getCode())
                .in(AuditExecuteIndicator::getActiveNumber,itemNos)
                .in(AuditExecuteIndicator::getIndicatorName,nameList)
                .eq(AuditExecuteIndicator::getTenantCode,TenantUtils.getTenantCode())
                .list();
        if(CollectionUtils.isEmpty(list)){
            return Lists.newArrayList();
        }
        return new ArrayList<>(this.nebulaToolkitService.copyCollectionByWhiteList(list,AuditExecuteIndicator.class,AuditExecuteIndicatorVo.class,HashSet.class,ArrayList.class));
    }

    /**
     * 指标取数
     *
     * @param dto
     * @return
     */
    @Override
    public List<AuditExecuteIndicatorVo> findListForVariable(AuditExecuteIndicatorDto dto) {
        List<AuditExecuteIndicator> auditExecuteIndicatorList = this.auditExecuteIndicatorRepository.findListForVariable(dto);
        if (CollectionUtils.isEmpty(auditExecuteIndicatorList)) {
            return new ArrayList<>();
        }

        Collection<AuditExecuteIndicatorVo> auditExecuteIndicatorVos = this.nebulaToolkitService.copyCollectionByBlankList(auditExecuteIndicatorList, AuditExecuteIndicator.class, AuditExecuteIndicatorVo.class, LinkedHashSet.class, ArrayList.class);
        return (List<AuditExecuteIndicatorVo>) auditExecuteIndicatorVos;
    }

    /**
     * 人员工资
     *
     * @param dto 参数
     * @return List<AuditExecuteIndicatorVo>
     **/
    @Override
    public List<AuditExecuteIndicatorVo> getPersonnelWage(AuditExecuteIndicatorDto dto) {
        List<AuditExecuteIndicator> list = this.auditExecuteIndicatorRepository.getPersonnelWage(dto);
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<>();
        }
        Collection<AuditExecuteIndicatorVo> voList = this.nebulaToolkitService.copyCollectionByBlankList(list, AuditExecuteIndicator.class, AuditExecuteIndicatorVo.class, LinkedHashSet.class, ArrayList.class);
        return (List<AuditExecuteIndicatorVo>) voList;
    }

    /**
     *  查询sap发生量、sap发生额 根据细案明细编码
     *
     * @param detailPlanItemCodes
     * @return
     */
    @Override
    public List<AuditExecuteIndicatorSdkVo> findSapDataByActiveNumbers(List<String> detailPlanItemCodes,List<String> indicatorNames) {
        if (CollectionUtils.isEmpty(detailPlanItemCodes) || CollectionUtils.isEmpty(indicatorNames)) {
            return new ArrayList<>();
        }
        List<AuditExecuteIndicator> list = auditExecuteIndicatorRepository.findSapDataByActiveNumbers(detailPlanItemCodes,indicatorNames);
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<>();
        }
        return (List<AuditExecuteIndicatorSdkVo>) this.nebulaToolkitService.copyCollectionByBlankList(list, AuditExecuteIndicator.class, AuditExecuteIndicatorSdkVo.class, LinkedHashSet.class, ArrayList.class);
    }

    @Override
    public List<AuditExecuteIndicatorVo> getMinusCompostQuantity(List<String> detailPlanItemCodes) {
        if(CollectionUtils.isEmpty(detailPlanItemCodes)){
            return Lists.newArrayList();
        }
        AuditExecuteIndicatorDto dto = new AuditExecuteIndicatorDto();
        dto.setDetailPlanItemCodes(detailPlanItemCodes);
        dto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
        dto.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
        dto.setDockingSystem(AuditExecuteIndicatorConstant.COW_MANAGER);
        dto.setIndicatorName(IndicatorNameEnum.DEDUCTION_QUANTITY.getCode());
        return this.auditExecuteIndicatorRepository.getMinusCompostQuantity(dto);
    }
}
